/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.external;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.architecture.external.ArchitectureChangeSquasher;
import com.teamscale.index.architecture.external.ArchitectureUploadInfo;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.index.external.update.ExternalUploadPersisterBase;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.history.EChangeEntryOrigin;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.UploadedArchitectureTokenElementDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class ExternalArchitectureUploadPersister
extends ExternalUploadPersisterBase<ArchitectureUploadInfo> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String REVISION_PREFIX = "Architecture Analysis";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="content")
    private TokenElementIndex contentIndex;
    @BranchingLayerAccess(value=ExternalArchitectureUploadIndex.class)
    private IBranchingLayer externalArchitectureUploadBranchingLayer;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="external-architecture-commit-tree")
    private CommitTreeIndex commitTreeIndex;
    @DeltaSource(value=CommitTreeIndex.class, indexName="external-architecture-commit-tree")
    private KeyDelta commitTreeDelta;

    @Override
    protected KeyDelta getCommitTreeDelta() {
        return this.commitTreeDelta;
    }

    @Override
    protected void processCommitsForNodes(List<ICommitTreeNode> commitTreeNodes) throws StorageException {
        ArchitectureUploadInfo uploadInfo = null;
        ArchitectureChangeSquasher architectureChangeSquasher = new ArchitectureChangeSquasher();
        for (ICommitTreeNode node : commitTreeNodes) {
            uploadInfo = (ArchitectureUploadInfo)this.getExternalUploadIndex(node).getCommitInfo();
            this.processUploadInfo(uploadInfo, architectureChangeSquasher, node);
        }
        this.storeSquashedChanges(architectureChangeSquasher);
        if (uploadInfo != null) {
            CounterSet counterSet = new CounterSet((Collection)CollectionUtils.map(architectureChangeSquasher.getOperationsByPath().values(), ArchitectureChangeSquasher.UniformPathChange::getRepositoryChangeType));
            this.writeRepositoryLogEntry(this.getSchedulingCommit(), REVISION_PREFIX, uploadInfo.getMessage(), uploadInfo.getUsername(), counterSet.getValue((Object)ERepositoryChangeType.ADD), counterSet.getValue((Object)ERepositoryChangeType.EDIT), counterSet.getValue((Object)ERepositoryChangeType.DELETE));
        }
    }

    private void storeSquashedChanges(ArchitectureChangeSquasher architectureChangeSquasher) throws StorageException {
        Map<UniformPath, ArchitectureChangeSquasher.UniformPathChange> operationsByPath = architectureChangeSquasher.getOperationsByPath();
        PairList historyValues = new PairList(operationsByPath.size());
        ArrayList<RepositoryLogFileEntry> logFileEntries = new ArrayList<RepositoryLogFileEntry>(operationsByPath.size());
        PairList contentValues = new PairList();
        ArrayList<UniformPath> removedContentElements = new ArrayList<UniformPath>();
        TokenElementIndexCache tokenIndexCache = this.createTokenIndexCache(operationsByPath);
        for (Map.Entry<UniformPath, ArchitectureChangeSquasher.UniformPathChange> entry : operationsByPath.entrySet()) {
            UniformPath uniformPath = entry.getKey();
            ArchitectureChangeSquasher.UniformPathChange uniformPathChange = entry.getValue();
            ERepositoryChangeType changeType = uniformPathChange.getRepositoryChangeType();
            boolean isDelete = changeType == ERepositoryChangeType.DELETE;
            boolean architectureExists = tokenIndexCache.getTokenElementInfo(uniformPath) != null;
            historyValues.add((Object)uniformPath, (Object)new ElementHistoryEntry(changeType.toHistoryChangeType(), this.getSchedulingCommit(), EChangeEntryOrigin.SQUASHED_ARCHITECTURE_CHANGES));
            logFileEntries.add(new RepositoryLogFileEntry(this.getSchedulingCommit(), uniformPath, ECommitType.ARCHITECTURE_CHANGE, null, isDelete));
            if (isDelete) {
                if (architectureExists) {
                    removedContentElements.add(uniformPath);
                    continue;
                }
                LOGGER.warn("Ignored attempt to delete non-existing architecture: " + String.valueOf(uniformPath));
                continue;
            }
            String uniformPathAsString = uniformPath.toStringAsMigrationFrontier();
            contentValues.add((Object)uniformPathAsString, (Object)ExternalArchitectureUploadPersister.createTokenElement(uniformPathAsString, uniformPathChange));
        }
        this.persistSquashedChanges((PairList<UniformPath, ElementHistoryEntry>)historyValues, logFileEntries, (PairList<String, TokenElementInfo>)contentValues, removedContentElements);
    }

    private TokenElementIndexCache createTokenIndexCache(Map<UniformPath, ArchitectureChangeSquasher.UniformPathChange> operationsByPath) throws StorageException {
        return new TokenElementIndexCache(this.contentIndex, new ArrayList<UniformPath>(operationsByPath.keySet()));
    }

    private void persistSquashedChanges(PairList<UniformPath, ElementHistoryEntry> historyValues, List<RepositoryLogFileEntry> logFileEntries, PairList<String, TokenElementInfo> contentValues, List<UniformPath> removedContentElements) throws StorageException {
        this.logFileIndex.insertEntries(logFileEntries);
        this.elementHistoryIndex.setHistoryEntries((PairList<String, ElementHistoryEntry>)UniformPathCompatibilityUtil.convertPairList(historyValues));
        this.contentIndex.setTokenElements(contentValues);
        this.contentIndex.removeTokenElements(UniformPathCompatibilityUtil.asUniformPathStrings(removedContentElements));
    }

    private static TokenElementInfo createTokenElement(String uniformPathAsString, ArchitectureChangeSquasher.UniformPathChange uniformPathChange) {
        CCSMAssert.isFalse((uniformPathChange.getRepositoryChangeType() == ERepositoryChangeType.DELETE ? 1 : 0) != 0, (String)"Cannot create token element for deleted path");
        if (uniformPathChange.getContent().isPresent()) {
            return TokenElementInfo.createWithLocalPreprocessing(uniformPathAsString, ELanguage.XML, false, uniformPathChange.getContent().get(), (List<Deletion>)CollectionUtils.emptyList(), Collections.singletonList(new UploadedArchitectureTokenElementDetail()));
        }
        throw new AssertionError((Object)("Content was null for " + uniformPathAsString + " (Change: " + String.valueOf((Object)uniformPathChange.getRepositoryChangeType()) + ")"));
    }

    private void processUploadInfo(ArchitectureUploadInfo uploadInfo, ArchitectureChangeSquasher architectureChangeSquasher, ICommitTreeNode commitTreeNode) throws StorageException {
        IBranchCommitInfo commitInfo = this.getBranchCommitInfo(commitTreeNode);
        Set<String> existingArchitectures = this.getExistingArchitectures(commitInfo);
        List<String> uniformPaths = uploadInfo.getUniformPaths();
        HashSet<String> editedArchitectures = new HashSet<String>(uniformPaths);
        editedArchitectures.retainAll(existingArchitectures);
        for (int i = 0; i < uniformPaths.size(); ++i) {
            String architectureXml = uploadInfo.getArchitectures().get(i);
            String uniformPath = uniformPaths.get(i);
            architectureChangeSquasher.reportAddOrEdit(UniformPathCompatibilityUtil.convert((String)uniformPath), architectureXml, editedArchitectures.contains(uniformPath));
        }
        uploadInfo.getDeletedArchitectures().stream().map(UniformPathCompatibilityUtil::convert).forEach(architectureChangeSquasher::reportDelete);
    }

    private IBranchCommitInfo getBranchCommitInfo(ICommitTreeNode commitTreeNode) throws StorageException {
        return this.externalArchitectureUploadBranchingLayer.readCommit(commitTreeNode.getRevision().getBranchName(), commitTreeNode.getOriginalTimestamp());
    }

    @Override
    protected String getRepositoryIdentifier() {
        return "architecture upload";
    }

    @Override
    protected ECommitType getCommitType() {
        return ECommitType.ARCHITECTURE_CHANGE;
    }

    @Override
    protected CommitTreeIndex getCommitTreeIndex() {
        return this.commitTreeIndex;
    }

    private Set<String> getExistingArchitectures(IBranchCommitInfo commitInfo) throws StorageException {
        if (commitInfo.getParentCommitBranchAndTimestamp() == null) {
            return new HashSet<String>();
        }
        Pair branchNameAndTimestamp = commitInfo.getParentCommitBranchAndTimestamp();
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)((String)branchNameAndTimestamp.getFirst()), (long)((Long)branchNameAndTimestamp.getSecond()));
        ExternalArchitectureUploadIndex externalArchitectureUploadPrevIndex = this.createExternalUploadIndex(this.externalArchitectureUploadBranchingLayer.openStore(historyAccessOption));
        return new HashSet<String>(externalArchitectureUploadPrevIndex.getAllArchitecturePaths());
    }

    @Override
    protected IBranchingLayer getExternalUploadBranchingLayer() {
        return this.externalArchitectureUploadBranchingLayer;
    }

    protected ExternalArchitectureUploadIndex getExternalUploadIndex(ICommitTreeNode node) throws StorageException {
        return (ExternalArchitectureUploadIndex)super.getExternalUploadIndex(node);
    }

    protected ExternalArchitectureUploadIndex createExternalUploadIndex(IStore baseStore) {
        return new ExternalArchitectureUploadIndex(baseStore);
    }
}

