/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.audit.checks;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(name="Custom Exception Definition", groupName="Exception Handling", defaultEnablement=EFindingEnablement.OFF, languages={ELanguage.VB, ELanguage.CS, ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CustomExceptionDefinitionCheck
extends CheckImplementationBase {
    public static final String CHECK_NAME = "Custom Exception Definition";
    public static final String GROUP_NAME = "Exception Handling";
    public static final String MESSAGE_PREFIX = "Custom Exception Definition which inherits from: ";
    private static final int MATCHING_GROUP_NAME = 0;
    private static final TokenPattern VB_INHERITS_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.CLASS, ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).sequence(new Object[]{ETokenType.INHERITS});
    private static final TokenPattern CLASS_DEFINITION_WITH_SUPERCLASS_PATTERN = new TokenPattern().alternative(new Object[]{LanguageFeatureParser.JAVA.classExtendsPattern(), LanguageFeatureParser.CS.classExtendsPattern(), VB_INHERITS_PATTERN}).sequence(new Object[]{ETokenType.IDENTIFIER, new TokenPattern().repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER})}).group(0);

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processTokens((List<IToken>)type.ownStartTokens());
            this.processTokens((List<IToken>)type.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        for (TokenPatternMatch match : CLASS_DEFINITION_WITH_SUPERCLASS_PATTERN.findAll(tokens)) {
            List matchedTokens = match.groupTokens(0);
            IToken baseClassToken = (IToken)CollectionUtils.getLast((List)matchedTokens);
            if (baseClassToken == null || !CustomExceptionDefinitionCheck.isExceptionClassName(baseClassToken)) continue;
            this.buildFinding(this.getFindingMessage(Collections.singletonList(baseClassToken)), this.buildLocation().betweenTokens(tokens.get(0), baseClassToken)).createAndStore();
        }
    }

    private static boolean isExceptionClassName(IToken token) {
        return token.getText().endsWith("Exception") || token.getText().endsWith("Error") || token.getText().equals("Throwable");
    }

    private String getFindingMessage(List<IToken> tokens) {
        return MESSAGE_PREFIX + tokens.stream().map(IToken::getText).collect(Collectors.joining(", "));
    }
}

