/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.index.backup.BackupInfo;
import java.net.URI;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.SystemUtils;

public class BackupLocationInfo {
    public static final DateTimeFormatter BACKUP_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
    private static final Pattern PATH_PART_SANITIZE_PATTERN = Pattern.compile("[^a-zA-Z0-9_-]");
    private final InstanceConfiguration instanceConfiguration;
    private final String outputUri;
    private final String backupIdentifierPrefix;
    private final String backupIdentifierSuffix;

    public BackupLocationInfo(InstanceConfiguration instanceConfiguration, String storageLocation, ZonedDateTime now) {
        this.instanceConfiguration = instanceConfiguration;
        String instanceSpecificUri = this.getInstanceSpecificOutputUri(storageLocation);
        String[] parts = instanceSpecificUri.split("%t");
        if (parts.length == 1) {
            this.backupIdentifierPrefix = instanceSpecificUri;
            this.backupIdentifierSuffix = "";
        } else {
            CCSMAssert.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)"Expected exactly one timestamp placeholder.");
            this.backupIdentifierPrefix = parts[0];
            this.backupIdentifierSuffix = parts[1];
        }
        this.outputUri = instanceSpecificUri.replaceAll("%t", now.format(BACKUP_DATE_TIME_FORMATTER));
    }

    private String getInstanceSpecificOutputUri(String outputPath) {
        CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)outputPath), (String)"Storage location of backup in option may not be empty!");
        outputPath = outputPath.replaceAll("%h", SystemUtils.getHostName());
        outputPath = outputPath.replaceAll("%p", this.getConfiguredPort());
        outputPath = outputPath.replaceAll("%i", BackupLocationInfo.sanitizePathPart(this.instanceConfiguration.getInstanceName()));
        outputPath = outputPath.replaceAll("%u", BackupLocationInfo.sanitizePathPart(this.instanceConfiguration.getUrlPrefix()));
        return outputPath;
    }

    private String getConfiguredPort() {
        int port = this.instanceConfiguration.getHttpsPort().orElseGet(() -> this.instanceConfiguration.getHttpPort().orElse(0));
        return Integer.toString(port);
    }

    private static @NonNull String sanitizePathPart(@Nullable String part) {
        if (StringUtils.isEmpty((String)part)) {
            return "";
        }
        return StringUtils.replaceAll((String)part, (Pattern)PATH_PART_SANITIZE_PATTERN, (String)"_");
    }

    public boolean isBackupsOfCurrentTeamscaleInstance(BackupInfo backupInfo) {
        String absolutePrefix;
        String backupIdentifier = FileSystemUtils.normalizeSeparators((String)backupInfo.getBackupIdentifier());
        String backupPrefix = this.backupIdentifierPrefix;
        if (this.backupIdentifierPrefix.startsWith("file:/")) {
            URI uri = URI.create(FileSystemUtils.normalizeSeparators((String)this.backupIdentifierPrefix));
            backupPrefix = Path.of(uri).toString();
        }
        return backupIdentifier.startsWith(absolutePrefix = FileSystemUtils.normalizeSeparators((String)Path.of(backupPrefix, new String[0]).toAbsolutePath().toString())) && backupIdentifier.endsWith(this.backupIdentifierSuffix);
    }

    public boolean hasSameSuffixAsCurrentTeamscaleInstance(BackupInfo backupInfo) {
        String backupIdentifier = FileSystemUtils.normalizeSeparators((String)backupInfo.getBackupIdentifier());
        return backupIdentifier.endsWith(this.backupIdentifierSuffix);
    }

    public String getBackupIdentifierPrefix() {
        return this.backupIdentifierPrefix;
    }

    public String getOutputUri() {
        return this.outputUri;
    }
}

