/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.index.backup.IBackupStatusIndex;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;

public abstract class StatusReportingTriggerBase<STATUS_CLASS extends Serializable, INDEX extends IBackupStatusIndex<STATUS_CLASS> & IGlobalIndex>
extends MaintenanceTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long STATUS_UPDATE_PERIOD_SECONDS = 5L;
    private final Class<INDEX> indexClass;
    private INDEX statusIndex;
    private String statusId;
    protected STATUS_CLASS status;
    private byte[] previousSerializedStatus = new byte[0];

    protected StatusReportingTriggerBase(Class<INDEX> indexClass) {
        this.indexClass = indexClass;
    }

    public final void execute() throws Exception {
        this.statusIndex = (IBackupStatusIndex)this.indexLayer.openGlobalIndex(this.indexClass);
        this.statusId = this.jobDescriptor.getParameter();
        if (StringUtils.isEmpty((CharSequence)this.statusId)) {
            LOGGER.error("Could not find status id for this job!");
            return;
        }
        this.status = (Serializable)this.statusIndex.getStatus(this.statusId);
        if (this.status == null) {
            LOGGER.error("Could not find status description for id " + this.statusId);
            return;
        }
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> statusUpdater = scheduler.scheduleAtFixedRate(this::updateStatus, 5L, 5L, TimeUnit.SECONDS);
        try {
            this.performAction();
        }
        finally {
            statusUpdater.cancel(true);
            this.updateStatus();
            scheduler.shutdown();
        }
    }

    private void updateStatus() {
        try {
            byte[] serialized = StorageUtils.serialize(this.status);
            if (Arrays.equals(serialized, this.previousSerializedStatus)) {
                return;
            }
            this.previousSerializedStatus = serialized;
            this.statusIndex.setStatus(this.statusId, this.status);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to update status: " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void performAction() throws Exception;
}

