/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.instance;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.admin.instance_import.InstanceCredentials;
import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.ReadCachedBackupTargetBase;
import com.teamscale.index.backup.write.BackupExportStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.Streaming;

public class InstanceBackupTarget
extends ReadCachedBackupTargetBase {
    public static final String PREFIX = "ts+";
    private final String backupId;
    private final IBackupExportService exportService;

    public InstanceBackupTarget(URI uri, InstanceCredentials instanceCredentials, Logger interactionLogger) throws StorageException {
        String path = uri.toString();
        if (!path.startsWith(PREFIX)) {
            throw new StorageException("InstanceBackupTarget uri needs to start with %s.".formatted(PREFIX));
        }
        path = path.substring(PREFIX.length());
        this.backupId = path.substring(path.lastIndexOf(47) + 1);
        this.exportService = (IBackupExportService)Retrofit.builder((String)path).withBasicNTLMAuthentication(instanceCredentials.getUsername(), instanceCredentials.getApiToken()).withInteractionLogger(interactionLogger).create(IBackupExportService.class);
    }

    @Override
    public String validate() {
        try {
            if (InstanceBackupTarget.isNotAuthenticated(this.exportService.getStatusHead().execute().code())) {
                return "The user is not authenticated to access the status of the backup %s.".formatted(this.backupId);
            }
            if (InstanceBackupTarget.isNotAuthenticated(this.exportService.getDownloadHead().execute().code())) {
                return "The user is not authenticated to download the backup %s.".formatted(this.backupId);
            }
        }
        catch (IOException e) {
            return "The remote teamscale instance is not reachable.";
        }
        return null;
    }

    private static boolean isNotAuthenticated(int code) {
        return code == 401 || code == 403;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("It is not possible to write to a remote instance.");
    }

    @Override
    protected void writeToTemporaryFile(File temporaryFile) throws IOException {
        try {
            this.waitForBackupToFinishAtRemote();
        }
        catch (ServiceCallException e) {
            throw new IOException(e);
        }
        try (InputStream input = this.readBackupFromRemote();
             FileOutputStream output = new FileOutputStream(temporaryFile);){
            FileSystemUtils.copy((InputStream)input, (OutputStream)output);
        }
    }

    private void waitForBackupToFinishAtRemote() throws ServiceCallException {
        EBackupStatus status;
        block5: while (true) {
            status = this.exportService.getStatus().getStatus();
            switch (status) {
                case SUCCESS: {
                    return;
                }
                case FAILURE: {
                    throw new ServiceCallException("Backup could not be created at the remote instance.");
                }
                case IN_PROGRESS: {
                    InstanceBackupTarget.waitForBackupExport();
                    continue block5;
                }
            }
            break;
        }
        throw new ServiceCallException("Unknown status '" + status.name() + "'.");
    }

    private static void waitForBackupExport() throws ServiceCallException {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            throw new ServiceCallException((Throwable)e);
        }
    }

    private InputStream readBackupFromRemote() throws IOException {
        ResponseBody body;
        Response response = this.exportService.download().execute();
        if (response.isSuccessful() && (body = (ResponseBody)response.body()) != null) {
            return body.byteStream();
        }
        throw new IOException("The backup could not be downloaded from the remote instance");
    }

    @Override
    public void deleteBackupFile() {
    }

    @Override
    public List<BackupInfo> getBackupsInSameLocation(BackupLocationInfo backupLocationInfo) {
        return Collections.emptyList();
    }

    @Override
    public void deleteBackupsInSameLocation(List<BackupInfo> backupInfos) {
    }

    private static interface IBackupExportService
    extends IRetrofitApi {
        @GET(value="status")
        public BackupExportStatus getStatus() throws ServiceCallException;

        @HEAD(value="status")
        public Call<Void> getStatusHead();

        @GET(value="download")
        @Streaming
        public Call<ResponseBody> download();

        @HEAD(value="download")
        public Call<Void> getDownloadHead();
    }
}

