/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.tempfile;

import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.IBackupTarget;
import com.teamscale.index.backup.TemporaryFileIndex;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class TemporaryFileIndexBackupTarget
implements IBackupTarget {
    public static final String SCHEME = "index";
    private final String name;
    private final TemporaryFileIndex fileIndex;

    public TemporaryFileIndexBackupTarget(URI uri, TemporaryFileIndex fileIndex) {
        this.name = StringUtils.stripPrefix((String)uri.getPath(), (String)"/");
        this.fileIndex = fileIndex;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String validate() {
        return null;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fileIndex.writeFile(this.name);
    }

    @Override
    public SeekableByteChannel getReadChannel() throws IOException {
        try {
            return this.fileIndex.openReadChannel(this.name);
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteBackupFile() throws IOException {
        try {
            this.fileIndex.deleteFile(this.name);
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Optional<File> getLocalFile() {
        return Optional.empty();
    }

    @Override
    public List<BackupInfo> getBackupsInSameLocation(BackupLocationInfo backupLocationInfo) {
        throw new UnsupportedOperationException("The backup target " + TemporaryFileIndexBackupTarget.class.getName() + " doesn't support retrieving the backups in the same location as the backup target.");
    }

    @Override
    public void deleteBackupsInSameLocation(List<BackupInfo> backupInfos) {
        throw new UnsupportedOperationException("The backup target " + TemporaryFileIndexBackupTarget.class.getName() + " doesn't support deleting backups in the same location as the backup target.");
    }

    public static URI buildURI(String name) {
        try {
            return new URI(SCHEME, null, "/" + name, null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }
}

