/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.check;

import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

public abstract class CheckPhaseResultIndexBase
extends IndexBase {
    private static final int NULL_MARKER = -1;
    private static final int TEXT_REGION_LOCATION_MARKER = -2;
    private final ConcurrentMap<Class<? extends IGlobalExtractionPhase<?, ?>>, IGlobalExtractionPhase<?, ?>> phasesCache = new ConcurrentHashMap();
    private final TwoDimHashMap<Class<? extends IGlobalExtractionPhase<?, ?>>, String, List<RawExtractedValue<?>>> cachedValues = new TwoDimHashMap();
    private final ConcurrentMap<Class<? extends IGlobalExtractionPhase<?, ?>>, List<String>> cachedKeys = new ConcurrentHashMap();
    private final Map<String, Integer> phaseIdCache = new HashMap<String, Integer>();

    protected CheckPhaseResultIndexBase(IStore store) {
        super(store);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected <T> byte[] serializeValueList(List<T> values, Function<T, String> valueOrUniformPathAccessor, Function<T, Serializable> additionalInformationAccessor) throws StorageException {
        List valuesOrUniformPaths = CollectionUtils.map(values, value -> {
            String valueOrUniformPath = (String)valueOrUniformPathAccessor.apply(value);
            CCSMAssert.isNotNull((Object)valueOrUniformPath, (String)("Got null from accessor for value " + String.valueOf(value)));
            return valueOrUniformPath;
        });
        List additionalInformations = CollectionUtils.map(values, additionalInformationAccessor);
        Map<String, Integer> abbreviationMap = this.buildAbbreviationMapForSerialization(valuesOrUniformPaths, additionalInformations);
        List abbreviatedValuesOrUniformPaths = null;
        if (this.abbreviateValuePart()) {
            abbreviatedValuesOrUniformPaths = CollectionUtils.map((Collection)valuesOrUniformPaths, abbreviationMap::get);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                for (int i = 0; i < values.size(); ++i) {
                    if (abbreviatedValuesOrUniformPaths != null) {
                        dos.writeInt((Integer)abbreviatedValuesOrUniformPaths.get(i));
                    } else {
                        dos.writeUTF((String)valuesOrUniformPaths.get(i));
                    }
                    CheckPhaseResultIndexBase.appendSerializedAdditionalInformation((Serializable)additionalInformations.get(i), abbreviationMap, dos);
                }
                dos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError("Can not happen as we work in memory!", e);
        }
    }

    private Map<String, Integer> buildAbbreviationMapForSerialization(List<String> valuesOrUniformPaths, List<Serializable> additionalInformations) throws StorageException {
        HashSet<String> allNames = new HashSet<String>();
        additionalInformations.stream().filter(info -> info != null && info.getClass() == TextRegionLocation.class).forEach(info -> allNames.add(((TextRegionLocation)info).getUniformPath()));
        if (this.abbreviateValuePart()) {
            allNames.addAll(valuesOrUniformPaths);
        }
        return this.store.getAbbreviator().buildAbbreviationMap(allNames);
    }

    private static void appendSerializedAdditionalInformation(Serializable additionalInformation, Map<String, Integer> abbreviationMap, DataOutputStream dos) throws StorageException, IOException {
        if (additionalInformation == null) {
            dos.writeInt(-1);
        } else if (additionalInformation.getClass() == TextRegionLocation.class) {
            TextRegionLocation location = (TextRegionLocation)additionalInformation;
            dos.writeInt(-2);
            dos.writeInt(abbreviationMap.get(location.getUniformPath()));
            dos.writeInt(location.getRawStartOffset());
            dos.writeInt(location.getRawEndOffset());
            dos.writeInt(location.getRawStartLine());
            dos.writeInt(location.getRawEndLine());
        } else {
            byte[] serializedAdditionalInformation = StorageUtils.serialize((Serializable)additionalInformation);
            dos.writeInt(serializedAdditionalInformation.length);
            dos.write(serializedAdditionalInformation);
        }
    }

    protected byte[] makeKeyForValue(int phaseId, String value) {
        CCSMAssert.isFalse((boolean)this.abbreviateKeyPart(), (String)"This key construction may only be used when the key part is *not* abbreviated!");
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)phaseId), StringUtils.stringToBytes((String)value)});
    }

    protected byte[] makeKeyForUniformPath(int phaseId, String uniformPath, Map<String, Integer> abbreviationMap) {
        CCSMAssert.isTrue((boolean)this.abbreviateKeyPart(), (String)"This key construction may only be used when the key part *is* abbreviated!");
        byte[] key = new byte[8];
        ByteArrayUtils.storeIntInArray((int)phaseId, (byte[])key, (int)0);
        ByteArrayUtils.storeIntInArray((int)abbreviationMap.get(uniformPath), (byte[])key, (int)4);
        return key;
    }

    protected abstract boolean abbreviateKeyPart();

    private boolean abbreviateValuePart() {
        return !this.abbreviateKeyPart();
    }

    public ListMap<String, String> splitKeys(List<StorageKey> keys) throws StorageException {
        List rawKeys = CollectionUtils.map(keys, StorageKey::getKey);
        Map<Integer, String> unabbreviationMap = this.buildUnabbreviationMapForSplitKeys(rawKeys);
        boolean abbreviateKeyPart = this.abbreviateKeyPart();
        ListMap phaseToUniformPaths = new ListMap();
        for (byte[] key : rawKeys) {
            String phase = unabbreviationMap.get(ByteArrayUtils.readIntFromStartOfArray((byte[])key));
            String pathOrValue = abbreviateKeyPart ? unabbreviationMap.get(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)4)) : StringUtils.bytesToString((byte[])key, (int)4);
            phaseToUniformPaths.add((Object)phase, (Object)pathOrValue);
        }
        return phaseToUniformPaths;
    }

    private Map<Integer, String> buildUnabbreviationMapForSplitKeys(List<byte[]> rawKeys) throws StorageException {
        boolean abbreviateKeyPart = this.abbreviateKeyPart();
        HashSet<Integer> abbreviationIndexes = new HashSet<Integer>();
        for (byte[] key : rawKeys) {
            abbreviationIndexes.add(ByteArrayUtils.readIntFromStartOfArray((byte[])key));
            if (!abbreviateKeyPart) continue;
            if (key.length != 8) {
                throw new AssertionError((Object)("Expected key size of 8 but had " + key.length));
            }
            abbreviationIndexes.add(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)4));
        }
        return this.store.getAbbreviator().buildUnabbreviationMap(abbreviationIndexes);
    }

    protected List<RawExtractedValue<?>> deserializeValueList(byte[] data, String pathOrValue, Class<? extends IGlobalExtractionPhase<?, ?>> contextClass) throws StorageException {
        ArrayList result = new ArrayList();
        try (DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));){
            while (din.available() > 0) {
                String value = this.abbreviateValuePart() ? this.store.getAbbreviator().unabbreviate(din.readInt()) : din.readUTF();
                result.add(this.createRawExtractedValue(pathOrValue, value, this.readAndDeserializeAdditionalInformation(din, contextClass)));
            }
        }
        catch (IOException e) {
            throw new AssertionError("Can not happen as we work in memory!", e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable readAndDeserializeAdditionalInformation(DataInputStream din, Class<? extends IGlobalExtractionPhase<?, ?>> contextClass) throws IOException, StorageException {
        int length = din.readInt();
        if (length == -1) {
            return null;
        }
        if (length == -2) {
            int uniformPathId = din.readInt();
            int rawStartOffset = din.readInt();
            int rawEndOffset = din.readInt();
            int rawStartLine = din.readInt();
            int rawEndLine = din.readInt();
            return new TextRegionLocation(this.store.getAbbreviator().unabbreviate(uniformPathId), rawStartOffset, rawEndOffset, rawStartLine, rawEndLine);
        }
        byte[] additionalInformation = new byte[length];
        FileSystemUtils.safeRead((InputStream)din, (byte[])additionalInformation);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(contextClass.getClassLoader());
            Serializable serializable = StorageUtils.deserialize((byte[])additionalInformation);
            return serializable;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    protected abstract <D extends Serializable> RawExtractedValue<D> createRawExtractedValue(String var1, String var2, D var3);

    private IGlobalExtractionPhase<?, ?> getPhaseFromClass(Class<? extends IGlobalExtractionPhase<?, ?>> phaseClass) throws StorageException {
        return (IGlobalExtractionPhase)CollectionUtils.computeIfAbsentWithException(this.phasesCache, phaseClass, aClass -> {
            try {
                return (IGlobalExtractionPhase)aClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new StorageException("Error when creating phase class " + String.valueOf(phaseClass) + ": " + e.getMessage(), (Throwable)e);
            }
        });
    }

    protected synchronized <T extends IExtractedValue<D>, D extends Serializable> List<IExtractedValue<D>> getValuesCachedInternal(Class<? extends IGlobalExtractionPhase<?, ?>> phaseClass, String pathOrValue) throws StorageException {
        if (!this.cachedValues.containsKey(phaseClass, (Object)pathOrValue)) {
            byte[] key = this.abbreviateKeyPart() ? this.makeKeyForUniformPath(this.getPhaseId(phaseClass.getName()), pathOrValue, this.store.getAbbreviator().buildAbbreviationMap(Set.of(pathOrValue))) : this.makeKeyForValue(this.getPhaseId(phaseClass.getName()), pathOrValue);
            byte[] data = this.store.get(key);
            List<Object> valueList = Collections.emptyList();
            if (data != null) {
                valueList = this.deserializeValueList(data, pathOrValue, phaseClass);
            }
            this.cachedValues.putValue(phaseClass, (Object)pathOrValue, valueList);
        }
        IGlobalExtractionPhase<?, ?> phase = this.getPhaseFromClass(phaseClass);
        return CollectionUtils.map((Collection)((Collection)this.cachedValues.getValue(phaseClass, (Object)pathOrValue)), rawValue -> phase.createValue(rawValue.getUniformPath(), rawValue.getValue(), rawValue.getAdditionalInformation()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPhaseId(String phaseName) throws StorageException {
        Map<String, Integer> map = this.phaseIdCache;
        synchronized (map) {
            return (Integer)CollectionUtils.computeIfAbsentWithException(this.phaseIdCache, (Object)phaseName, arg_0 -> ((StorageStringAbbreviator)this.store.getAbbreviator()).abbreviate(arg_0));
        }
    }

    protected List<String> getKeysCachedInternal(Class<? extends IGlobalExtractionPhase<?, ?>> phaseClass) throws StorageException {
        return (List)CollectionUtils.computeIfAbsentWithException(this.cachedKeys, phaseClass, this::computeKeys);
    }

    private List<String> computeKeys(Class<? extends IGlobalExtractionPhase<?, ?>> phaseClass) throws StorageException {
        ArrayList<String> result = new ArrayList<String>();
        byte[] prefix = ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(phaseClass.getName()));
        if (this.abbreviateKeyPart()) {
            List allKeys = StorageUtils.listKeysStartingWith((byte[])prefix, (IStore)this.store);
            List allIds = CollectionUtils.map((Collection)allKeys, key -> ByteArrayUtils.getIntFromByteArray((byte[])key, (int)4));
            result.addAll(this.store.getAbbreviator().unabbreviate(allIds));
        } else {
            this.store.scanKeys(prefix, (key, value) -> {
                List list = result;
                synchronized (list) {
                    result.add(StringUtils.bytesToString((byte[])key, (int)4));
                }
            });
        }
        return result;
    }

    public PairList<String, Object> debugGetEntries(String keyPrefix) throws StorageException {
        final PairList result = new PairList();
        ExceptionHandlingKeyValueCallbackBase callbackWrapper = new ExceptionHandlingKeyValueCallbackBase(){

            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                ListMap<String, String> splitResult = CheckPhaseResultIndexBase.this.splitKeys(Collections.singletonList(new StorageKey(key)));
                String phase = (String)CollectionUtils.getAny((Iterable)splitResult.getKeys());
                String path = (String)((List)splitResult.getValues()).get(0);
                result.add((Object)(phase + "#" + path), CheckPhaseResultIndexBase.this.deserializeValueList(value, path, CheckRegistry.getInstance().getCheckPhase(phase)));
            }
        };
        this.store.scan(keyPrefix, (IKeyValueCallback)callbackWrapper);
        callbackWrapper.throwCaughtException();
        return result;
    }

    @IndexValueClass
    static class RawExtractedValue<D extends Serializable>
    implements Comparable<RawExtractedValue<?>>,
    IExtractedValue<D> {
        private final String uniformPath;
        private final String value;
        private final D additionalInformation;

        public RawExtractedValue(String uniformPath, String value, D additionalInformation) {
            this.uniformPath = uniformPath;
            this.value = value;
            this.additionalInformation = additionalInformation;
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public String getValue() {
            return this.value;
        }

        public D getAdditionalInformation() {
            return this.additionalInformation;
        }

        @Override
        public int compareTo(RawExtractedValue<?> other) {
            int uniformPathResult = this.uniformPath.compareTo(other.uniformPath);
            if (uniformPathResult != 0) {
                return uniformPathResult;
            }
            return this.value.compareTo(other.value);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RawExtractedValue)) {
                return false;
            }
            RawExtractedValue other = (RawExtractedValue)obj;
            return Objects.equals(this.uniformPath, other.uniformPath) && Objects.equals(this.value, other.value) && this.isAdditionalInformationEqual(other);
        }

        private boolean isAdditionalInformationEqual(RawExtractedValue<?> other) {
            try {
                return Arrays.equals(SerializationUtils.serializeToByteArray(this.additionalInformation), SerializationUtils.serializeToByteArray(other.additionalInformation));
            }
            catch (IOException e) {
                return false;
            }
        }

        public int hashCode() {
            return Objects.hash(this.uniformPath, this.value, this.additionalInformation);
        }
    }
}

