/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.align;

import com.teamscale.index.code_clones.align.AlignedCloneContainer;
import com.teamscale.index.code_clones.align.AlignerStatement;
import com.teamscale.index.code_clones.align.ComponentAwareAlignedCloneContainer;
import com.teamscale.index.code_clones.align.EAlignerStatementType;
import com.teamscale.index.code_clones.align.IAlignedCloneContainer;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.normalization.StatementNormalizationConfiguration;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementPreprocessingUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.region.RegionSet;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class CloneAstAligner {
    private final IAlignedCloneContainer alignedCloneClasses;
    private final int minLength;
    private final Map<String, List<AlignerStatement>> uniformPathToAlignerStatements = new HashMap<String, List<AlignerStatement>>();

    public CloneAstAligner(int minLength, boolean separateComponents) {
        CCSMAssert.isTrue((minLength >= 1 ? 1 : 0) != 0, (String)"Min clone length must be positive!");
        this.minLength = minLength;
        this.alignedCloneClasses = separateComponents ? new ComponentAwareAlignedCloneContainer() : new AlignedCloneContainer();
    }

    public AstAlignmentResult performAlignment(Collection<CloneClass> cloneClasses, Map<String, TokenElementInfo> uniformPathToElement) throws StorageException {
        HashMap<String, Integer> uniformPathToUnitCount = new HashMap<String, Integer>();
        for (TokenElementInfo tokenElementInfo : uniformPathToElement.values()) {
            this.cacheStatementsAndUpdateUnits(tokenElementInfo, uniformPathToUnitCount);
        }
        for (CloneClass cloneClass : cloneClasses) {
            this.alignCloneClass(cloneClass);
        }
        return new AstAlignmentResult((Collection<CloneClass>)new IdentityHashSet(this.alignedCloneClasses.getAllCloneClasses()), uniformPathToUnitCount);
    }

    private void alignCloneClass(CloneClass cloneClass) {
        ArrayList<List<Clone>> alignedClones = new ArrayList<List<Clone>>();
        int minRegionLength = this.determineMinimumRegionLength(cloneClass);
        for (Clone clone : cloneClass.getClones()) {
            alignedClones.add(this.alignClone(clone, minRegionLength));
        }
        if (!CloneAstAligner.checkAlignedClones(alignedClones)) {
            return;
        }
        int numAligned = ((List)alignedClones.get(0)).size();
        for (int i = 0; i < numAligned; ++i) {
            int length = ((Clone)((List)alignedClones.get(0)).get(i)).getLengthInUnits();
            if (length < this.minLength) continue;
            CloneClass newCloneClass = new CloneClass(length);
            for (List list : alignedClones) {
                if (length != ((Clone)list.get(i)).getLengthInUnits()) {
                    return;
                }
                newCloneClass.add((Clone)list.get(i));
            }
            this.insertCloneClass(newCloneClass);
        }
    }

    private int determineMinimumRegionLength(CloneClass cloneClass) {
        int minRegionLength = Integer.MAX_VALUE;
        for (Clone clone : cloneClass.getClones()) {
            if (clone.containsGaps()) {
                CCSMAssert.fail((String)("Unexpected gapped clone in AST aligner: " + String.valueOf(clone)));
            }
            Region statementRegion = this.determineStatementRegion(clone, Integer.MAX_VALUE);
            minRegionLength = Math.min(minRegionLength, statementRegion.getLength());
        }
        return minRegionLength;
    }

    private void insertCloneClass(CloneClass newCloneClass) {
        IdentityHashSet existingClasses = new IdentityHashSet();
        for (Clone clone : newCloneClass.getClones()) {
            CloneClass cloneClass = this.alignedCloneClasses.getCloneClass(clone);
            if (cloneClass == null) continue;
            existingClasses.add(cloneClass);
        }
        for (CloneClass cloneClass : existingClasses) {
            for (Clone clone : new ArrayList<Clone>(cloneClass.getClones())) {
                newCloneClass.add(clone);
            }
        }
        for (Clone clone : newCloneClass.getClones()) {
            this.alignedCloneClasses.putCloneClass(clone, newCloneClass);
        }
    }

    private static boolean checkAlignedClones(List<List<Clone>> alignedClones) {
        CCSMAssert.isFalse((boolean)alignedClones.isEmpty(), (String)"May not pass empty list!");
        int numAligned = alignedClones.get(0).size();
        for (List<Clone> fragments : alignedClones) {
            if (fragments.size() == numAligned) continue;
            return false;
        }
        return true;
    }

    private List<Clone> alignClone(Clone clone, int minRegionLength) {
        Region statementRegion = this.determineStatementRegion(clone, minRegionLength);
        int start = statementRegion.getStart();
        int end = statementRegion.getEnd();
        if (statementRegion.getLength() <= 1) {
            return CollectionUtils.emptyList();
        }
        List<AlignerStatement> statements = this.getAlignerStatementsForUniformPath(clone.getUniformPath());
        Stack<Integer> starts = CloneAstAligner.initializeStarts(statements, start);
        RegionSet cloneRegions = new RegionSet();
        for (int i = start + 1; i <= end; ++i) {
            AlignerStatement currentStatement = statements.get(i);
            int nextDepth = currentStatement.getDepth() + 1;
            if (nextDepth > starts.size()) {
                starts.push(i);
            } else if (nextDepth < starts.size()) {
                starts.pop();
                if (starts.peek() != null) {
                    cloneRegions.add(new Region(starts.peek().intValue(), i));
                }
            } else if (starts.peek() != null) {
                cloneRegions.add(new Region(starts.peek().intValue(), i));
            } else {
                starts.pop();
                starts.push(i);
            }
            CCSMAssert.isTrue((nextDepth == starts.size() ? 1 : 0) != 0, (String)"The stack should always resemble the depth, as we create all intermediate AST levels.");
        }
        return this.createClonesFromRegions(clone, statements, cloneRegions.createCompact());
    }

    private static Stack<Integer> initializeStarts(List<AlignerStatement> statements, int start) {
        Stack<Integer> starts = new Stack<Integer>();
        for (int i = 0; i < statements.get(start).getDepth(); ++i) {
            starts.push(null);
        }
        if (statements.get(start).getStatementType() == EAlignerStatementType.COMPOUND_END) {
            starts.push(null);
        } else {
            starts.push(start);
        }
        return starts;
    }

    private List<Clone> createClonesFromRegions(Clone originClone, List<AlignerStatement> statements, RegionSet cloneRegions) {
        ArrayList<Clone> clones = new ArrayList<Clone>();
        for (Region region : cloneRegions) {
            List<AlignerStatement> cloneStatements;
            int size;
            int startIndex = CloneAstAligner.determineStartIndex(statements, region);
            if (startIndex >= statements.size()) continue;
            int currentEnd = region.getEnd();
            AlignerStatement lastStatement = statements.get(currentEnd);
            while (!(lastStatement.hasPosition() && lastStatement.getStatementType() != EAlignerStatementType.COMPOUND_START || currentEnd == 0)) {
                lastStatement = statements.get(--currentEnd);
            }
            if (currentEnd + 1 - startIndex < this.minLength || (size = CloneAstAligner.countNonArtificialStatements(cloneStatements = statements.subList(startIndex, currentEnd + 1))) < this.minLength) continue;
            TextRegionLocation newCloneLocation = CloneAstAligner.createCloneLocation(originClone, statements.get(startIndex), lastStatement);
            int unitIndex = statements.get(startIndex).getNonArtificialStatementIndex();
            clones.add(this.alignedCloneClasses.createCompatibleNewClone(originClone, newCloneLocation, unitIndex, size));
        }
        return clones;
    }

    private static int determineStartIndex(List<AlignerStatement> statements, Region region) {
        int startIndex;
        for (startIndex = region.getStart(); startIndex < statements.size() && CloneAstAligner.isFilteredStatement(statements.get(startIndex)); ++startIndex) {
        }
        return startIndex;
    }

    private static boolean isFilteredStatement(AlignerStatement statement) {
        return !statement.hasPosition() || statement.getStatementType() == EAlignerStatementType.COMPOUND_END;
    }

    private static TextRegionLocation createCloneLocation(Clone originClone, AlignerStatement firstStatement, AlignerStatement lastStatement) {
        return new TextRegionLocation(originClone.getUniformPath(), firstStatement.getRawStartOffset(), lastStatement.getRawEndOffset(), firstStatement.getRawStartLine(), lastStatement.getRawEndLine());
    }

    private static int countNonArtificialStatements(List<AlignerStatement> statements) {
        int count = 0;
        if (!statements.isEmpty()) {
            AlignerStatement last = (AlignerStatement)CollectionUtils.getLast(statements);
            count = last.getNonArtificialStatementIndex() - statements.get(0).getNonArtificialStatementIndex();
            if (!last.isArtificial()) {
                ++count;
            }
        }
        return count;
    }

    private Region determineStatementRegion(Clone clone, int minRegionLength) {
        int endStatementIndex;
        int startStatementIndex;
        List<AlignerStatement> statements = this.getAlignerStatementsForUniformPath(clone.getUniformPath());
        int startOffset = clone.getLocation().getRawStartOffset();
        int endOffset = clone.getLocation().getRawEndOffset();
        for (startStatementIndex = 0; startStatementIndex < statements.size() && (statements.get(startStatementIndex).isArtificial() || statements.get(startStatementIndex).getRawEndOffset() < startOffset); ++startStatementIndex) {
        }
        for (endStatementIndex = Math.min(startStatementIndex, statements.size() - 1); endStatementIndex < statements.size() - 1 && (statements.get(endStatementIndex + 1).isArtificial() || statements.get(endStatementIndex + 1).getRawStartOffset() <= endOffset) && endStatementIndex - startStatementIndex + 1 < minRegionLength; ++endStatementIndex) {
        }
        while (startStatementIndex > 0 && statements.get(startStatementIndex - 1).isArtificial() && endStatementIndex - startStatementIndex + 1 < minRegionLength) {
            --startStatementIndex;
        }
        return new Region(startStatementIndex, endStatementIndex);
    }

    private List<AlignerStatement> getAlignerStatementsForUniformPath(String uniformPath) {
        List<AlignerStatement> statements = this.uniformPathToAlignerStatements.get(uniformPath);
        CCSMAssert.isNotNull(statements, (String)"Expecting all statements to be cached!");
        return statements;
    }

    private void cacheStatementsAndUpdateUnits(TokenElementInfo element, Map<String, Integer> uniformPathToUnitCount) throws StorageException {
        StringOffsetTransformer offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
        LineOffsetConverter rawLineOffsetConverter = new LineOffsetConverter(element.getText());
        ArrayList<AlignerStatement> statements = new ArrayList<AlignerStatement>();
        if (ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage())) {
            UnmodifiableIterator entities = TokenElementPreprocessingUtils.getUnpreprocessedEntitiesIfPossible(element);
            CloneAstAligner.insertStatements((List<ShallowEntity>)entities, 0, offsetTransformer, rawLineOffsetConverter, CloneAstAligner.determineStartOffset(element), statements);
        } else {
            for (IToken token : element.getTokens()) {
                statements.add(new AlignerStatement(Collections.singletonList(token), offsetTransformer, rawLineOffsetConverter, 0, false, EAlignerStatementType.PRIMITIVE));
            }
        }
        CloneAstAligner.setNonArtificialStatementIndices(statements);
        String uniformPath = element.getUniformPath();
        int nonArtificialStatementCount = UniformPathUtils.isArchitectureFile((String)uniformPath) ? 0 : CloneAstAligner.countNonArtificialStatements(statements);
        uniformPathToUnitCount.put(element.getUniformPath(), nonArtificialStatementCount);
        this.uniformPathToAlignerStatements.put(element.getUniformPath(), statements);
    }

    private static int determineStartOffset(TokenElementInfo element) {
        UnmodifiableList<IToken> tokens = element.getTokens();
        if (tokens.isEmpty()) {
            return 0;
        }
        int index = StatementNormalizationConfiguration.getStartIndexFinder(element.getLanguage()).apply((List<IToken>)tokens);
        if (index >= tokens.size()) {
            return ((IToken)CollectionUtils.getLast(tokens)).getEndOffset();
        }
        return ((IToken)tokens.get(index)).getOffset();
    }

    private static void setNonArtificialStatementIndices(List<AlignerStatement> statements) {
        int nonArtificialStatementIndex = 0;
        for (AlignerStatement statement : statements) {
            statement.setNonArtificialStatementIndex(nonArtificialStatementIndex);
            if (statement.isArtificial()) continue;
            ++nonArtificialStatementIndex;
        }
    }

    static void insertStatements(List<ShallowEntity> entities, int depth, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter, int startOffset, List<AlignerStatement> statements) throws StorageException {
        for (ShallowEntity entity : entities) {
            CloneAstAligner.insertStatements(entity, depth, offsetTransformer, rawLineOffsetConverter, startOffset, statements);
        }
    }

    private static void insertStatements(ShallowEntity entity, int depth, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter, int startOffset, List<AlignerStatement> statements) throws StorageException {
        boolean include;
        if (entity.isEmpty()) {
            return;
        }
        if (CloneAstAligner.isMeta(entity) && !CloneAstAligner.isDelphi(entity)) {
            return;
        }
        boolean bl = include = entity.getStartOffset() >= startOffset;
        if (entity.getChildren().isEmpty()) {
            if (include) {
                statements.add(new AlignerStatement((List<IToken>)entity.includedTokens(), offsetTransformer, rawLineOffsetConverter, depth, false, EAlignerStatementType.PRIMITIVE));
            }
            return;
        }
        if (include) {
            boolean mayBeArtificial = !TokenStreamUtils.contains((List)entity.ownStartTokens(), (ETokenType)ETokenType.IDENTIFIER);
            statements.add(new AlignerStatement((List<IToken>)entity.ownStartTokens(), offsetTransformer, rawLineOffsetConverter, depth, mayBeArtificial, EAlignerStatementType.COMPOUND_START));
        }
        CloneAstAligner.insertStatements((List<ShallowEntity>)entity.getChildren(), depth + 1, offsetTransformer, rawLineOffsetConverter, startOffset, statements);
        if (include) {
            statements.add(new AlignerStatement((List<IToken>)entity.ownEndTokens(), offsetTransformer, rawLineOffsetConverter, depth, true, EAlignerStatementType.COMPOUND_END));
        }
    }

    private static boolean isMeta(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META;
    }

    private static boolean isDelphi(ShallowEntity entity) {
        return ShallowParsingUtils.getLanguage((ShallowEntity)entity) == ELanguage.DELPHI;
    }

    public static class AstAlignmentResult {
        private final Collection<CloneClass> cloneClasses;
        private final Map<String, Integer> uniformPathToUnitCount;

        private AstAlignmentResult(Collection<CloneClass> cloneClasses, Map<String, Integer> uniformPathToUnitCount) {
            this.cloneClasses = cloneClasses;
            this.uniformPathToUnitCount = uniformPathToUnitCount;
        }

        public Collection<CloneClass> getCloneClasses() {
            return this.cloneClasses;
        }

        public Map<String, Integer> getUniformPathToUnitCount() {
            return this.uniformPathToUnitCount;
        }
    }
}

