/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.detection;

import com.google.common.base.Preconditions;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.code_clones.CloneChunkByHashIndex;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.CloneComponentHelper;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.code_clones.detection.CloneChunkList;
import com.teamscale.index.code_clones.detection.CloneIndexCloneSearcher;
import com.teamscale.index.code_clones.detection.CloneIndexGappedCloneSearcher;
import com.teamscale.index.code_clones.detection.IntraComponentCloneIndexCloneSearcher;
import com.teamscale.index.code_clones.report.ICloneClassReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.jetbrains.annotations.Contract;

public class CloneDetector {
    private final CloneChunkByPathIndex byPathIndex;
    private final CloneChunkByHashIndex byHashIndex;
    private final int chunkLength;

    public CloneDetector(@NonNull CloneChunkByPathIndex byPathIndex, @NonNull CloneChunkByHashIndex byHashIndex) throws StorageException {
        Preconditions.checkNotNull((Object)((Object)byPathIndex));
        Preconditions.checkNotNull((Object)((Object)byHashIndex));
        this.byPathIndex = byPathIndex;
        this.byHashIndex = byHashIndex;
        this.chunkLength = byPathIndex.getChunkLength();
    }

    public void reportClones(List<String> uniformPaths, ICloneClassReporter reporter, int minLength, boolean allowGaps) throws StorageException {
        List<CloneChunkList> chunksByPath = this.byPathIndex.getChunksForElements(uniformPaths);
        if (allowGaps) {
            this.detectGappedClones(uniformPaths, reporter, minLength, chunksByPath);
        } else {
            this.detectUngappedClones(uniformPaths, reporter, minLength, chunksByPath);
        }
    }

    public void reportIntraComponentClones(@NonNull List<String> uniformPaths, @NonNull CloneComponentHelper componentHelper, @NonNull ICloneClassReporter reporter, int minLength) throws StorageException {
        List<CloneChunkList> chunksByPath = this.byPathIndex.getChunksForElements(uniformPaths);
        Set allHashes = chunksByPath.stream().flatMap(chunkList -> chunkList.getIncludedHashes().stream()).collect(Collectors.toSet());
        List<CloneChunk> matchingChunks = this.byHashIndex.getChunksForHashes(new ArrayList<Long>(allHashes)).stream().filter(list -> list.size() > 1).flatMap(Collection::stream).toList();
        Map<String, Cluster> clusters = CloneDetector.clusterChunksPerComponent(matchingChunks, componentHelper);
        for (Map.Entry<String, Cluster> e : clusters.entrySet()) {
            String component = e.getKey();
            Cluster cluster = e.getValue();
            new IntraComponentCloneIndexCloneSearcher(component, cluster.paths, reporter, minLength, cluster.chunks, this.chunkLength).reportClones();
        }
    }

    private void detectGappedClones(List<String> uniformPaths, ICloneClassReporter reporter, int minLength, List<CloneChunkList> chunksByPath) throws StorageException {
        for (int i = 0; i < uniformPaths.size(); ++i) {
            List<CloneChunkList> orderedChunks;
            CloneChunkList chunks = chunksByPath.get(i);
            if (CollectionUtils.isNullOrEmpty((Collection)chunks) || CollectionUtils.isNullOrEmpty(orderedChunks = CloneDetector.obtainOrderedChunks(this.byHashIndex, chunks))) continue;
            new CloneIndexGappedCloneSearcher(uniformPaths.get(i), reporter, minLength, orderedChunks, this.chunkLength).reportClones();
        }
    }

    private void detectUngappedClones(List<String> uniformPaths, ICloneClassReporter reporter, int minLength, List<CloneChunkList> chunksByPath) throws StorageException {
        HashSet<Long> allHashes = new HashSet<Long>();
        for (CloneChunkList list2 : chunksByPath) {
            allHashes.addAll(list2.getIncludedHashes());
        }
        List<CloneChunk> matchingChunks = this.byHashIndex.getChunksForHashes(new ArrayList<Long>(allHashes)).stream().filter(list -> list.size() > 1).flatMap(Collection::stream).toList();
        new CloneIndexCloneSearcher(new HashSet<String>(uniformPaths), reporter, minLength, matchingChunks, this.chunkLength).reportClones();
    }

    private static List<CloneChunkList> obtainOrderedChunks(CloneChunkByHashIndex byHashIndex, CloneChunkList originChunks) throws StorageException {
        ListMap<Long, CloneChunk> clonedChunksByHash = CloneDetector.getClonedChunksByHash(byHashIndex, originChunks);
        HashMap<Long, CloneChunkList> chunkListByHash = new HashMap<Long, CloneChunkList>();
        ArrayList<CloneChunkList> orderedChunks = new ArrayList<CloneChunkList>();
        for (CloneChunk chunk : originChunks) {
            int index = chunk.getFirstUnitIndex();
            while (index >= orderedChunks.size()) {
                orderedChunks.add(new CloneChunkList());
            }
            CloneChunkList sortedChunkList = CloneDetector.getSortedChunkListForHash(chunk.getChunkHash(), clonedChunksByHash, chunkListByHash);
            if (CollectionUtils.isNullOrEmpty((Collection)sortedChunkList)) continue;
            orderedChunks.set(index, sortedChunkList);
        }
        return orderedChunks;
    }

    private static CloneChunkList getSortedChunkListForHash(long chunkHash, ListMap<Long, CloneChunk> clonedChunksByHash, Map<Long, CloneChunkList> chunkListCache) {
        CloneChunkList result = chunkListCache.get(chunkHash);
        if (result == null) {
            List chunks = (List)clonedChunksByHash.getCollection((Object)chunkHash);
            if (chunks == null) {
                return null;
            }
            result = new CloneChunkList();
            if (chunks.size() >= 2) {
                result.addAll(chunks);
                result.sort(CloneChunk.CHUNK_COMPARATOR);
            }
            chunkListCache.put(chunkHash, result);
        }
        return result;
    }

    private static ListMap<Long, CloneChunk> getClonedChunksByHash(CloneChunkByHashIndex byHashIndex, CloneChunkList originChunks) throws StorageException {
        ArrayList<Long> orderedChunkHashes = new ArrayList<Long>(originChunks.getIncludedHashes());
        ListMap chunksByHash = new ListMap();
        List<CloneChunkList> cloneChunkListsForHashes = byHashIndex.getChunksForHashes(orderedChunkHashes);
        for (int i = 0; i < orderedChunkHashes.size(); ++i) {
            CloneChunkList chunkList = cloneChunkListsForHashes.get(i);
            if (chunkList.isEmpty()) {
                throw new StorageException("Inconsistent database: No chunks returned for hash " + String.valueOf(orderedChunkHashes.get(i)));
            }
            if (chunkList.size() == 1) continue;
            for (CloneChunk chunk : chunkList) {
                chunksByHash.add((Object)chunk.getChunkHash(), (Object)chunk);
            }
        }
        return chunksByHash;
    }

    private static @NonNull Map<String, Cluster> clusterChunksPerComponent(@NonNull List<CloneChunk> matchingChunks, @NonNull CloneComponentHelper componentHelper) {
        TypeToComponentMapper.MappingResult componentMapping = componentHelper.getComponentMappingForChunks(matchingChunks);
        HashMap<String, Cluster> clusters = new HashMap<String, Cluster>();
        for (CloneChunk chunk : matchingChunks) {
            String path = chunk.getOriginId();
            Set<ComponentNode> componentsForType = componentMapping.getMappedComponentsForType(path);
            for (ComponentNode component : componentsForType) {
                Cluster cluster = clusters.computeIfAbsent(component.getName(), ignored -> Cluster.newCluster());
                cluster.paths.add(path);
                cluster.chunks.add(chunk);
            }
        }
        return clusters;
    }

    private record Cluster(Set<String> paths, List<CloneChunk> chunks) {
        @Contract(value=" -> new")
        public static @NonNull Cluster newCluster() {
            return new Cluster(new HashSet<String>(), new ArrayList<CloneChunk>());
        }
    }
}

