/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.suffixtree;

import com.teamscale.index.code_clones.suffixtree.ICloneReporter;
import com.teamscale.index.code_clones.suffixtree.SuffixTree;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public class CloneDetectingSuffixTree
extends SuffixTree {
    private final int[] inducedClones;
    private final int[] leafPositions;
    protected ICloneReporter cloneReporter;
    protected int minLength;

    public CloneDetectingSuffixTree(List<?> word) {
        super(word);
        this.ensureChildLists();
        this.inducedClones = new int[this.numNodes];
        this.leafPositions = new int[this.numNodes];
        this.initInducedClones(0);
    }

    private int initInducedClones(int node) {
        int result = 0;
        int e = this.nodeChildFirst[node];
        while (e >= 0) {
            result += this.initInducedClones(this.nodeChildNode[e]);
            e = this.nodeChildNext[e];
        }
        if (result == 0) {
            result = 1;
        }
        if (node != 0) {
            this.inducedClones[this.suffixLink[node]] = result;
        }
        return result;
    }

    public void findClones(int minLength, ICloneReporter consumer) throws StorageException {
        if (minLength <= 0) {
            throw new IllegalArgumentException("minLength must be positive and not %d.".formatted(minLength));
        }
        this.minLength = minLength;
        this.cloneReporter = consumer;
        this.findClones(0, 0, 0);
    }

    private int findClones(int node, int currentLength, int leafPosStart) throws StorageException {
        if (this.nodeChildFirst[node] < 0) {
            this.leafPositions[leafPosStart] = this.INFTY - currentLength;
            return leafPosStart + 1;
        }
        int leafPosEnd = leafPosStart;
        int e = this.nodeChildFirst[node];
        while (e >= 0) {
            int next = this.nodeChildNode[e];
            int len = this.nodeWordEnd[next] - this.nodeWordBegin[next];
            leafPosEnd = this.findClones(next, currentLength + len, leafPosEnd);
            e = this.nodeChildNext[e];
        }
        int numberOfClones = leafPosEnd - leafPosStart;
        if (currentLength >= this.minLength && numberOfClones > this.inducedClones[node] && this.cloneReporter.startCloneClass(currentLength, numberOfClones)) {
            for (int i = leafPosStart; i < leafPosEnd; ++i) {
                this.cloneReporter.addClone(this.leafPositions[i], currentLength);
            }
            this.cloneReporter.completeCloneClass();
        }
        return leafPosEnd;
    }
}

