/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.check.CheckOptionDescriptor;
import com.teamscale.index.check.CheckOptionDescriptorRegistry;
import com.teamscale.index.check.CheckPhaseInverter;
import com.teamscale.index.check.CheckPhaseProcessor;
import com.teamscale.index.check.CheckPhaseResultDependencyIndex;
import com.teamscale.index.check.CheckPhaseResultIndex;
import com.teamscale.index.check.CheckProcessor;
import com.teamscale.index.check.CheckResultInvalidationIndex;
import com.teamscale.index.check.InvertedCheckPhaseResultIndex;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.CheckInstance;
import eu.cqse.check.framework.core.IFindingDescriptionModifyingCheck;
import eu.cqse.check.framework.core.option.ICheckOption;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

public class ChecksConfiguration
extends AnalysisConfigurationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CodeScopeAware<PairList<FindingDescriptor, CheckInfo>> findingDescriptors = CodeScopeAware.empty();
    private final CodeScopeAware<ListMap<String, ConfigOptionDescriptorBase>> configOptionDescriptors = CodeScopeAware.empty();
    private final CodeScopeAware<CheckOptionDescriptorRegistry> checkOptionDescriptors = CodeScopeAware.empty();
    private final SetMap<String, Class<? extends IGlobalExtractionPhase<?, ?>>> requiredPhasesByCheckIdentifier = new SetMap();

    private void createFindingDescriptors(CodeScopeName codeScopeName) {
        this.checkOptionDescriptors.setValue(codeScopeName, (Object)new CheckOptionDescriptorRegistry());
        this.configOptionDescriptors.setValue(codeScopeName, (Object)new ListMap());
        PairList findingDescriptors = new PairList();
        for (CheckInfo checkInfo : CheckRegistry.getInstance().getChecksInfos()) {
            FindingDescriptor descriptor = new FindingDescriptor(checkInfo.getId(), checkInfo.getReadableName(), EAnalysisTool.TEAMSCALE, checkInfo.getSupportedLanguages(), checkInfo.getDefaultEnablement(), checkInfo.getDescription());
            this.registerFinding((PairList<FindingDescriptor, CheckInfo>)findingDescriptors, descriptor, checkInfo, codeScopeName);
            String identifier = CheckUtils.buildIdentifier((String)checkInfo.getCategoryName(), (String)checkInfo.getGroupName(), (String)descriptor.getName());
            this.requiredPhasesByCheckIdentifier.addAll((Object)identifier, (Collection)checkInfo.getRequiredPhases());
            this.createOptionDescriptorsForCheck(checkInfo, codeScopeName);
        }
        this.findingDescriptors.setValue(codeScopeName, (Object)findingDescriptors);
    }

    private void registerFinding(PairList<FindingDescriptor, CheckInfo> findingDescriptors, FindingDescriptor descriptor, CheckInfo checkInfo, CodeScopeName codeScopeName) {
        this.addFindingDescriptor(descriptor, codeScopeName);
        findingDescriptors.add((Object)descriptor, (Object)checkInfo);
    }

    private void createOptionDescriptorsForCheck(CheckInfo checkInfo, CodeScopeName codeScopeName) {
        for (ICheckOption option : checkInfo.getOptions().values()) {
            String identifier = checkInfo.getIdentifier();
            CheckOptionDescriptor checkOptionDescriptor = ((CheckOptionDescriptorRegistry)this.checkOptionDescriptors.getValue(codeScopeName)).addFromOption(identifier, option);
            ConfigOptionDescriptorBase configOptionDescriptor = checkOptionDescriptor.wrapIntoConfigOptionDescriptor();
            ((ListMap)this.configOptionDescriptors.getValue(codeScopeName)).add((Object)identifier, (Object)configOptionDescriptor);
            this.addOption(configOptionDescriptor);
        }
    }

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        LinkedHashMap enabledChecks = new LinkedHashMap();
        HashSet requiredPhases = new HashSet();
        for (CodeScopeName codeScopeName : proxy.getCodeScopes().stream().map(CodeScope::getName).toList()) {
            enabledChecks.put(codeScopeName, new ArrayList());
            for (Pair findingDescriptorCheckInfoPair : (PairList)this.findingDescriptors.getValue(codeScopeName)) {
                FindingDescriptor findingDescriptor = (FindingDescriptor)findingDescriptorCheckInfoPair.getFirst();
                CheckInfo checkInfo = (CheckInfo)findingDescriptorCheckInfoPair.getSecond();
                if (!findingDescriptor.getEnablement().isEnabled()) continue;
                String identifier = CheckUtils.buildIdentifier((String)checkInfo.getCategoryName(), (String)checkInfo.getGroupName(), (String)findingDescriptor.getName());
                ((Collection)enabledChecks.get(codeScopeName)).add(identifier);
                Optional<String> updatedFindingDescription = this.computeUpdatedFindingDescription(identifier, codeScopeName);
                if (updatedFindingDescription.isPresent()) {
                    findingDescriptor = findingDescriptor.cloneWithUpdatedFindingDescription(updatedFindingDescription.get());
                }
                requiredPhases.addAll(this.requiredPhasesByCheckIdentifier.getCollectionOrEmpty((Object)identifier));
                proxy.addFindingsSchemaEntry(checkInfo.getGroupName(), findingDescriptor.getName(), findingDescriptor, codeScopeName);
            }
        }
        proxy.createProjectIndex(CheckPhaseResultIndex.class);
        proxy.createProjectIndex(InvertedCheckPhaseResultIndex.class);
        proxy.createProjectIndex(CheckPhaseResultDependencyIndex.class);
        proxy.createProjectIndex(CheckResultInvalidationIndex.class);
        this.createTriggers(proxy, (CodeScopeAware<Collection<String>>)new CodeScopeAware(enabledChecks, Collections.emptyList()), requiredPhases);
    }

    private Optional<String> computeUpdatedFindingDescription(String checkIdentifier, CodeScopeName codeScopeName) {
        try {
            CheckInstance checkInstance = CheckRegistry.getInstance().instantiateCheck(checkIdentifier);
            if (checkInstance.getCheckImplementation() instanceof IFindingDescriptionModifyingCheck) {
                ((CheckOptionDescriptorRegistry)this.checkOptionDescriptors.getValue(codeScopeName)).createOptionStore().applyCheckOptions(checkInstance);
                checkInstance.initialize();
                String updatedDescription = ((IFindingDescriptionModifyingCheck)checkInstance.getCheckImplementation()).computeUpdatedFindingDescription();
                return Optional.of(updatedDescription);
            }
        }
        catch (CheckException e) {
            LOGGER.warn("Could not update finding description for check " + checkIdentifier, (Throwable)e);
        }
        return Optional.empty();
    }

    private void createTriggers(ProjectCreationProxy proxy, CodeScopeAware<Collection<String>> enabledChecks, Set<Class<? extends IGlobalExtractionPhase<?, ?>>> requiredPhases) throws ProjectConfigurationException {
        CodeScopeAware scopedSerializedOptionStores = CodeScopeAware.empty();
        for (CodeScope codeScope : proxy.getCodeScopes()) {
            scopedSerializedOptionStores.setValue(codeScope.getName(), (Object)((CheckOptionDescriptorRegistry)this.checkOptionDescriptors.getValue(codeScope.getName())).createOptionStore().serializeToBase64String());
        }
        TriggerBuilder checksTrigger = new TriggerBuilder(CheckProcessor.class, ETriggerConcurrency.PARALLEL);
        checksTrigger.setTriggerParameter("options.value", (ITriggerParameter)scopedSerializedOptionStores);
        checksTrigger.setTriggerParameter("enabled-checks.identifier", enabledChecks);
        proxy.createTrigger(checksTrigger);
        if (!requiredPhases.isEmpty()) {
            TriggerBuilder phaseProcessor = new TriggerBuilder(CheckPhaseProcessor.class, ETriggerConcurrency.PARALLEL);
            phaseProcessor.setTriggerParameter("phase.name", ITriggerParameter.of((Object)CollectionUtils.map(requiredPhases, Class::getName)));
            proxy.createTrigger(phaseProcessor);
            proxy.createTrigger(new TriggerBuilder(CheckPhaseInverter.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        }
    }

    private void addOptions(List<ConfigurationItemBase> items, String checkIdentifier, CodeScopeName codeScopeName) {
        List checkOptionDescriptors = (List)((ListMap)this.configOptionDescriptors.getValue(codeScopeName)).getCollection((Object)checkIdentifier);
        items.addAll(CollectionUtils.emptyIfNull((List)checkOptionDescriptors));
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        CodeScopeName codeScopeName = template.getCodeScope();
        this.createFindingDescriptors(codeScopeName);
        for (Pair findingsDescriptorAndCheckInfo : (PairList)this.findingDescriptors.getValue(codeScopeName)) {
            FindingDescriptor findingDescriptor = (FindingDescriptor)findingsDescriptorAndCheckInfo.getFirst();
            CheckInfo checkInfo = (CheckInfo)findingsDescriptorAndCheckInfo.getSecond();
            if (CollectionUtils.intersectionSet((Collection)findingDescriptor.getLanguages(), (Collection[])new Collection[]{languages}).isEmpty()) continue;
            ArrayList<ConfigurationItemBase> items = new ArrayList<ConfigurationItemBase>();
            items.add((ConfigurationItemBase)findingDescriptor);
            this.addOptions(items, CheckUtils.buildIdentifier((String)checkInfo.getCategoryName(), (String)checkInfo.getGroupName(), (String)findingDescriptor.getName()), codeScopeName);
            template.registerConfigurationItemsCodeScopeAware(checkInfo.getGroupName(), checkInfo.getCategoryName(), items);
        }
    }
}

