/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.index.report.result.processor.CoverageUnitTempIndex;
import com.teamscale.index.testimpact.CodeToTestPathsMapIndex;
import com.teamscale.index.testimpact.CoverageUnitChangeIndex;
import com.teamscale.index.testimpact.CoverageUnitIntegrator;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.testimpact.ImpactedTestsIndex;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.TestElementContentSynchronizer;
import com.teamscale.index.testimpact.TestExecutionMerger;
import com.teamscale.index.testimpact.TestHistorySynchronizer;
import com.teamscale.index.testimpact.TestImpactSynchronizer;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.testimpact.TestLinksIndex;
import com.teamscale.index.testimpact.TestLinksSynchronizer;
import com.teamscale.index.testimpact.TestMetricsSynchronizer;
import com.teamscale.index.tests.information_retrieval.PathTermFrequencyIndex;
import com.teamscale.index.tests.information_retrieval.TermPathFrequencyIndex;
import com.teamscale.index.tests.information_retrieval.TestInformationRetrievalSynchronizer;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import org.conqat.engine.core.configuration.EFeatureToggle;

public class TestSupportConfiguration
extends AnalysisConfigurationBase {
    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        proxy.createProjectIndex(MethodIdIndex.class);
        proxy.createProjectIndex(CoverageUnitToMethodsMapIndex.class);
        proxy.createProjectIndex(ImpactedTestsIndex.class);
        proxy.createProjectIndex(CoverageUnitTempIndex.class);
        proxy.createProjectIndex(TestImplementationIndex.class);
        proxy.createProjectIndex(TestLinksIndex.class);
        proxy.createProjectIndex(ExecutionUnitIndex.class);
        proxy.createProjectIndex(CoverageUnitChangeIndex.class);
        proxy.createProjectIndex(CodeToTestPathsMapIndex.class);
        if (EFeatureToggle.INDEX_TEST_IMPLEMENTATIONS_FOR_TEST_SELECTION.isEnabled()) {
            proxy.createProjectIndex(PathTermFrequencyIndex.class);
            proxy.createProjectIndex(TermPathFrequencyIndex.class);
        }
        proxy.createTrigger(new TriggerBuilder(TestLinksSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(TestMetricsSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(TestElementContentSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(TestHistorySynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(TestExecutionMerger.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(TestImpactSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        proxy.createTrigger(new TriggerBuilder(CoverageUnitIntegrator.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        if (EFeatureToggle.INDEX_TEST_IMPLEMENTATIONS_FOR_TEST_SELECTION.isEnabled()) {
            proxy.createTrigger(new TriggerBuilder(TestInformationRetrievalSynchronizer.class, ETriggerConcurrency.OUTPUT_ISOLATED));
        }
    }

    public boolean isCoreConfiguration() {
        return true;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

