/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.metrics;

import com.teamscale.core.analysis.configuration.IDynamicMetricComputation;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.metrics.FindingsCountMetric;
import com.teamscale.core.findings.metrics.FindingsDensityMetricBase;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.source.DivisionMetricSource;
import com.teamscale.core.metrics.source.NormalizationMetricSource;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;

public class SpecItemFindingsDensityMetric
extends FindingsDensityMetricBase {
    private static final int NORMALIZATION_FACTOR = 100;
    private static final String NORMALIZATION_FACTOR_STRING = String.format(Locale.US, "%,d", 100);
    public static final String BASE_NAME = "Spec Item Findings Density";
    private static final String DESCRIPTION_PREFIX = "The number of%s findings";
    protected static final String BASE_DESCRIPTION = "The number of%s findings per " + NORMALIZATION_FACTOR_STRING + " Spec Item size";
    private static final String RAW_BASE_DESCRIPTION = "The number of%s findings per Spec Item size";
    private static final String DENOMINATOR_METRIC_NAME = "Spec Item Size";
    public static final SpecItemFindingsDensityMetric SPEC_ITEM_FINDINGS_DENSITY = new SpecItemFindingsDensityMetric(FindingsCountMetric.FINDINGS_COUNT);
    public static final SpecItemFindingsDensityMetric SPEC_ITEM_FINDINGS_DENSITY_RED = new SpecItemFindingsDensityMetric(FindingsCountMetric.FINDINGS_COUNT_RED);
    public static final SpecItemFindingsDensityMetric SPEC_ITEM_FINDINGS_DENSITY_YELLOW = new SpecItemFindingsDensityMetric(FindingsCountMetric.FINDINGS_COUNT_YELLOW);

    private SpecItemFindingsDensityMetric(FindingsCountMetric baseMetric) {
        super(baseMetric, BASE_NAME, BASE_DESCRIPTION, RAW_BASE_DESCRIPTION, DENOMINATOR_METRIC_NAME, 100.0);
    }

    protected SpecItemFindingsDensityMetric(String id, String categoryName, String description, String rawDescription, FindingsCountMetric baseMetric, ETrafficLightColor color) {
        super(id, categoryName, BASE_NAME, description, rawDescription, baseMetric, DENOMINATOR_METRIC_NAME, 100.0);
    }

    public void registerInSchema(MetricSchemaProxy schema) throws ProjectConfigurationException {
        schema.addMetric(this.getId(), schema.createDynamicMetricSource((IDynamicMetricComputation)new SpecItemFindingsDensityMetricComputation(this.getName(), this.baseMetric.getName(), this.denominatorMetricName, this.normalizationFactor)), this.getName(), this.getDescription(), METRIC_VALUE_TYPE, METRIC_AGGREGATION, new EMetricProperty[0]);
    }

    @IndexValueClass(containedInBackup=true)
    private record SpecItemFindingsDensityMetricComputation(String metricName, String nominatorMetricName, String denominatorMetricName, double findingsDensity) implements IDynamicMetricComputation
    {
        private static final long serialVersionUID = 1L;

        public void generateValue(Object[] metrics, MetricDirectorySchema schema) {
            int baseMetricIndex = schema.getValuePosition(this.nominatorMetricName);
            int denominatorMetricIndex = schema.getValuePosition(this.denominatorMetricName);
            int targetMetricIndex = schema.getValuePosition(this.metricName);
            if (baseMetricIndex < 0 || denominatorMetricIndex < 0 || targetMetricIndex < 0) {
                throw new IllegalArgumentException("Unable to calculate metric %s because base metric (%s), denominator metric (%s) or target metric (%s) were not present in the schema: %s".formatted(this.metricName, this.nominatorMetricName, this.denominatorMetricName, this.metricName, schema));
            }
            try {
                DivisionMetricSource divisionMetricSource = new DivisionMetricSource(baseMetricIndex, denominatorMetricIndex, 0.0, Collections.emptySet());
                divisionMetricSource.init(targetMetricIndex, schema);
                divisionMetricSource.generateValue(metrics, false, schema.getEntry(targetMetricIndex), new CounterSet(List.of(CodeScopeAware.DEFAULT_CODE_SCOPE.name())));
                NormalizationMetricSource normalizationMetricSource = new NormalizationMetricSource(targetMetricIndex, this.findingsDensity);
                normalizationMetricSource.init(targetMetricIndex, schema);
                normalizationMetricSource.generateValue(metrics, false, schema.getEntry(targetMetricIndex), new CounterSet(List.of(CodeScopeAware.DEFAULT_CODE_SCOPE.name())));
            }
            catch (ConQATException e) {
                throw new IllegalArgumentException("Unable to compute metric %s".formatted(this.metricName), e);
            }
        }
    }
}

