/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.migrations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.configuration.AnalysisProfileMigrationUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class V174CrossComponentCloneMigration {
    public static String migrate(String json) throws MigrationException {
        try {
            ObjectNode codeClonesGroupOptions;
            ObjectNode analysisProfile = (ObjectNode)CCSMAssert.checkedCast((Object)JsonUtils.deserializeFromJson((String)json), ObjectNode.class);
            ObjectNode codeClonesGroup = AnalysisProfileMigrationUtils.getAnalysisGroup(analysisProfile, "Code Clones");
            if (codeClonesGroup != null && V174CrossComponentCloneMigration.isCrossComponentCloningEnabled(codeClonesGroupOptions = (ObjectNode)codeClonesGroup.get("options"))) {
                codeClonesGroupOptions.set("Clones", (JsonNode)JsonNodeFactory.instance.textNode("off"));
                return JsonUtils.serializeToJSON((Object)analysisProfile);
            }
            return json;
        }
        catch (JsonSerializationException e) {
            throw new MigrationException((Throwable)e);
        }
    }

    private static boolean isCrossComponentCloningEnabled(ObjectNode codeClonesGroupOptions) {
        String crossComponentClones = V174CrossComponentCloneMigration.getOptionValue(codeClonesGroupOptions, "Cross Component Clones");
        String crossComponentCloneCoverage = V174CrossComponentCloneMigration.getOptionValue(codeClonesGroupOptions, "Cross Component Clone Coverage");
        String intraComponentCloneCoverage = V174CrossComponentCloneMigration.getOptionValue(codeClonesGroupOptions, "Intra Component Clone Coverage");
        return crossComponentClones != null && !"off".equalsIgnoreCase(crossComponentClones) || crossComponentCloneCoverage != null && !"false".equalsIgnoreCase(crossComponentCloneCoverage) || intraComponentCloneCoverage != null && !"false".equalsIgnoreCase(intraComponentCloneCoverage);
    }

    private static @Nullable String getOptionValue(ObjectNode optionsNode, String optionName) {
        JsonNode optionValueNode = optionsNode.get(optionName);
        if (optionValueNode == null) {
            return null;
        }
        return optionValueNode.textValue();
    }
}

