/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import com.teamscale.index.report.parser.sap_code_inspector.CodePalFindings;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;

public class CodeInspectorConfiguration
extends ToolConfigurationBase {
    public static final String CATEGORY_NAME = "Code Inspector";
    private static final String DESCRIPTIONS_PATH = "code-inspector";
    private static final String CODE_PAL_DESCRIPTIONS_PATH = "code-pal";
    public static final String CHECK_MAPPINGS_TSV = "code-inspector/check-mappings.tsv";

    public CodeInspectorConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.CODE_INSPECTOR, CATEGORY_NAME, DESCRIPTIONS_PATH, CHECK_MAPPINGS_TSV, "");
    }

    protected String getDescription(String ruleId, String descriptionPath) {
        if (CodePalFindings.KNOWN_CODE_PAL_FINDING_IDS.contains(ruleId)) {
            return super.getDescription(ruleId, descriptionPath + "/code-pal");
        }
        return "";
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (!tools.contains(EAnalysisTool.CODE_INSPECTOR)) {
            return;
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }
}

