/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.index.configuration.tools.RaexConfigurationBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StyleCopConfiguration
extends RaexConfigurationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String STYLECOP_MAPPINGS_TSV = "stylecop/check-mappings.tsv";
    private static final String DESCRIPTIONS_PATH = "stylecop";

    public StyleCopConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.STYLECOP, "RA\u00cbX", DESCRIPTIONS_PATH, STYLECOP_MAPPINGS_TSV);
        this.declareCodeScopeAware();
    }

    protected String getDescription(String ruleId, @Nullable String descriptionPath) {
        String description = super.getDescription(ruleId, descriptionPath);
        int causeIndex = description.indexOf("## Cause");
        if (causeIndex != -1) {
            return description.substring(causeIndex);
        }
        LOGGER.warn("Unexpected format of StyleCop description file. Did not find Cause section for rule {} in {}", (Object)ruleId, (Object)descriptionPath);
        return description;
    }
}

