/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools.message;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.configuration.tools.message.RuleBasedMessageManagerBase;
import eu.cqse.check.framework.core.EFindingEnablement;

public class AstreeMessageManager
extends RuleBasedMessageManagerBase {
    private static final String ASTREE_GENERIC_DESCRIPTION = "No detailed descriptions available for Absint Astr\u00e9e checks (called alarms in Astr\u00e9e)";
    private static final String ASTREE_RULES_JSON_FILE = "astree/rules.json";
    private static final String CATEGORY_NAME = "Astree";
    private static AstreeMessageManager instance;

    public AstreeMessageManager() throws ProjectConfigurationException {
        super(CATEGORY_NAME, ASTREE_RULES_JSON_FILE);
        for (Rule rule : this.getRules()) {
            rule.description = ASTREE_GENERIC_DESCRIPTION;
        }
    }

    public static synchronized AstreeMessageManager getInstance() throws ProjectConfigurationException {
        if (instance == null) {
            instance = new AstreeMessageManager();
        }
        return instance;
    }

    @Override
    public String getFindingsGroupNameFor(Rule rule) {
        return rule.message + " (" + rule.id + ")";
    }

    @Override
    public String getAnalysisGroupNameFor(Rule rule) {
        return rule.category;
    }

    @Override
    public EFindingEnablement getFindingEnablementFor(Rule rule) {
        if (rule.category.toLowerCase().contains("error")) {
            return EFindingEnablement.RED;
        }
        return EFindingEnablement.YELLOW;
    }
}

