/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dashboard;

import com.teamscale.index.dashboard.DashboardDescriptor;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Index(name="dashboards", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP})
public class DashboardIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "dashboards";
    private final ValueIndex<DashboardDescriptor> delegateIndex;

    public DashboardIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    void storeDashboard(DashboardDescriptor dashboard) throws StorageException {
        this.delegateIndex.setValue(dashboard.getId().toString(), (Object)dashboard);
    }

    public List<DashboardDescriptor> getDashboards(Set<UUID> dashboardIds) throws StorageException {
        return this.delegateIndex.getValues(CollectionUtils.map(dashboardIds, UUID::toString));
    }

    public @Nullable DashboardDescriptor getDashboard(UUID dashboardId) throws StorageException {
        return (DashboardDescriptor)this.delegateIndex.getValue(dashboardId.toString());
    }

    public List<DashboardDescriptor> getAllDashboards() throws StorageException {
        return this.delegateIndex.getAllEntries().extractSecondList();
    }

    void removeDashboard(UUID dashboardId) throws StorageException {
        this.delegateIndex.removeValue(dashboardId.toString());
    }
}

