/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph;

import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class VariableWrite {
    public static final String EXCEPTION_VALUE = "exception";
    public static final String NEW_OBJECT_VALUE = "new";
    private EVariableWriteType type = EVariableWriteType.OTHER;
    private boolean isDefaultInitialization = false;
    private final String changedVariable;
    private String assignedValue;
    private String valueVariable;
    private boolean writeToDereferencedAddress = false;

    public VariableWrite(String changedVariable) {
        this.changedVariable = changedVariable;
    }

    public EVariableWriteType getType() {
        return this.type;
    }

    public String getChangedVariable() {
        return this.changedVariable;
    }

    public String getAssignedValue() {
        return this.assignedValue;
    }

    public String getValueVariable() {
        return this.valueVariable;
    }

    public VariableWrite setVariable(String variable) {
        CCSMAssert.isNotNull((Object)variable);
        this.reset();
        this.valueVariable = variable;
        this.type = EVariableWriteType.VARIABLE;
        return this;
    }

    public VariableWrite setValue(String value) {
        CCSMAssert.isNotNull((Object)value);
        this.reset();
        this.assignedValue = value;
        this.type = EVariableWriteType.VALUE;
        return this;
    }

    public VariableWrite setEmpty() {
        this.reset();
        this.type = EVariableWriteType.EMPTY;
        this.isDefaultInitialization = true;
        return this;
    }

    public VariableWrite setOther() {
        this.reset();
        this.type = EVariableWriteType.OTHER;
        return this;
    }

    public VariableWrite setNull() {
        this.reset();
        this.type = EVariableWriteType.NULL;
        return this;
    }

    public VariableWrite makeDefaultInitialization() {
        this.isDefaultInitialization = true;
        return this;
    }

    public boolean isDefaultInitialization() {
        return this.isDefaultInitialization;
    }

    public VariableWrite makeWriteToDereferencedAddress() {
        this.writeToDereferencedAddress = true;
        return this;
    }

    public boolean isWriteToDereferencedAddress() {
        return this.writeToDereferencedAddress;
    }

    private void reset() {
        this.isDefaultInitialization = false;
        this.assignedValue = null;
        this.valueVariable = null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assignedValue, this.valueVariable, this.changedVariable, this.isDefaultInitialization, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableWrite other = (VariableWrite)obj;
        return Objects.equals(this.assignedValue, other.assignedValue) && Objects.equals(this.valueVariable, other.valueVariable) && Objects.equals(this.changedVariable, other.changedVariable) && Objects.equals(this.isDefaultInitialization, other.isDefaultInitialization) && this.type == other.type;
    }

    public String toString() {
        String representation = this.changedVariable + " = ";
        switch (this.type.ordinal()) {
            case 0: {
                representation = representation + "empty";
                break;
            }
            case 4: {
                representation = representation + "?";
                break;
            }
            case 2: {
                representation = representation + "value( " + this.assignedValue + " )";
                break;
            }
            case 1: {
                representation = representation + "var( " + this.valueVariable + " )";
                break;
            }
            case 3: {
                representation = representation + "null";
                break;
            }
            default: {
                CCSMAssert.fail((String)("You need to implement toString for type " + this.type.name()));
            }
        }
        if (this.isDefaultInitialization) {
            representation = representation + " [default init]";
        }
        return representation;
    }

    public static enum EVariableWriteType {
        EMPTY,
        VARIABLE,
        VALUE,
        NULL,
        OTHER;

    }
}

