/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowHeuristicFactory;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IConditionHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.IDefUseHeuristic;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.JumpLabelManager;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.conqat.engine.core.core.ConQATException;

public class DataFlowContext {
    private final IDefUseHeuristic defUseHeuristic;
    private final IConditionHeuristic conditionHeuristic;
    private final Stack<List<ControlFlowNode>> breakNodes = new Stack();
    private final Stack<List<ControlFlowNode>> continueNodes = new Stack();
    private final Stack<List<ControlFlowNode>> returnNodes = new Stack();
    private final Stack<List<ControlFlowNode>> caseEntryNodes = new Stack();
    private final Stack<ControlFlowNode> defaultCaseEntryNode = new Stack();
    private final JumpLabelManager codeLabelManager;
    private final String uniformPath;
    private final Stack<JumpLabelManager> caseLabelManager = new Stack();
    private final Set<ControlFlowNode> infiniteLoopNodes = new HashSet<ControlFlowNode>();

    public DataFlowContext(String uniformPath, ELanguage language, List<ShallowEntity> entities) throws ConQATException {
        this.uniformPath = uniformPath;
        this.defUseHeuristic = DataFlowHeuristicFactory.createDefUseHeuristic(language, entities);
        this.conditionHeuristic = DataFlowHeuristicFactory.createConditionHeuristic(language, this.defUseHeuristic);
        this.codeLabelManager = new JumpLabelManager(uniformPath);
        this.saveCurrentLoopNodes();
        this.saveCurrentReturnNodes();
        this.saveCurrentSwitchNodes();
    }

    public IDefUseHeuristic getDefUseHeuristic() {
        return this.defUseHeuristic;
    }

    public ControlFlowNode createNode(List<IToken> tokens, boolean containsCondition) {
        ControlFlowNode node = new ControlFlowNode(tokens, this.defUseHeuristic.parseStatement(tokens));
        if (containsCondition) {
            this.conditionHeuristic.createCondition(node);
        }
        return node;
    }

    public ControlFlowNode createSyntheticNode() {
        return new ControlFlowNode();
    }

    public ControlFlowNode createNode(List<IToken> tokens, VariableReadWriteInfo info) {
        return new ControlFlowNode(tokens, info);
    }

    public JumpLabelManager getCaseLabelManager() {
        return this.caseLabelManager.peek();
    }

    public JumpLabelManager getCodeLabelManager() {
        return this.codeLabelManager;
    }

    public List<ControlFlowNode> getBreakNodes() {
        return this.breakNodes.peek();
    }

    public List<ControlFlowNode> getContinueNodes() {
        return this.continueNodes.peek();
    }

    public List<ControlFlowNode> getReturnNodes() {
        return this.returnNodes.peek();
    }

    public List<ControlFlowNode> getCaseEntryNodes() {
        return this.caseEntryNodes.peek();
    }

    public Set<ControlFlowNode> getInfiniteLoopNodes() {
        return this.infiniteLoopNodes;
    }

    public ControlFlowNode getDefaultCaseEntryNode() {
        return this.defaultCaseEntryNode.peek();
    }

    public void saveCurrentLoopNodes() {
        this.breakNodes.push(new ArrayList());
        this.continueNodes.push(new ArrayList());
    }

    public void restorePreviousLoopNodes() {
        this.breakNodes.pop();
        this.continueNodes.pop();
    }

    public void saveCurrentBreakNodes() {
        this.breakNodes.push(new ArrayList());
    }

    public void restorePreviousBreakNodes() {
        this.breakNodes.pop();
    }

    public void saveCurrentReturnNodes() {
        this.returnNodes.push(new ArrayList());
    }

    public void restorePreviousReturnNodes() {
        this.returnNodes.pop();
    }

    public void saveCurrentSwitchNodes() {
        this.caseEntryNodes.push(new ArrayList());
        this.defaultCaseEntryNode.push(null);
        this.caseLabelManager.push(new JumpLabelManager(this.uniformPath));
    }

    public void restorePreviousSwitchNodes() {
        this.caseEntryNodes.pop();
        this.defaultCaseEntryNode.pop();
        this.caseLabelManager.pop();
    }

    public void saveAllCurrentContextNodes() {
        this.saveCurrentBreakNodes();
        this.saveCurrentLoopNodes();
        this.saveCurrentSwitchNodes();
        this.saveCurrentReturnNodes();
    }

    public void restoreAllPreviousContextNodes() {
        this.restorePreviousBreakNodes();
        this.restorePreviousLoopNodes();
        this.restorePreviousSwitchNodes();
        this.restorePreviousReturnNodes();
    }

    public void setDefaultCaseEntryNode(ControlFlowNode defaultCaseEntryNode) {
        this.defaultCaseEntryNode.pop();
        this.defaultCaseEntryNode.push(defaultCaseEntryNode);
    }
}

