/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.controlflowgraph.heuristics.rules;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.VariableReadWriteInfo;
import com.teamscale.index.dataflow.controlflowgraph.VariableWrite;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.ControlFlowCreator;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.DataFlowContext;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.IControlFlowRule;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.LoopRuleBase;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.rules.RuleUtils;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.sourcecode.util.SourceCodeMessageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class ForRule
extends LoopRuleBase {
    private static final TokenPattern LAST_IDENTIFIER_IN_LOOP_PATTERN = new TokenPattern().beginningOfStream().sequence(new Object[]{ETokenType.ETokenClass.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.RPAREN});
    private final ITokenMatcher forEachSeparatorTokenMatcher;

    public ForRule(ETokenType forEachSeparatorToken) {
        this.forEachSeparatorTokenMatcher = forEachSeparatorToken;
    }

    public ForRule(ITokenMatcher forEachSeparatorTokenMatcher) {
        this.forEachSeparatorTokenMatcher = forEachSeparatorTokenMatcher;
    }

    @Override
    public IControlFlowRule.Result transform(List<ShallowEntity> entities, DataFlowContext context, ControlFlowCreator creator) throws ConQATException {
        ShallowEntity forEntity = entities.get(0);
        UnmodifiableList tokens = forEntity.includedTokens();
        List<IToken> loopHeadTokens = ForRule.determineLoopHeadTokens((List<IToken>)tokens);
        List parts = TokenStreamUtils.splitWithNesting(loopHeadTokens, (ETokenType)ETokenType.SEMICOLON, (ETokenType)ETokenType.LBRACE, (ETokenType)ETokenType.RBRACE);
        context.getDefUseHeuristic().openNewScope();
        Nodes nodes = parts.size() == 1 ? this.processForEachLoop(context, loopHeadTokens) : (parts.size() == 2 ? this.processRangeBasedLoopWithInitStatement(context, parts) : ForRule.processForLoop(context, parts));
        ControlFlowNode.link(nodes.initNode, nodes.conditionEntryNode);
        IControlFlowRule.Result body = this.transformChildrenWithNewLoopContext(context, creator, (List<ShallowEntity>)forEntity.getChildren());
        ControlFlowNode.link(nodes.conditionExitNode, body.getEntryNode());
        for (ControlFlowNode exitNode : body.getExitNodes()) {
            ControlFlowNode.link(exitNode, nodes.updateNode);
        }
        RuleUtils.attachLambdaGraphs(forEntity, context, creator, nodes.initNode, nodes.conditionEntryNode, nodes.updateNode);
        List<ControlFlowNode> exitNodes = this.handleContinueAndBreak(context, nodes.updateNode);
        exitNodes.add(nodes.conditionEntryNode);
        context.getDefUseHeuristic().closeCurrentScope();
        return new IControlFlowRule.Result(1, nodes.initNode, exitNodes);
    }

    private static List<IToken> determineLoopHeadTokens(List<IToken> tokens) {
        int indexOfFirstLParen = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LPAREN);
        CCSMAssert.isFalse((indexOfFirstLParen == -1 ? 1 : 0) != 0, (String)("No opening parenthesis found in " + String.valueOf(tokens)));
        int indexOfClosingParen = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(indexOfFirstLParen + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        CCSMAssert.isFalse((indexOfClosingParen == -1 ? 1 : 0) != 0, (String)("No closing parenthesis found in " + String.valueOf(tokens)));
        return tokens.subList(0, indexOfClosingParen + 1);
    }

    private static Nodes processForLoop(DataFlowContext context, List<List<IToken>> parts) {
        Nodes nodes = new Nodes();
        List<IToken> initPart = parts.get(0);
        nodes.initNode = context.createNode(initPart.subList(2, initPart.size()), false);
        nodes.conditionExitNode = nodes.conditionEntryNode = context.createNode(parts.get(1), true);
        nodes.updateNode = context.createNode(parts.get(2), false);
        ControlFlowNode.link(nodes.updateNode, nodes.conditionEntryNode);
        return nodes;
    }

    private Nodes processRangeBasedLoopWithInitStatement(DataFlowContext context, List<List<IToken>> parts) {
        String loopVariable;
        Nodes nodes = new Nodes();
        List<IToken> initPart = parts.get(0);
        nodes.initNode = context.createNode(initPart.subList(2, initPart.size()), false);
        List iterationExpression = TokenStreamUtils.split(parts.get(1), (ITokenMatcher)this.forEachSeparatorTokenMatcher, (int)2);
        CCSMAssert.isTrue((iterationExpression.size() == 2 ? 1 : 0) != 0, (String)SourceCodeMessageUtils.createMessage((String)"Found a range-based for loop that does not have a proper iteration expression", parts.stream().flatMap(Collection::stream).collect(Collectors.toList()), null));
        List leftSide = (List)iterationExpression.get(0);
        IToken loopVariableToken = ForRule.determineLoopVariableToken(leftSide);
        List rightSide = (List)iterationExpression.get(1);
        VariableReadWriteInfo assignmentInfo = new VariableReadWriteInfo();
        if (loopVariableToken != null && loopVariableToken.getType() == ETokenType.IDENTIFIER && !(loopVariable = loopVariableToken.getText()).equals("_")) {
            context.getDefUseHeuristic().addToScope(loopVariable);
            assignmentInfo.getDefinitions().add(new VariableWrite(loopVariable));
        }
        nodes.conditionEntryNode = context.createNode((List<IToken>)rightSide, false);
        ForRule.addDereferenceForCollection(assignmentInfo, rightSide);
        nodes.conditionExitNode = context.createNode((List<IToken>)leftSide, assignmentInfo);
        nodes.updateNode = nodes.conditionEntryNode;
        ControlFlowNode.link(nodes.conditionEntryNode, nodes.conditionExitNode);
        return nodes;
    }

    private Nodes processForEachLoop(DataFlowContext context, List<IToken> tokens) throws AssertionError {
        String loopVariable;
        Nodes nodes = new Nodes();
        List parts = TokenStreamUtils.split(tokens, (ITokenMatcher)this.forEachSeparatorTokenMatcher, (int)2);
        CCSMAssert.isTrue((parts.size() == 2 ? 1 : 0) != 0, (String)SourceCodeMessageUtils.createMessage((String)"Found a for-each loop that does not have two parts", tokens, null));
        List leftSide = (List)parts.get(0);
        IToken loopVariableToken = ForRule.determineLoopVariableToken(leftSide);
        if (loopVariableToken == null) {
            throw new AssertionError((Object)SourceCodeMessageUtils.createMessage((String)"Found a for-each loop that does not have a proper loop variable", tokens, null));
        }
        VariableReadWriteInfo assignmentInfo = new VariableReadWriteInfo();
        if (loopVariableToken.getType() == ETokenType.IDENTIFIER && !(loopVariable = loopVariableToken.getText()).equals("_")) {
            context.getDefUseHeuristic().addToScope(loopVariable);
            assignmentInfo.getDefinitions().add(new VariableWrite(loopVariable));
        }
        List rightSide = (List)parts.get(1);
        nodes.initNode = context.createNode((List<IToken>)rightSide, false);
        nodes.conditionEntryNode = context.createSyntheticNode();
        ForRule.addDereferenceForCollection(assignmentInfo, rightSide);
        nodes.conditionExitNode = context.createNode((List<IToken>)leftSide, assignmentInfo);
        nodes.updateNode = nodes.conditionEntryNode;
        ControlFlowNode.link(nodes.conditionEntryNode, nodes.conditionExitNode);
        return nodes;
    }

    private static void addDereferenceForCollection(VariableReadWriteInfo assignmentInfo, List<IToken> collection) {
        TokenPatternMatch match = LAST_IDENTIFIER_IN_LOOP_PATTERN.findFirstMatch(collection);
        if (match != null) {
            assignmentInfo.getDereferenceInfo().addDereference(match, 0);
        }
    }

    private static IToken determineLoopVariableToken(List<IToken> leftSide) {
        for (int i = leftSide.size() - 1; i >= 0; --i) {
            IToken token = leftSide.get(i);
            if (token.getType() != ETokenType.IDENTIFIER && token.getType().getTokenClass() != ETokenType.ETokenClass.KEYWORD) continue;
            return token;
        }
        return null;
    }

    private static class Nodes {
        private ControlFlowNode initNode;
        private ControlFlowNode conditionEntryNode;
        private ControlFlowNode conditionExitNode;
        private ControlFlowNode updateNode;

        private Nodes() {
        }
    }
}

