/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.abap.ddic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.string.StringUtils;

class DdicFieldDefinitionStatement {
    private static final Pattern FIELD_NAME_ASSIGNEMENT_PATTERN = Pattern.compile("(?s)(?m)[^:]*(\\s|^)(\\S+)\\s+:\\s+(\\S+).*");
    private static final Pattern FOREIGN_KEY_TABLE_PATTERN = Pattern.compile("(?s)(?m)(?i)^[^:]*\\s+:.*\\s+with\\s+foreign\\s+key\\s+\\S+\\s+(\\S+).*");
    private final String statementText;
    private final int offset;
    private final int offsetLines;
    private final String uniformPath;

    DdicFieldDefinitionStatement(String uniformPath, String elementText, int start, int end) {
        this.statementText = elementText.substring(start, end);
        this.offset = start;
        this.offsetLines = StringUtils.countLines((String)elementText.substring(0, start)) - 1;
        this.uniformPath = uniformPath;
    }

    private TextRegionLocation buildLocation(int start, int end) {
        int startLine = StringUtils.countLines((String)this.statementText.substring(0, start)) + this.offsetLines;
        int endLine = StringUtils.countLines((String)this.statementText.substring(0, end)) + this.offsetLines;
        return new TextRegionLocation(this.uniformPath, start + this.offset, end + this.offset, startLine, endLine);
    }

    String getFieldName() {
        Matcher m = FIELD_NAME_ASSIGNEMENT_PATTERN.matcher(this.statementText);
        if (!m.matches()) {
            return null;
        }
        return m.group(2);
    }

    TextRegionLocation getAssignedType() {
        Matcher m = FIELD_NAME_ASSIGNEMENT_PATTERN.matcher(this.statementText);
        if (!m.matches()) {
            return null;
        }
        return this.buildLocation(m.start(3), m.end(3));
    }

    TextRegionLocation getForeignKeyTable() {
        Matcher m = FOREIGN_KEY_TABLE_PATTERN.matcher(this.statementText);
        if (!m.matches()) {
            return null;
        }
        return this.buildLocation(m.start(1), m.end(1));
    }
}

