/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dependencies.simulink;

import com.teamscale.index.dependencies.DependencyExtractorBase;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.dependencies.simulink.SimulinkParsingAndDependencyUtils;
import com.teamscale.index.resource.SimulinkDataDictionaryIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.model.ReferencedBlockInfo;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.datahandler.GotoFromResolver;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkDependencyExtractor
extends DependencyExtractorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<String, List<SimulinkLine>> modelsBlockToIncomingLinesMap;
    private LazyModelLoader modelLoader;

    @Override
    protected List<TypeDependencies> extractDependencies(TokenElementInfo tokenElementInfo) throws StorageException {
        ArrayList<TypeDependencies> result = new ArrayList<TypeDependencies>();
        String modelUniformPath = tokenElementInfo.getUniformPath();
        if (modelUniformPath.endsWith(".sldd")) {
            return result;
        }
        try {
            Optional<SimulinkModel> model;
            if (this.modelLoader == null) {
                this.modelLoader = new LazyModelLoader(this.dependencyExtractionIndexes.binaryElementIndex);
            }
            if ((model = this.modelLoader.getModelByUniformPath(modelUniformPath)).isEmpty()) {
                return result;
            }
            Collection allContainedLines = model.get().getContainedLinesRecursively(true, true);
            this.modelsBlockToIncomingLinesMap = allContainedLines.stream().filter(line -> line.getDstPort() != null).collect(Collectors.groupingBy(line -> line.getDstPort().getBlock().getId()));
            this.extractDependenciesFromModel((SimulinkBlock)model.get(), modelUniformPath, result, new GotoFromResolver((SimulinkBlock)model.get()));
        }
        catch (IOException | SimulinkModelBuildingException e) {
            LOGGER.warn("Encountered unparsable Simulink model: {}: {}", (Object)modelUniformPath, (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private void extractDependenciesFromModel(SimulinkBlock model, String modelUniformPath, List<TypeDependencies> result, GotoFromResolver gotoFromResolver) throws StorageException, IOException, SimulinkModelBuildingException {
        for (SimulinkBlock block : model.getSubBlocks()) {
            String modelName;
            ReferencedBlockInfo referenceInfo;
            if (!block.isOfType("Reference") && !SimulinkParsingAndDependencyUtils.isDisabledLibrary(block) || (referenceInfo = block.getReferencedBlockInfo()) == null || (modelName = SimulinkParsingAndDependencyUtils.getReferencedPath(referenceInfo.getBlockName(), this.dependencyExtractionIndexes.simulinkModelInfoIndex, true)) == null) continue;
            ListMap dependencyLocations = new ListMap();
            dependencyLocations.add((Object)modelName, (Object)new QualifiedNameLocation(block.getId(), modelUniformPath));
            Map<String, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>> portToSignals = this.getSignalsExitingReferenceBlock(block);
            this.searchForSignalDependencies(block, modelUniformPath, (ListMap<String, ElementLocation>)dependencyLocations, gotoFromResolver, (IdentityHashSet<SimulinkBlock>)new IdentityHashSet(), (Set)CollectionUtils.getAny(portToSignals.values()), portToSignals);
            result.add(new TypeDependencies(modelName, (ListMap<String, ElementLocation>)dependencyLocations));
        }
        List<SimulinkBlock> availableSubSystems = model.getSubBlocks().stream().filter(subBlock -> subBlock.hasSubBlocks() && !SimulinkParsingAndDependencyUtils.isDisabledLibrary(subBlock)).toList();
        for (SimulinkBlock block : availableSubSystems) {
            this.extractDependenciesFromModel(block, modelUniformPath, result, gotoFromResolver);
        }
    }

    private Map<String, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>> getSignalsExitingReferenceBlock(SimulinkBlock referenceBlock) throws StorageException {
        HashMap<String, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>> portToSignals = new HashMap<String, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>>();
        if (referenceBlock.getOutLines().isEmpty()) {
            return portToSignals;
        }
        SimulinkBlock srcBlock = SimulinkParsingAndDependencyUtils.getBlockReferencedBy(referenceBlock, this.dependencyExtractionIndexes.simulinkModelInfoIndex, this.modelLoader);
        if (srcBlock == null) {
            return portToSignals;
        }
        List<SimulinkBlock> outPorts = srcBlock.getSubBlocks().stream().filter(b -> b.isOfType("Outport")).toList();
        for (SimulinkBlock port : outPorts) {
            String outDataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)port);
            if (outDataType == null) continue;
            HashSet<String> busNames = new HashSet<String>();
            if ("Inherit: auto".equals(outDataType)) {
                List incomingLines = port.getInLines();
                this.deduceInheritedSignalsOutDataTypes(incomingLines, busNames, new HashSet<SimulinkBlock>());
            } else {
                busNames.add(StringUtils.stripPrefix((String)outDataType, (String)"Bus: ").trim());
            }
            HashSet<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> signalsOnBus = new HashSet<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>();
            for (String busName : busNames) {
                List<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> elements = this.dependencyExtractionIndexes.simulinkDataDictionaryIndex.getSignalsOnBus(busName);
                if (elements == null) continue;
                signalsOnBus.addAll(elements);
            }
            portToSignals.put(port.getParameter("Port"), signalsOnBus);
        }
        return portToSignals;
    }

    private void deduceInheritedSignalsOutDataTypes(List<SimulinkLine> incomingLines, Set<String> deducedSignalDataTypes, HashSet<SimulinkBlock> visitedBlocks) {
        if (incomingLines == null) {
            return;
        }
        for (SimulinkLine line : incomingLines) {
            SimulinkBlock srcBlock;
            SimulinkOutPort srcPort = line.getSrcPort();
            if (srcPort == null || visitedBlocks.contains(srcBlock = srcPort.getBlock())) continue;
            visitedBlocks.add(srcBlock);
            String retrievedOutDataType = SimulinkParsingAndDependencyUtils.getSignalOutDataTypeForBlock(srcBlock, srcPort.getIndex());
            if (retrievedOutDataType != null) {
                deducedSignalDataTypes.add(retrievedOutDataType);
                continue;
            }
            List<SimulinkLine> inLines = srcBlock.getInLines();
            if (!inLines.isEmpty()) {
                this.deduceInheritedSignalsOutDataTypes(inLines, deducedSignalDataTypes, new HashSet<SimulinkBlock>(visitedBlocks));
                return;
            }
            inLines = this.getIncomingLinesForDisconnectedBlock(srcBlock);
            this.deduceInheritedSignalsOutDataTypes(inLines, deducedSignalDataTypes, new HashSet<SimulinkBlock>(visitedBlocks));
        }
    }

    private List<SimulinkLine> getIncomingLinesForDisconnectedBlock(SimulinkBlock blockWithoutIncomingLines) {
        SimulinkBlock prevBlock;
        if (SimulinkUtils.isInport((SimulinkBlock)blockWithoutIncomingLines) && blockWithoutIncomingLines.getParent().isOfType("SubSystem") && (prevBlock = SimulinkParsingAndDependencyUtils.getPreviousBlockOutsideSubSystem(blockWithoutIncomingLines)) != null) {
            return prevBlock.getInLines();
        }
        String blockName = StringUtils.getLastPart((String)blockWithoutIncomingLines.getId(), (String)"/");
        Optional<String> newKey = this.modelsBlockToIncomingLinesMap.keySet().stream().filter(key -> key.endsWith(blockName)).findFirst();
        if (newKey.isPresent()) {
            return this.modelsBlockToIncomingLinesMap.get(newKey.get());
        }
        return Collections.emptyList();
    }

    private void searchForSignalDependencies(SimulinkBlock block, String modelUniformPath, ListMap<String, ElementLocation> dependencyLocations, GotoFromResolver gotoFromResolver, IdentityHashSet<SimulinkBlock> visitedBlocks, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> propagatedSignals, Map<String, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>> portIndexToSignalsMap) throws StorageException, IOException, SimulinkModelBuildingException {
        if (block == null || visitedBlocks.contains((Object)block) || propagatedSignals == null || propagatedSignals.isEmpty()) {
            return;
        }
        if ((block.isOfType("Reference") || SimulinkParsingAndDependencyUtils.isDisabledLibrary(block)) && portIndexToSignalsMap == null) {
            this.createDependency(block, dependencyLocations, modelUniformPath, propagatedSignals);
            return;
        }
        visitedBlocks.add((Object)block);
        Collection allOutSignals = block.getOutLines();
        if (allOutSignals.isEmpty()) {
            List<SimulinkBlock> nextBlocks = SimulinkDependencyExtractor.getNextBlocksAfterDisconnectedBlock(block, gotoFromResolver);
            for (SimulinkBlock nextBlock : nextBlocks) {
                this.searchForSignalDependencies(nextBlock, modelUniformPath, dependencyLocations, gotoFromResolver, (IdentityHashSet<SimulinkBlock>)new IdentityHashSet(visitedBlocks), new HashSet<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>(propagatedSignals), portIndexToSignalsMap);
            }
        } else {
            for (SimulinkLine outSignal : allOutSignals) {
                Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> signalsOnLine = this.determineSignalsOnLine(block, portIndexToSignalsMap, outSignal, new HashSet<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>(propagatedSignals));
                this.traverseOutgoingSignal(outSignal, dependencyLocations, gotoFromResolver, modelUniformPath, (IdentityHashSet<SimulinkBlock>)new IdentityHashSet(visitedBlocks), signalsOnLine);
            }
        }
    }

    private void createDependency(SimulinkBlock block, ListMap<String, ElementLocation> dependencyLocations, String modelUniformPath, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> propagatedSignals) throws StorageException {
        String dependency = SimulinkParsingAndDependencyUtils.getReferencedPath(block.getReferencedBlockInfo().getBlockName(), this.dependencyExtractionIndexes.simulinkModelInfoIndex, true);
        if (dependency == null) {
            return;
        }
        dependencyLocations.add((Object)dependency, (Object)new QualifiedNameLocation(block.getId(), modelUniformPath, true, CollectionUtils.map(propagatedSignals, SimulinkDataDictionaryIndex.ShallowSimulinkBusElement::busElementName)));
    }

    private Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> determineSignalsOnLine(SimulinkBlock block, Map<String, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>> portIndexToSignalsMap, SimulinkLine outSignal, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> propagatedSignals) throws StorageException {
        SimulinkOutPort srcPort = outSignal.getSrcPort();
        if (srcPort == null) {
            return Collections.emptySet();
        }
        if (block.isOfType("Reference")) {
            return portIndexToSignalsMap.get(srcPort.getIndex());
        }
        if (block.isOfType("BusSelector")) {
            int portIndex;
            String outputSignals = block.getParameter("OutputSignals");
            if (outputSignals == null) {
                return propagatedSignals;
            }
            String[] selectedSignals = outputSignals.split(",");
            if (selectedSignals.length < (portIndex = Integer.parseInt(srcPort.getIndex()))) {
                return propagatedSignals;
            }
            String signal = StringUtils.getLastPart((String)selectedSignals[portIndex - 1], (String)".");
            List<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> busSignals = this.dependencyExtractionIndexes.simulinkDataDictionaryIndex.getSignalsOnBus(signal);
            return busSignals.stream().filter(propagatedSignals::contains).collect(Collectors.toSet());
        }
        return propagatedSignals;
    }

    private static List<SimulinkBlock> getNextBlocksAfterDisconnectedBlock(SimulinkBlock blockWithoutOutgoingSignals, GotoFromResolver gotoFromResolver) {
        if (blockWithoutOutgoingSignals.isOfType("Goto")) {
            return gotoFromResolver.getConnectedFromBlocks(blockWithoutOutgoingSignals);
        }
        if (blockWithoutOutgoingSignals.isOfType("Outport") && blockWithoutOutgoingSignals.getParent().isOfType("SubSystem") && !SimulinkParsingAndDependencyUtils.isDisabledLibrary(blockWithoutOutgoingSignals.getParent())) {
            return SimulinkParsingAndDependencyUtils.getNextBlocksOutsideSubSystem(blockWithoutOutgoingSignals);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void traverseOutgoingSignal(SimulinkLine outSignal, ListMap<String, ElementLocation> dependencyLocations, GotoFromResolver gotoFromResolver, String modelUniformPath, IdentityHashSet<SimulinkBlock> visitedBlocks, Set<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement> propagatedSignals) throws StorageException, IOException, SimulinkModelBuildingException {
        if (propagatedSignals == null || propagatedSignals.isEmpty() || outSignal.getDstPort() == null) {
            return;
        }
        SimulinkBlock dstBlock = outSignal.getDstPort().getBlock();
        if (dstBlock.isOfType("Reference") || SimulinkParsingAndDependencyUtils.isDisabledLibrary(dstBlock)) {
            this.createDependency(dstBlock, dependencyLocations, modelUniformPath, propagatedSignals);
            return;
        }
        if (dstBlock.isOfType("SubSystem")) {
            Optional<SimulinkBlock> nextBlock = SimulinkParsingAndDependencyUtils.getNextBlockInsideSubSystem(outSignal);
            if (!nextBlock.isPresent()) return;
            dstBlock = nextBlock.get();
        } else if (dstBlock.isOfType("BusCreator")) {
            SimulinkParsingAndDependencyUtils.updatePropagatedSignals(dstBlock, propagatedSignals, this.dependencyExtractionIndexes.simulinkDataDictionaryIndex);
        }
        this.searchForSignalDependencies(dstBlock, modelUniformPath, dependencyLocations, gotoFromResolver, visitedBlocks, new HashSet<SimulinkDataDictionaryIndex.ShallowSimulinkBusElement>(propagatedSignals), null);
    }
}

