/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.index.findings.calculation.EBlacklistingOption;
import com.teamscale.index.findings.calculation.EPendingExclusionOption;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class BasicFindingsFilterSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ONLY_SPEC_ITEM_FINDINGS_PARAMETER_DESCRIPTION = "If this is true, only spec item findings are to be shown.";
    private static final String INVERT_CATEGORY_GROUP_TYPE_FILTERS = "invert";
    private static final String EXCLUDE_REGEX_PARAMETER_NAME = "exclude-regex";
    private static final String REGEX_PARAMETER_NAME = "regex";
    private static final String GUIDELINE_PARAMETER_NAME = "guideline";
    private static final String GUIDELINE_RULES_PARAMETER_NAME = "guideline-rules";
    public static final String ASSESSMENT_PARAMETER_NAME = "assessment-filters";
    public static final String BLACKLISTING_PARAMETER_NAME = "blacklisted";
    private static final String FILTER_PARAMETER_NAME = "filter";
    private static final String ADDED_TO_TASK_PARAMETER_NAME = "added-to-task";
    public static final String INCLUDED_PATHS_PARAMETER_NAME = "included-paths";
    public static final String EXCLUDED_PATHS_PARAMETER_NAME = "excluded-paths";
    public static final String ONLY_SPEC_ITEM_FINDINGS_PARAMETER_NAME = "only-spec-item-findings";
    public static final String SPEC_ITEM_QUERY_PARAMETER_NAME = "spec-item-query";
    @QueryParam(value="regex")
    @Parameter(description="The case-insensitive regex filter. Filters findings by this regex. Considered Fields are Message and Location. Matches will be included in the result.")
    private @Nullable Pattern regexFilter = null;
    @QueryParam(value="guideline")
    @Parameter(description="The guideline filter. Filters findings showing only findings which are relevant for this guideline.")
    private @Nullable String guidelineFilter = null;
    @QueryParam(value="guideline-rules")
    @Parameter(description="The guideline filter. Filters findings showing only findings which are relevant for this guideline.")
    private @Nullable List<String> guidelineRulesFilter;
    @QueryParam(value="exclude-regex")
    @Parameter(description="Whether regex excludes or includes findings.")
    private boolean excludeRegexFilter = false;
    @QueryParam(value="added-to-task")
    @Parameter(description="The added to task filter. Filter findings that already have a task assigned.")
    private boolean filterFindingsAddedToTasks = false;
    @QueryParam(value="filter")
    @Parameter(description="The finding category, group, and type filters. Every string must be either a single category, a combination category/group, or a type ID. If a category or group is given, all matching findings will be filtered out and not included in the result.")
    private @Nullable List<String> categoryGroupTypeFilters;
    @QueryParam(value="invert")
    @Parameter(description="Whether to invert the category, group, type filters, i.e. including the elements given in the filters instead of excluding them.")
    private boolean invertCategoryGroupTypeFilters = false;
    @QueryParam(value="assessment-filters")
    @Parameter(description="The assessment filter. All mentioned assessment colors will be filtered out and not included in the result.")
    private @Nullable List<ETrafficLightColor> assessmentFilters = Collections.emptyList();
    @QueryParam(value="blacklisted")
    @DefaultValue(value="excluded")
    @Parameter(description="Allows to filter findings that have been tolerated and/or marked as false positives.")
    private EBlacklistingOption blacklistingOption;
    @QueryParam(value="pending-exclusions")
    @DefaultValue(value="ALL")
    @Parameter(description="Further specifies whether pending finding exclusions should be included/excluded")
    private EPendingExclusionOption pendingExclusionOption;
    @QueryParam(value="included-paths")
    @Parameter(description="If this parameter is given, only findings whose uniform path matches one of the given Ant patterns are returned.")
    private @Nullable List<String> includedPaths = Collections.emptyList();
    @QueryParam(value="excluded-paths")
    @Parameter(description="If this parameter is given, only findings whose uniform path does not match one of the given Ant patterns are returned.")
    private @Nullable List<String> excludedPaths = Collections.emptyList();
    @QueryParam(value="only-spec-item-findings")
    @Parameter(description="If this is true, only spec item findings are to be shown.")
    private boolean onlySpecItemFindings = false;

    public BasicFindingsFilterSettings() {
        this.guidelineRulesFilter = Collections.emptyList();
        this.categoryGroupTypeFilters = Collections.emptyList();
        this.blacklistingOption = EBlacklistingOption.EXCLUDED;
        this.pendingExclusionOption = EPendingExclusionOption.ALL;
    }

    public @Nullable List<ETrafficLightColor> getAssessmentFilters() {
        return this.assessmentFilters;
    }

    public Pattern getRegexFilter() {
        if (this.regexFilter == null) {
            return null;
        }
        if ((this.regexFilter.flags() & 2) == 0) {
            this.regexFilter = Pattern.compile(this.regexFilter.pattern(), this.regexFilter.flags() | 2);
        }
        return this.regexFilter;
    }

    public void setRegexFilter(String regexFilter) {
        this.regexFilter = Pattern.compile(regexFilter, 2);
    }

    public @Nullable String getGuidelineFilter() {
        return this.guidelineFilter;
    }

    public @Nullable List<String> getGuidelineRulesFilter() {
        return this.guidelineRulesFilter;
    }

    public boolean isFilterFindingsAddedToTasks() {
        return this.filterFindingsAddedToTasks;
    }

    public @Nullable List<String> getCategoryGroupTypeFilters() {
        return this.categoryGroupTypeFilters;
    }

    public void setCategoryGroupTypeFilters(@Nullable List<String> categoryGroupTypeFilters) {
        this.categoryGroupTypeFilters = categoryGroupTypeFilters;
    }

    public boolean isInvertCategoryGroupTypeFilters() {
        return this.invertCategoryGroupTypeFilters;
    }

    public void setInvertCategoryGroupTypeFilters(boolean invertCategoryGroupTypeFilters) {
        this.invertCategoryGroupTypeFilters = invertCategoryGroupTypeFilters;
    }

    public boolean isExcludeRegexFilter() {
        return this.excludeRegexFilter;
    }

    public EBlacklistingOption getBlacklistingOption() {
        return this.blacklistingOption;
    }

    public void setBlacklistingOption(EBlacklistingOption blacklistingOption) {
        this.blacklistingOption = blacklistingOption;
    }

    public EPendingExclusionOption getPendingExclusionOption() {
        return Objects.requireNonNullElse(this.pendingExclusionOption, EPendingExclusionOption.ALL);
    }

    public void setPendingExclusionOption(EPendingExclusionOption pendingExclusionOption) {
        this.pendingExclusionOption = pendingExclusionOption;
    }

    public List<String> getIncludedPaths() {
        return Objects.requireNonNullElseGet(this.includedPaths, Collections::emptyList);
    }

    public void setIncludedPaths(@Nullable List<String> includedPaths) {
        this.includedPaths = includedPaths;
    }

    public List<String> getExcludedPaths() {
        return Objects.requireNonNullElseGet(this.excludedPaths, Collections::emptyList);
    }

    public void setExcludedPaths(@Nullable List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    public boolean isOnlySpecItemFindings() {
        return this.onlySpecItemFindings;
    }
}

