/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;

public record ExcludedFindingsCount(@JsonProperty int nonExcludedFindingsCount, @JsonProperty int toleratedFindingsCount, @JsonProperty int pendingToleratedFindingsCount, @JsonProperty int falsePositivesCount, @JsonProperty int pendingFalsePositivesCount) {
    public static final ExcludedFindingsCount EMPTY = new ExcludedFindingsCount(0, 0, 0, 0, 0);

    @JsonCreator
    public ExcludedFindingsCount {
        Preconditions.checkArgument((nonExcludedFindingsCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((toleratedFindingsCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((pendingToleratedFindingsCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((falsePositivesCount >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((pendingFalsePositivesCount >= 0 ? 1 : 0) != 0);
    }

    public static ExcludedFindingsCount merge(ExcludedFindingsCount first, ExcludedFindingsCount second) {
        int falsePositivesCount = first.falsePositivesCount + second.falsePositivesCount;
        int pendingFalsePositivesCount = first.pendingFalsePositivesCount + second.pendingFalsePositivesCount;
        int toleratedCount = first.toleratedFindingsCount + second.toleratedFindingsCount;
        int pendingToleratedCount = first.pendingToleratedFindingsCount + second.pendingToleratedFindingsCount;
        int nonBlacklistedFindingsCount = first.nonExcludedFindingsCount + second.nonExcludedFindingsCount;
        return new ExcludedFindingsCount(nonBlacklistedFindingsCount, toleratedCount, pendingToleratedCount, falsePositivesCount, pendingFalsePositivesCount);
    }

    public static ExcludedFindingsCount from(List<ExtendedTrackedFinding> findings) {
        CounterSet counts = (CounterSet)findings.stream().map(finding -> {
            Optional<FindingBlacklistInfo> blacklistInfo = finding.getBlacklistInfo();
            return blacklistInfo.map(findingBlacklistInfo -> Pair.createPair((Object)((Object)findingBlacklistInfo.getType()), (Object)findingBlacklistInfo.getApprovalState().resolved())).orElse(null);
        }).collect(CounterSet.toCounterSet());
        return new ExcludedFindingsCount(counts.getValue(null), counts.getValue((Object)Pair.createPair((Object)((Object)EFindingBlacklistType.TOLERATION), (Object)true)), counts.getValue((Object)Pair.createPair((Object)((Object)EFindingBlacklistType.TOLERATION), (Object)false)), counts.getValue((Object)Pair.createPair((Object)((Object)EFindingBlacklistType.FALSE_POSITIVE), (Object)true)), counts.getValue((Object)Pair.createPair((Object)((Object)EFindingBlacklistType.FALSE_POSITIVE), (Object)false)));
    }
}

