/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.index.blacklisting.EFindingBlacklistUpdateType;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.UserResolvedFindingBlacklistInfo;
import com.teamscale.index.findings.calculation.ExtendedFindingDelta;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.index.user.UserAliasLookup;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ExtendedTrackedFindingUtils {
    public static ExtendedFindingDelta fromFindingDelta(FindingDelta findingDelta, FindingsCalculationInfo calculationInfo, IFindingsRetriever findingsRetriever, CommitDescriptor ... commits) throws StorageException {
        TaskIndex taskIndex = (TaskIndex)calculationInfo.projectStorageSystem().openProjectIndex(TaskIndex.class, null);
        FindingsSchemaIndex findingsSchemaIndex = (FindingsSchemaIndex)calculationInfo.projectStorageSystem().openProjectIndex(FindingsSchemaIndex.class, null);
        Map<String, @NonNull FindingBlacklistInfo> blacklistInfo = ExtendedTrackedFindingUtils.getBlacklistInfosForBranches(findingsRetriever, findingDelta.getAllFindings(), commits);
        CodeScopeAware<Set<String>> findingTypeIds = ExtendedTrackedFindingUtils.getCodeScopeAwareTypeIds(findingDelta.getAllFindings());
        CodeScopeAware typeIdToTypeDescription = findingsSchemaIndex.getFindingTypeDescriptions(findingTypeIds);
        SetMap<String, Task> taskReferencesByFinding = ExtendedTrackedFindingUtils.getTaskReferencesByFinding(taskIndex);
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance(calculationInfo.indexLayer().openGlobalStorageSystem());
        List<ExtendedTrackedFinding> addedFindings = ExtendedTrackedFindingUtils.enhanceFindings(findingDelta.getAddedFindings(), (CodeScopeAware<Map<String, FindingTypeDescription>>)typeIdToTypeDescription, taskReferencesByFinding, blacklistInfo, userAliasLookup);
        List<ExtendedTrackedFinding> findingsInChangedCode = ExtendedTrackedFindingUtils.enhanceFindings(findingDelta.getFindingsInChangedCode(), (CodeScopeAware<Map<String, FindingTypeDescription>>)typeIdToTypeDescription, taskReferencesByFinding, blacklistInfo, userAliasLookup);
        List<ExtendedTrackedFinding> removedFindings = ExtendedTrackedFindingUtils.enhanceFindings(findingDelta.getRemovedFindings(), (CodeScopeAware<Map<String, FindingTypeDescription>>)typeIdToTypeDescription, taskReferencesByFinding, blacklistInfo, userAliasLookup);
        return new ExtendedFindingDelta(addedFindings, findingsInChangedCode, removedFindings);
    }

    private static CodeScopeAware<Set<String>> getCodeScopeAwareTypeIds(Collection<TrackedFinding> findings) {
        return CodeScopeAware.fromMap(findings.stream().collect(Collectors.groupingBy(TrackedFinding::getCodeScopeName, Collectors.mapping(IndexFinding::getTypeId, Collectors.toSet()))));
    }

    private static @NonNull Map<String, @NonNull FindingBlacklistInfo> getBlacklistInfosForBranches(IFindingsRetriever findingsRetriever, Set<TrackedFinding> findings, CommitDescriptor ... commits) throws StorageException {
        HashMap<String, @NonNull FindingBlacklistInfo> blacklistInfo = new HashMap<String, FindingBlacklistInfo>();
        for (CommitDescriptor commit : commits) {
            blacklistInfo.putAll(findingsRetriever.getFlaggedFindings(findings, CommitDescriptor.latestOnBranch((String)commit.getBranchName())));
        }
        return blacklistInfo;
    }

    public static @NonNull List<ExtendedTrackedFinding> fromTrackedFindings(List<TrackedFinding> allFindings, FindingsCalculationInfo calculationInfo, Map<String, FindingBlacklistInfo> findingBlacklistInfoMap) throws StorageException {
        FindingsSchemaIndex findingsSchemaIndex = (FindingsSchemaIndex)calculationInfo.projectStorageSystem().openProjectIndex(FindingsSchemaIndex.class, null);
        CodeScopeAware<Set<String>> findingTypeIds = ExtendedTrackedFindingUtils.getCodeScopeAwareTypeIds(allFindings);
        CodeScopeAware typeIdToTypeDescription = findingsSchemaIndex.getFindingTypeDescriptions(findingTypeIds);
        return ExtendedTrackedFindingUtils.buildLookup(calculationInfo, (CodeScopeAware<Map<String, FindingTypeDescription>>)typeIdToTypeDescription).enhance(allFindings, findingBlacklistInfoMap);
    }

    public static ExtendedFindingLookup buildLookup(FindingsCalculationInfo calculationInfo) throws StorageException {
        ProjectStorageSystem projectStorageSystem = calculationInfo.projectStorageSystem();
        SequencedSet codeScopes = ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem).getCodeScopeNames();
        CodeScopeAware typeIdToTypeDescription = ((FindingsSchemaIndex)projectStorageSystem.openProjectIndex(FindingsSchemaIndex.class, null)).getAllFindingTypeDescriptions((Collection)codeScopes);
        return ExtendedTrackedFindingUtils.buildLookup(calculationInfo, (CodeScopeAware<Map<String, FindingTypeDescription>>)typeIdToTypeDescription);
    }

    private static ExtendedFindingLookup buildLookup(FindingsCalculationInfo calculationInfo, CodeScopeAware<Map<String, FindingTypeDescription>> typeIdToTypeDescription) throws StorageException {
        TaskIndex taskIndex = (TaskIndex)calculationInfo.projectStorageSystem().openProjectIndex(TaskIndex.class, null);
        SetMap<String, Task> taskReferencesByFinding = ExtendedTrackedFindingUtils.getTaskReferencesByFinding(taskIndex);
        return new ExtendedFindingLookup(typeIdToTypeDescription, taskReferencesByFinding, UserAliasLookup.createInstance(calculationInfo.indexLayer().openGlobalStorageSystem()));
    }

    private static @NonNull List<ExtendedTrackedFinding> enhanceFindings(List<TrackedFinding> allFindings, CodeScopeAware<Map<String, FindingTypeDescription>> typeIdToTypeDescription, SetMap<String, Task> taskReferencesByFinding, Map<String, FindingBlacklistInfo> findingBlacklistInfoMap, UserAliasLookup userAliasLookup) {
        Map<String, UserResolvedFindingBlacklistInfo> userResolvedFindingBlacklistInfoMap = findingBlacklistInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new UserResolvedFindingBlacklistInfo((FindingBlacklistInfo)entry.getValue(), EFindingBlacklistUpdateType.ADD, userAliasLookup)));
        return CollectionUtils.map(allFindings, finding -> {
            FindingTypeDescription findingTypeDescription = (FindingTypeDescription)((Map)typeIdToTypeDescription.getValue(finding.getCodeScopeName())).get(finding.getTypeId());
            String typeName = findingTypeDescription.getName();
            Set tasks = (Set)taskReferencesByFinding.getCollectionOrElse((Object)finding.getId(), Set.of());
            ListMap<ETaskStatus, ExtendedTrackedFinding.SimpleTask> tasksByStatus = ExtendedTrackedFindingUtils.groupByStatus(tasks);
            UserResolvedFindingBlacklistInfo blacklistInfo = (UserResolvedFindingBlacklistInfo)userResolvedFindingBlacklistInfoMap.get(finding.getId());
            return new ExtendedTrackedFinding((TrackedFinding)finding, typeName, tasksByStatus, blacklistInfo);
        });
    }

    private static @NonNull SetMap<String, Task> getTaskReferencesByFinding(TaskIndex taskIndex) throws StorageException {
        List<Task> allTasks = taskIndex.getAllTasks();
        SetMap taskReferencesByFinding = new SetMap();
        for (Task task : allTasks) {
            for (String findingId : task.getFindingIds()) {
                taskReferencesByFinding.add((Object)findingId, (Object)task);
            }
        }
        return taskReferencesByFinding;
    }

    private static ListMap<ETaskStatus, ExtendedTrackedFinding.SimpleTask> groupByStatus(Set<Task> tasks) {
        ListMap resultingTasks = new ListMap();
        CollectionUtils.map(tasks, task -> resultingTasks.add((Object)task.getStatus(), (Object)new ExtendedTrackedFinding.SimpleTask(task.getId(), task.getSubject())));
        return resultingTasks;
    }

    private ExtendedTrackedFindingUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static final class ExtendedFindingLookup {
        private final CodeScopeAware<Map<String, FindingTypeDescription>> typeIdToTypeDescription;
        private final SetMap<String, Task> taskReferencesByFinding;
        private final UserAliasLookup userAliasLookup;

        private ExtendedFindingLookup(CodeScopeAware<Map<String, FindingTypeDescription>> typeIdToTypeDescription, SetMap<String, Task> taskReferencesByFinding, UserAliasLookup userAliasLookup) {
            this.typeIdToTypeDescription = typeIdToTypeDescription;
            this.taskReferencesByFinding = taskReferencesByFinding;
            this.userAliasLookup = userAliasLookup;
        }

        public List<ExtendedTrackedFinding> enhance(List<TrackedFinding> findings, Map<String, FindingBlacklistInfo> flaggingInfo) {
            return ExtendedTrackedFindingUtils.enhanceFindings(findings, this.typeIdToTypeDescription, this.taskReferencesByFinding, flaggingInfo, this.userAliasLookup);
        }

        public CodeScopeAware<Map<String, FindingTypeDescription>> getTypeIdToTypeDescription() {
            return this.typeIdToTypeDescription;
        }
    }
}

