/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.TrackedFinding;

public class FindingsPaginationOptions {
    private static final int FINDINGS_LIMIT = 300;
    public static final String NO_PAGINATION_PARAMETER_NAME = "all";
    @QueryParam(value="start")
    @DefaultValue(value="0")
    @Parameter(description="If this parameter is given, the findings returned will start from this index (0 based), i.e. the first start findings in the list (for current sorting) will be skipped.")
    private int startIndex;
    @QueryParam(value="max")
    @DefaultValue(value="300")
    @Parameter(description="Limits the number of findings returned. If also the parameter 'all' is used, the limit is ignored. Providing no limit will use the default limit of 300.")
    private int maxResult;
    @QueryParam(value="all")
    @Parameter(description="If this is true, the finding list is not truncated to 300 elements.")
    private boolean allFindings;

    public <T extends TrackedFinding> List<T> selectFindingsRange(List<T> findings) {
        int start = this.startIndex;
        int end = start + this.maxResult;
        end = Math.min(end, findings.size());
        if (this.allFindings) {
            end = findings.size();
        }
        if (start >= end) {
            return new ArrayList();
        }
        return new ArrayList<T>(findings.subList(start, end));
    }

    public static FindingsPaginationOptions all() {
        FindingsPaginationOptions paginationOptions = new FindingsPaginationOptions();
        paginationOptions.allFindings = true;
        return paginationOptions;
    }

    public @Nullable Integer getNextStartIndex() {
        if (this.allFindings) {
            return null;
        }
        return this.startIndex + this.maxResult;
    }
}

