/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.kubescore;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.log.parse.ParseLogEntry;
import com.teamscale.core.log.parse.ParseLogIndex;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.kubescore.HelmChartBuilder;
import com.teamscale.index.findings.kubescore.KubernetesChecksRunner;
import com.teamscale.index.findings.kubescore.KubernetesKubeScoreChecksRunner;
import com.teamscale.index.findings.kubescore.KubernetesManifestBuilder;
import com.teamscale.index.findings.kubescore.KubernetesResourceDiscriminator;
import com.teamscale.index.findings.kubescore.KubernetesTeamscaleChecksRunner;
import com.teamscale.index.findings.kubescore.KubernetesUtils;
import com.teamscale.index.findings.kubescore.KustomizationBuilder;
import com.teamscale.index.repository.history.EElementHistoryChangeType;
import com.teamscale.index.repository.history.ElementHistoryEntry;
import com.teamscale.index.repository.history.ElementHistoryIndex;
import com.teamscale.index.resource.KubernetesManifestIndex;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.scanner.ambiguous_language.KubernetesLanguageDetector;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;

public class KubeScoreFindingsSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    public static final String MANIFEST_ERROR_CONTENT = "Manifest could not be built. See 'Parsing issues found!' on the right side or System > Parse Log for more details.";
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="kubernetes-manifest")
    protected KubernetesManifestIndex kubernetesManifestIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="dependencies")
    protected DependencyListIndex dependencyListIndex;
    public static final String DISABLE_CPU_LIMIT_CHECK = "disable-cpu-limit-check";
    public static final String HELM_VALUE_FOLDER = "helm-value-folder";
    public static final String HELM_VALUE_FILES_REGEX = "helm-value-files-regex";
    private static final Logger LOGGER = LogManager.getLogger();
    private final String partition = "kubescore-internal";
    private ListMap<String, IndexFinding> globalFindingsByUniformPath;
    private List<ParseLogEntry> parseLogEntries;
    private final Set<String> skippedKubernetesResources = new HashSet<String>();
    @StepParameter(value="disable-cpu-limit-check")
    private boolean disableCpuLimitCheck = false;
    @StepParameter(value="helm-value-folder", optional=true)
    private String helmValueFolder = null;
    @StepParameter(value="helm-value-files-regex")
    private String helmValueFilesRegex = null;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private ParseLogIndex parseLogIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ElementHistoryIndex elementHistoryIndex;

    public void execute() throws StorageException {
        this.globalFindingsByUniformPath = new ListMap();
        this.parseLogEntries = new ArrayList<ParseLogEntry>();
        List<String> allKubernetesKeys = this.getKubernetesKeys(this.contentIndex.getAllUniformPaths());
        KubernetesResourceDiscriminator discriminator = new KubernetesResourceDiscriminator(this.contentIndex, this.getContentIndexCache(), this.getSchedulingCommit(), allKubernetesKeys);
        Map<String, Set<String>> rootKustomizationsWithAffectedFiles = discriminator.getRootKustomizationsWithAffectedFiles();
        Set<String> rootHelmCharts = discriminator.getRootHelmCharts();
        Set<String> staticManifests = discriminator.getStaticManifests(rootKustomizationsWithAffectedFiles, rootHelmCharts);
        this.parseLogEntries.addAll(discriminator.getParseLogEntries());
        Set<String> kubernetesResourcesToAnalyze = this.getKubernetesResourcesToAnalyze(staticManifests, rootHelmCharts, rootKustomizationsWithAffectedFiles);
        List<String> additionalResourcesToAnalyze = this.getAdditionalResourcesToAnalyze(kubernetesResourcesToAnalyze, rootKustomizationsWithAffectedFiles, staticManifests, rootHelmCharts);
        kubernetesResourcesToAnalyze.addAll(additionalResourcesToAnalyze);
        try {
            Pattern helmValueFilesRegexPattern = Pattern.compile(this.helmValueFilesRegex);
            for (String kubernetesResource : kubernetesResourcesToAnalyze) {
                this.analyzeKubernetesResource(kubernetesResource, rootKustomizationsWithAffectedFiles, helmValueFilesRegexPattern);
            }
            HashSet allAnalyzedPaths = CollectionUtils.differenceSet(kubernetesResourcesToAnalyze, (Collection[])new Collection[]{this.skippedKubernetesResources});
            this.synchronizeFindings((CodeScopeAware<ListMap<String, IndexFinding>>)CodeScopeAware.defaultCodeScopeWithValue(this.globalFindingsByUniformPath), "kubescore-internal", allAnalyzedPaths);
            this.cleanup(allKubernetesKeys, rootHelmCharts, rootKustomizationsWithAffectedFiles.keySet(), staticManifests);
            this.updateDependencyListIndex(rootKustomizationsWithAffectedFiles);
            this.parseLogIndex.persistLogEntries(this.parseLogEntries);
        }
        catch (ConQATException e) {
            LOGGER.error("Error running {}: {}", ((Object)((Object)this)).getClass(), (Object)e, (Object)e);
        }
    }

    private void updateDependencyListIndex(Map<String, Set<String>> rootKustomizationsWithAffectedFiles) throws StorageException {
        PairList rootKustomizationsWithAffectedFilesForIndex = new PairList();
        for (Map.Entry<String, Set<String>> rootKustomizationWithAffectedFile : rootKustomizationsWithAffectedFiles.entrySet()) {
            String rootKustomization = rootKustomizationWithAffectedFile.getKey();
            Set<String> affectedFiles = rootKustomizationWithAffectedFile.getValue();
            if (this.skippedKubernetesResources.contains(rootKustomization)) continue;
            rootKustomizationsWithAffectedFilesForIndex.add((Object)rootKustomization, new ArrayList<String>(affectedFiles));
        }
        this.dependencyListIndex.removeDependencies(new ArrayList<String>(this.skippedKubernetesResources));
        this.dependencyListIndex.setDependencies((PairList<String, ArrayList<String>>)rootKustomizationsWithAffectedFilesForIndex);
    }

    private @NonNull Set<String> getKubernetesResourcesToAnalyze(Set<String> staticManifests, Set<String> rootHelmCharts, Map<String, Set<String>> rootKustomizationsWithAffectedFiles) throws StorageException {
        List addedOrChangedKeysAsStrings = this.contentDelta.getAddedOrChangedKeysAsStrings();
        List<String> addedOrChangedKubernetesKeys = this.getKubernetesKeys(addedOrChangedKeysAsStrings);
        HashSet<String> kubernetesResourcesToAnalyze = new HashSet<String>();
        for (String addedOrChangedKey : addedOrChangedKubernetesKeys) {
            String kubernetesResourceToAnalyze = KubeScoreFindingsSynchronizer.getKubernetesResourceToAnalyze(staticManifests, rootHelmCharts, rootKustomizationsWithAffectedFiles, addedOrChangedKey);
            if (kubernetesResourceToAnalyze == null) continue;
            kubernetesResourcesToAnalyze.add(kubernetesResourceToAnalyze);
        }
        return kubernetesResourcesToAnalyze;
    }

    private static @Nullable String getKubernetesResourceToAnalyze(Set<String> staticManifests, Set<String> rootHelmCharts, Map<String, Set<String>> rootKustomizationsWithAffectedFiles, String addedOrChangedKey) {
        if (staticManifests.contains(addedOrChangedKey)) {
            return addedOrChangedKey;
        }
        Optional<String> rootHelmChartToAnalyze = rootHelmCharts.stream().filter(rootHelmChart -> addedOrChangedKey.startsWith(UniformPathUtils.getParentPath((String)rootHelmChart))).findFirst();
        if (rootHelmChartToAnalyze.isPresent()) {
            return rootHelmChartToAnalyze.get();
        }
        Optional<Map.Entry> rootKustomizationWithAffectedFilesToAnalyze = rootKustomizationsWithAffectedFiles.entrySet().stream().filter(rootKustomizationWithAffectedFiles -> ((String)rootKustomizationWithAffectedFiles.getKey()).equals(addedOrChangedKey) || ((Set)rootKustomizationWithAffectedFiles.getValue()).contains(addedOrChangedKey)).findFirst();
        if (rootKustomizationWithAffectedFilesToAnalyze.isEmpty()) {
            if (KubeScoreFindingsSynchronizer.hasKubernetesFileExtension(addedOrChangedKey)) {
                LOGGER.warn("Could not find a matching Kubernetes resource to analyze for {}", (Object)addedOrChangedKey);
            }
            return null;
        }
        return (String)rootKustomizationWithAffectedFilesToAnalyze.get().getKey();
    }

    private List<String> getAdditionalResourcesToAnalyze(Set<String> kubernetesResourcesToAnalyze, Map<String, Set<String>> rootKustomizationsWithAffectedFiles, Set<String> staticManifests, Set<String> rootHelmCharts) throws StorageException {
        ArrayList<String> additionalResourcesToAnalyze = new ArrayList<String>();
        HashSet<String> abandonedChildResources = new HashSet<String>();
        for (String kubernetesResourceToAnalyze : kubernetesResourcesToAnalyze) {
            abandonedChildResources.addAll(this.getAbandonedChildResources(kubernetesResourceToAnalyze, rootKustomizationsWithAffectedFiles));
        }
        for (String abandonedChildResource : abandonedChildResources) {
            String additionalResourceToAnalyze = KubeScoreFindingsSynchronizer.getKubernetesResourceToAnalyze(staticManifests, rootHelmCharts, rootKustomizationsWithAffectedFiles, abandonedChildResource);
            if (additionalResourceToAnalyze == null) continue;
            additionalResourcesToAnalyze.add(additionalResourceToAnalyze);
        }
        return additionalResourcesToAnalyze;
    }

    private Set<String> getAbandonedChildResources(String kubernetesResourceToAnalyze, Map<String, Set<String>> rootKustomizationsWithAffectedFiles) throws StorageException {
        List<String> previousKustomizationChildren = this.dependencyListIndex.getDependencies(kubernetesResourceToAnalyze);
        if (previousKustomizationChildren == null || previousKustomizationChildren.isEmpty()) {
            return Collections.emptySet();
        }
        Map<String, String> originPathToNewPath = this.getOriginPathToNewPaths(this.contentDelta.getAddedOrChangedKeysAsStrings());
        List<String> previousKustomizationChildrenNewPaths = KubeScoreFindingsSynchronizer.mapPreviousKustomizationChildrenToNewPaths(previousKustomizationChildren, originPathToNewPath);
        Set<String> affectedFiles = rootKustomizationsWithAffectedFiles.get(kubernetesResourceToAnalyze);
        HashSet abandonedChildResources = CollectionUtils.differenceSet(previousKustomizationChildrenNewPaths, (Collection[])new Collection[]{affectedFiles});
        this.contentDelta.getDeletedKeysAsStrings().forEach(abandonedChildResources::remove);
        return abandonedChildResources;
    }

    private @NonNull Map<String, String> getOriginPathToNewPaths(List<String> newPaths) throws StorageException {
        HashMap<String, String> originPathToNewPath = new HashMap<String, String>();
        for (String newPath : newPaths) {
            ElementHistoryEntry historyEntry = this.elementHistoryIndex.getHistoryEntry(newPath);
            if (historyEntry == null) {
                LOGGER.warn("Could not find history entry for {}", (Object)newPath);
                continue;
            }
            if (historyEntry.getChangeType() != EElementHistoryChangeType.MOVE) continue;
            String originPath = historyEntry.getOriginPath();
            originPathToNewPath.put(originPath, newPath);
        }
        return originPathToNewPath;
    }

    private static @NonNull List<String> mapPreviousKustomizationChildrenToNewPaths(List<String> previousKustomizationChildren, Map<String, String> originPathToNewPath) {
        ArrayList<String> previousKustomizationChildrenNewPaths = new ArrayList<String>();
        for (String previousKustomizationChild : previousKustomizationChildren) {
            String newPath = originPathToNewPath.get(previousKustomizationChild);
            if (newPath == null) {
                previousKustomizationChildrenNewPaths.add(previousKustomizationChild);
                continue;
            }
            previousKustomizationChildrenNewPaths.add(newPath);
        }
        return previousKustomizationChildrenNewPaths;
    }

    private void analyzeKubernetesResource(String kubernetesResourcePath, Map<String, Set<String>> rootKustomizationsWithAffectedFiles, Pattern helmValueFilesRegexPattern) throws ConQATException {
        if (KubernetesUtils.isHelmChart(kubernetesResourcePath)) {
            HelmChartBuilder builder = new HelmChartBuilder(this.contentIndex, this.getContentIndexCache(), this.getSchedulingCommit(), kubernetesResourcePath, this.helmValueFolder, helmValueFilesRegexPattern);
            this.buildAndAnalyzeKubernetesManifest(kubernetesResourcePath, builder);
        } else if (KubernetesUtils.isKustomization(kubernetesResourcePath)) {
            KustomizationBuilder builder = new KustomizationBuilder(this.contentIndex, this.getSchedulingCommit(), kubernetesResourcePath, rootKustomizationsWithAffectedFiles.get(kubernetesResourcePath));
            this.buildAndAnalyzeKubernetesManifest(kubernetesResourcePath, builder);
        } else {
            String fileContent = KubernetesUtils.getContentForUniformPath(kubernetesResourcePath, this.getContentIndexCache());
            this.analyzeManifest(kubernetesResourcePath, fileContent);
        }
    }

    private void buildAndAnalyzeKubernetesManifest(String kubernetesResourcePath, KubernetesManifestBuilder builder) throws ConQATException {
        String manifestContent = builder.build();
        this.parseLogEntries.addAll(builder.getParseLogEntries());
        this.storeFullManifest(kubernetesResourcePath, manifestContent);
        this.analyzeManifest(kubernetesResourcePath, manifestContent);
    }

    private void cleanup(List<String> allKubernetesKeys, Set<String> rootHelmCharts, Set<String> rootKustomizations, Set<String> staticManifests) throws StorageException {
        HashSet rootFiles = CollectionUtils.unionSet(rootKustomizations, (Collection[])new Collection[]{rootHelmCharts, staticManifests});
        HashSet nonRootFiles = CollectionUtils.differenceSet(allKubernetesKeys, (Collection[])new Collection[]{rootFiles});
        this.findingsIndex.removeFindingsForPartitionsAndPaths("kubescore-internal", new ArrayList(nonRootFiles));
        List deletedKeysAsStrings = this.contentDelta.getDeletedKeysAsStrings();
        this.kubernetesManifestIndex.removeKubernetesManifests(deletedKeysAsStrings);
        List<String> childKustomizations = nonRootFiles.stream().filter(key -> key.endsWith("kustomization.yaml")).toList();
        this.kubernetesManifestIndex.removeKubernetesManifests(childKustomizations);
        this.dependencyListIndex.removeDependencies(childKustomizations);
    }

    @Override
    protected Optional<BasicTokenElementInfo> overrideBasicTokenElementInfoForOffsetAndDeletions(String uniformPath) throws StorageException {
        if (!uniformPath.endsWith("kustomization.yaml") && !uniformPath.endsWith("Chart.yaml")) {
            return Optional.empty();
        }
        TokenElementInfo elementInfoKubernetes = this.kubernetesManifestIndex.getKubernetesManifest(uniformPath);
        if (elementInfoKubernetes == null) {
            LOGGER.error("Did not find kubernetes manifest for {}", (Object)uniformPath);
            return Optional.empty();
        }
        return Optional.of(elementInfoKubernetes);
    }

    private @NonNull List<String> getKubernetesKeys(List<String> keys) throws StorageException {
        List<TokenElementInfo> tokenElements = this.contentIndex.getTokenElements(keys);
        ArrayList<String> kubernetesKeys = new ArrayList<String>();
        for (int i = 0; i < keys.size(); ++i) {
            if (!KubeScoreFindingsSynchronizer.isKubernetesContent(keys.get(i), tokenElements.get(i))) continue;
            kubernetesKeys.add(keys.get(i));
        }
        return kubernetesKeys;
    }

    private static boolean isKubernetesContent(String uniformPath, TokenElementInfo tokenElement) {
        return KubeScoreFindingsSynchronizer.hasKubernetesFileExtension(uniformPath) && KubernetesLanguageDetector.isLikelyKubernetesContent((String)tokenElement.getText());
    }

    private static boolean hasKubernetesFileExtension(String uniformPath) {
        return Arrays.stream(ELanguage.KUBERNETES.getFileExtensions()).anyMatch(extension -> extension.equals(UniformPathUtils.getExtension((String)uniformPath)));
    }

    private void analyzeManifest(String uniformPath, String manifestContent) {
        if (manifestContent.isEmpty()) {
            this.skippedKubernetesResources.add(uniformPath);
            return;
        }
        this.executeKubernetesChecks(new KubernetesTeamscaleChecksRunner(), manifestContent, uniformPath);
        this.executeKubernetesChecks(new KubernetesKubeScoreChecksRunner(this.disableCpuLimitCheck), manifestContent, uniformPath);
    }

    private void executeKubernetesChecks(KubernetesChecksRunner runner, String fileContent, String uniformPath) {
        List<IndexFinding> findings = runner.run(fileContent, uniformPath);
        this.globalFindingsByUniformPath.addAll((Object)uniformPath, findings);
    }

    private void storeFullManifest(String uniformPath, String manifestContent) throws StorageException {
        if (manifestContent.isEmpty()) {
            manifestContent = MANIFEST_ERROR_CONTENT;
        }
        List tokens = ScannerUtils.getTokens((String)manifestContent, (ELanguage)ELanguage.KUBERNETES, (String)uniformPath);
        try {
            List shallowEntities = ShallowParserFactory.createParser((ELanguage)ELanguage.LINE).parseTopLevel(tokens);
            TokenElementInfo tokenElementInfo = new TokenElementInfo(uniformPath, ELanguage.KUBERNETES, false, manifestContent, (List<Deletion>)CollectionUtils.emptyList(), (Collection<TokenElementDetailBase>)CollectionUtils.emptyList(), tokens, shallowEntities);
            this.kubernetesManifestIndex.setKubernetesManifest(uniformPath, tokenElementInfo);
        }
        catch (ShallowParserException e) {
            LOGGER.error("Could not parse manifest in {}", (Object)uniformPath, (Object)e);
        }
    }
}

