/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.phpstan;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.findings.FindingReportAnalyzerBase;
import com.teamscale.index.findings.phpstan.PHPStanReport;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;

public class PHPStanReportReader
extends FindingReportAnalyzerBase {
    static final String FINDINGS_ID_PREFIX = "phpstan.";

    public PHPStanReportReader(IMatchingPathsLookup matchingPathsLookup) {
        super(matchingPathsLookup);
    }

    ListMap<String, IndexFinding> parseReport(PHPStanReport analysisResult) {
        ListMap findings = new ListMap();
        for (Map.Entry entry : analysisResult.fileErrors().entrySet()) {
            Optional<String> uniformPath;
            PHPStanReport.FileErrors result = (PHPStanReport.FileErrors)entry.getValue();
            if (result.errorCount() == 0 || (uniformPath = this.matchingPathsLookup.lookupBestPath(PHPStanReportReader.sanitizePath((Path)entry.getKey()), PathLookupOptions.defaults())).isEmpty()) continue;
            for (PHPStanReport.FileErrors.FileError error : result.errors()) {
                IndexFinding finding = PHPStanReportReader.createFinding(error, uniformPath.get());
                findings.add((Object)uniformPath.get(), (Object)finding);
            }
        }
        return findings;
    }

    private static IndexFinding createFinding(PHPStanReport.FileErrors.FileError error, String uniformPath) {
        IndexFinding finding = new IndexFinding(FINDINGS_ID_PREFIX + error.identifier(), "PHPStan", error.message(), (ElementLocation)new TextRegionLocation(uniformPath, -1, -1, error.line(), error.line()));
        IndexFindingUtils.setGuidelineMapping((IndexFinding)finding, (String)error.identifier(), (Set)EAnalysisTool.PHPSTAN.getSupportedLanguages());
        error.getTip().ifPresent(tip -> finding.setProperty("Tip", tip));
        return finding;
    }

    private static String sanitizePath(Path path) {
        return StringUtils.removeEverythingAfter((String)path.toString(), (String)".php");
    }
}

