/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.powershellscriptanalyzer;

import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.CodeScopeAwareObjectBuilder;
import com.teamscale.index.configuration.tools.PowerShellScriptAnalyzerConfiguration;
import com.teamscale.index.findings.FindingsSynchronizingAnalyzingStepBase;
import com.teamscale.index.findings.powershellscriptanalyzer.PowerShellScriptAnalyzerRunner;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.filesystem.TemporaryDirectory;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class PowerShellScriptAnalyzerSynchronizer
extends FindingsSynchronizingAnalyzingStepBase {
    public static final String CHECKS_PARAMETER = "checks";
    public static final String CHECK_OPTIONS_PARAMETER = "check-options";
    @VisibleForTesting
    public static final String FINDING_PARTITION = "PowerShellScriptAnalyzer";
    @StepParameter(value="check-options")
    private final CodeScopeAware<PairList<String, String>> checkOptions = CodeScopeAware.defaultCodeScopeWithValue((Object)new PairList());
    @StepParameter(value="checks")
    private final CodeScopeAware<List<String>> selectedChecks = CodeScopeAware.defaultCodeScopeWithValue(new ArrayList());
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws StorageException {
        try (TemporaryDirectory tmpDir = PowerShellScriptAnalyzerSynchronizer.getTempDirectory((String)"TeamscalePowerShellScriptAnalyzer");){
            List addedOrChangedKeys = this.contentDelta.getAddedOrChangedKeysAsStrings();
            List filesToAnalyze = this.getContentIndexCache().getValues(addedOrChangedKeys);
            filesToAnalyze = CollectionUtils.filter(filesToAnalyze, element -> element.getLanguage() == ELanguage.POWERSHELL);
            PowerShellScriptAnalyzerRunner runner = new PowerShellScriptAnalyzerRunner(this.getContentIndexCache(), this.getSchedulingCommit(), (CodeScopeAware<Map<String, String>>)this.checkOptions.map(PairList::toMap));
            ListMap<String, IndexFinding> findings = runner.prepareAndRunPowerShellScriptAnalyzer(filesToAnalyze, tmpDir.getPath().toFile(), this.selectedChecks, false);
            CodeScopeAwareObjectBuilder builder = new CodeScopeAwareObjectBuilder((Object)new ListMap());
            for (TokenElementInfo file : filesToAnalyze) {
                CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(file);
                ((ListMap)builder.computeIfAbsent(codeScopeName, ListMap::new)).addAll((Object)file.getUniformPath(), findings.getCollectionOrElse((Object)file.getUniformPath(), List.of()));
            }
            this.synchronizeFindingsForTokenElementIndexDelta((CodeScopeAware<ListMap<String, IndexFinding>>)builder.build(), FINDING_PARTITION);
        }
        catch (IOException | ConQATException e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private static PowerShellResponse getVersionFromGetInstalledModuleCommand(String expectedVersion) throws ConQATException {
        PowerShellScriptAnalyzerRunner.ProcessResult result = PowerShellScriptAnalyzerRunner.getNonAnalysisCommandLineOutput("-NonInteractive", "-Command", "Import-Module PSScriptAnalyzer;\nGet-InstalledModule -Name 'PSScriptAnalyzer' |\n\tConvertTo-Json -EnumsAsStrings -depth 100");
        if (result.returnCode() != 0 || !result.stdOut().trim().startsWith("{")) {
            return new PowerShellResponse("", "Could not retrieve version of PowerShell Script Analyzer using PowerShell 'Get-InstalledModule' command.\nNo PowerShell executable found, PowerShellScriptAnalyzer not installed, or wrong version of PowerShellScriptAnalyzer.\nRequired version: %s\nReturn Code: %d\nOutput: %s\nError: %s\n".formatted(expectedVersion, result.returnCode(), result.stdOut(), result.stdErr()));
        }
        Map output = (Map)JsonUtils.deserializeFromJson((String)result.stdOut(), Map.class);
        return new PowerShellResponse((String)output.get("Version"), null);
    }

    @VisibleForTesting
    public static String readVersionOfPowerShellScriptAnalyzerFromOutput(String output) {
        List outputLines = StringUtils.splitLinesAsList((String)output.strip());
        String actualVersion = "";
        for (String line : outputLines) {
            if (!line.contains("PSScriptAnalyzer")) continue;
            actualVersion = StringUtils.getLastPart((String)line, (String)" ").trim();
        }
        return actualVersion;
    }

    private static PowerShellResponse getVersionFromGetModuleCommand(String expectedVersion) {
        PowerShellScriptAnalyzerRunner.ProcessResult result = PowerShellScriptAnalyzerRunner.getNonAnalysisCommandLineOutput("-NonInteractive", "-Command", "Get-Module PSScriptAnalyzer -ListAvailable | Format-Table -Property Name,Version");
        if (result.returnCode() != 0) {
            return new PowerShellResponse("", "Could not retrieve version of PowerShell Script Analyzer using PowerShell 'Get-Module' command.\nNo PowerShell executable found, PowerShellScriptAnalyzer not installed, or wrong version of PowerShellScriptAnalyzer.\nRequired version: %s\nReturn Code: %d\nOutput: %s\nError: %s\n".formatted(expectedVersion, result.returnCode(), result.stdOut(), result.stdErr()));
        }
        return new PowerShellResponse(PowerShellScriptAnalyzerSynchronizer.readVersionOfPowerShellScriptAnalyzerFromOutput(result.stdOut()), null);
    }

    public static void verifyPowerShellScriptAnalyzerVersion() throws ConQATException {
        String actualVersion;
        String expectedVersion = PowerShellScriptAnalyzerSynchronizer.loadExpectedPowerShellScriptAnalyzerVersion();
        String errorFromFirstResponse = "";
        String errorFromSecondResponse = "";
        PowerShellResponse powerShellResponse = PowerShellScriptAnalyzerSynchronizer.getVersionFromGetInstalledModuleCommand(expectedVersion);
        if (powerShellResponse.version.trim().isEmpty()) {
            errorFromFirstResponse = powerShellResponse.error;
            powerShellResponse = PowerShellScriptAnalyzerSynchronizer.getVersionFromGetModuleCommand(expectedVersion);
            errorFromSecondResponse = powerShellResponse.error;
        }
        if ((actualVersion = powerShellResponse.version).trim().isEmpty()) {
            throw new ConQATException("Could not parse version of PowerShellScriptAnalyzer from PowerShellScriptAnalyzer output\nusing the PowerShell 'Get-InstalledModule' and 'Get-Module' commands.\n\nError from 'Get-InstalledModule' command:\n%s\n\nError from 'Get-Module' command:\n%s\n".formatted(errorFromFirstResponse, errorFromSecondResponse));
        }
        if (!actualVersion.contains(expectedVersion)) {
            throw new ConQATException("Found wrong version of PowerShellScriptAnalyzer. Required version " + expectedVersion + " Actual Version: " + actualVersion);
        }
    }

    public static String loadExpectedPowerShellScriptAnalyzerVersion() {
        String content = Resource.of(PowerShellScriptAnalyzerConfiguration.class, (String)"powershellscriptanalyzer/version.txt").getContent();
        Object expectedVersion = "";
        for (String line : StringUtils.splitLines((String)content)) {
            if (line.isEmpty() || line.startsWith("//")) continue;
            if (!((String)expectedVersion).isEmpty()) {
                expectedVersion = (String)expectedVersion + "\n";
            }
            expectedVersion = (String)expectedVersion + line.trim();
        }
        return expectedVersion;
    }

    private record PowerShellResponse(String version, String error) {
    }
}

