/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.semgrep;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.findings.IndexFindingUtils;
import com.teamscale.index.findings.semgrep.SemgrepWslUtils;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class SemgrepOutputParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, LineOffsetConverter> uniformPathToLineOffsetConverter = new HashMap<String, LineOffsetConverter>();
    private final Map<String, TokenElementInfo> uniformPathToElement;
    private final Set<String> checkIdsWithDot;

    public SemgrepOutputParser(Map<String, TokenElementInfo> uniformPathToElement, Set<String> checkIdsWithDot) {
        this.uniformPathToElement = uniformPathToElement;
        this.checkIdsWithDot = checkIdsWithDot;
    }

    public ListMap<String, IndexFinding> parseOutput(String semgrepOutput, File ruleSetSourceFilesDir) {
        ListMap findings = new ListMap();
        try {
            SemgrepResult semgrepResult = (SemgrepResult)JsonUtils.deserializeFromJson((String)semgrepOutput, SemgrepResult.class);
            for (SemgrepFinding semgrepFinding : semgrepResult.findings) {
                String uniformPath = SemgrepOutputParser.convertToUniformPath(semgrepFinding.path, ruleSetSourceFilesDir);
                IndexFinding indexFinding = this.createIndexFinding(uniformPath, semgrepFinding);
                findings.add((Object)uniformPath, (Object)indexFinding);
            }
        }
        catch (JsonSerializationException e) {
            LOGGER.error("Error parsing Semgprep output: " + e.getMessage(), (Throwable)e);
        }
        return findings;
    }

    private static String convertToUniformPath(String path, File baseDir) {
        String basePath = baseDir.getAbsolutePath();
        if (SemgrepWslUtils.isWindows()) {
            basePath = FileSystemUtils.normalizeSeparators((String)basePath);
            path = SemgrepWslUtils.convertWslToUniformPath(path);
        }
        String relativePath = StringUtils.stripPrefix((String)path, (String)basePath);
        return StringUtils.stripPrefix((String)relativePath, (String)"/");
    }

    private IndexFinding createIndexFinding(String uniformPath, SemgrepFinding semgrepFinding) {
        String checkId = this.extractFindingId(semgrepFinding);
        int startLine = semgrepFinding.start.line;
        int endLine = semgrepFinding.end.line;
        String message = semgrepFinding.extraData.metadata.shortDescription;
        TokenElementInfo tokenElement = this.uniformPathToElement.get(uniformPath);
        CCSMAssert.isNotNull((Object)((Object)tokenElement));
        LineOffsetConverter converter = this.uniformPathToLineOffsetConverter.computeIfAbsent(uniformPath, path -> new LineOffsetConverter(tokenElement.getText()));
        int rawStartOffset = converter.getOffset(startLine);
        int rawEndOffset = converter.getOffset(endLine + 1) - 1;
        TextRegionLocation textRegionLocation = new TextRegionLocation(uniformPath, rawStartOffset, rawEndOffset, startLine, endLine);
        IndexFinding indexFinding = new IndexFinding(checkId, "semgrep", message, (ElementLocation)textRegionLocation);
        IndexFindingUtils.setGuidelineMapping((IndexFinding)indexFinding, (String)checkId, (ELanguage)tokenElement.getLanguage());
        return indexFinding;
    }

    private String extractFindingId(SemgrepFinding semgrepFinding) {
        Optional<String> checkIdWithDot = this.checkIdsWithDot.stream().filter(c -> semgrepFinding.checkId.endsWith((String)c)).findFirst();
        return checkIdWithDot.orElseGet(() -> StringUtils.getLastPart((String)semgrepFinding.checkId, (String)"."));
    }

    private static class SemgrepResult {
        @JsonProperty(value="results")
        private List<SemgrepFinding> findings;

        private SemgrepResult() {
        }
    }

    private static class SemgrepFinding {
        @JsonProperty(value="check_id")
        private String checkId;
        @JsonProperty(value="start")
        private SemgrepCodePosition start;
        @JsonProperty(value="end")
        private SemgrepCodePosition end;
        @JsonProperty(value="extra")
        private SemgrepExtraData extraData;
        @JsonProperty(value="path")
        private String path;

        private SemgrepFinding() {
        }
    }

    private static class SemgrepCodePosition {
        @JsonProperty(value="line")
        private int line;

        private SemgrepCodePosition() {
        }
    }

    private static class SemgrepExtraData {
        @JsonProperty(value="metadata")
        private SemgrepMetaData metadata;

        private SemgrepExtraData() {
        }
    }

    private static class SemgrepMetaData {
        @JsonProperty(value="shortDescription")
        private String shortDescription;

        private SemgrepMetaData() {
        }
    }
}

