/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.ZipToGitImporter;
import com.teamscale.index.gitbridge.abap.ObjectMetaData;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.index.metadata.abap.ReleaseContract;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class AbapFileMetadataManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ZipToGitImporter zipToGitImporter;
    private final PairList<String, AbapFileMetadata> metadataForAddedAndModifiedFiles;

    public AbapFileMetadataManager(ZipToGitImporter zipToGitImporter) {
        this.zipToGitImporter = zipToGitImporter;
        this.metadataForAddedAndModifiedFiles = new PairList();
    }

    public static String deriveMetadataFileNameForFile(String file) {
        if (file.endsWith(".abap_ddic") || file.endsWith(".abap_cds") || file.endsWith(".abap")) {
            return file + ".metadata";
        }
        return null;
    }

    public void updateMetadataFilesInGitRepo(ZipToGitImporter.IntroducedGitChanges gitChanges, ObjectMetaData objectMetaData) throws GitBridgeException {
        if (gitChanges.hasMoves()) {
            gitChanges.movedFiles().forEach(this::moveMetadataFileInGit);
        }
        if (gitChanges.hasDeletions()) {
            ArrayList<String> metadataFilesToDelete = new ArrayList<String>();
            for (String file : gitChanges.deletedFiles()) {
                String metadataFile;
                if (!AbapFileMetadataManager.hasMetadataRelevance(file) || (metadataFile = AbapFileMetadataManager.deriveMetadataFileNameForFile(file)) == null) continue;
                metadataFilesToDelete.add(metadataFile);
            }
            this.zipToGitImporter.delete(metadataFilesToDelete, true);
        }
        if (gitChanges.hasAdditionsAndModifications()) {
            this.createAndAddMetadataFilesToGit(gitChanges.addedAndChangedFiles(), objectMetaData);
        }
    }

    private void moveMetadataFileInGit(String oldFile, String newFile) {
        String sourceMetadataFileName = AbapFileMetadataManager.deriveMetadataFileNameForFile(oldFile);
        String destinationMetadataFileName = AbapFileMetadataManager.deriveMetadataFileNameForFile(newFile);
        if (sourceMetadataFileName == null || destinationMetadataFileName == null) {
            return;
        }
        try {
            this.zipToGitImporter.move(sourceMetadataFileName, destinationMetadataFileName, true);
        }
        catch (GitBridgeException e) {
            LOGGER.warn("File " + oldFile + " has moved to " + newFile + " but could not move metadata file " + sourceMetadataFileName + " to new one " + destinationMetadataFileName + ". " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean hasMetadataRelevance(String file) {
        return file.endsWith(".abap") || file.endsWith(".abap_ddic") || file.endsWith(".abap_cds");
    }

    public void createAndAddMetadataFilesToGit(List<String> addedAndModifiedFiles, ObjectMetaData objectMetaData) throws GitBridgeException {
        if (objectMetaData == null) {
            return;
        }
        ArrayList<String> createdFiles = new ArrayList<String>();
        for (String path : addedAndModifiedFiles) {
            String metadataFile;
            AbapFileMetadata abapFileMetadata;
            if (!AbapFileMetadataManager.hasMetadataRelevance(path) || (abapFileMetadata = objectMetaData.getMetadataForObject("sources/" + path)) == null || (metadataFile = this.createNewMetadataFile(abapFileMetadata, path)) == null) continue;
            this.metadataForAddedAndModifiedFiles.add(Pair.createPair((Object)path, (Object)abapFileMetadata));
            createdFiles.add(metadataFile);
        }
        this.zipToGitImporter.add(createdFiles);
    }

    private String createNewMetadataFile(AbapFileMetadata metadata, String filePath) {
        try {
            String stringBuilder = "creationDate:" + metadata.getCreationDate() + "\nlastUpdateDateTime:" + metadata.getLastUpdateDateTime() + "\n";
            if (metadata.getOriginatingSystem() != null) {
                stringBuilder = stringBuilder + "originatingSystem:" + metadata.getOriginatingSystem() + "\n";
            }
            if (metadata.getProgramType() != null) {
                stringBuilder = stringBuilder + "programType:" + String.valueOf(metadata.getProgramType()) + "\n";
            }
            if (metadata.getLanguageVersion() != null) {
                stringBuilder = stringBuilder + "languageVersion:" + String.valueOf(metadata.getLanguageVersion()) + "\n";
            }
            if (metadata.getAuthorizationGroup() != null) {
                stringBuilder = stringBuilder + "authorizationGroup:" + metadata.getAuthorizationGroup() + "\n";
            }
            if (metadata.getReleaseContract() != null) {
                stringBuilder = stringBuilder + AbapFileMetadataManager.buildValuesFromReleaseContract(metadata.getReleaseContract());
            }
            stringBuilder = stringBuilder + "isRfcEnabled:" + metadata.isRfcEnabled() + "\nisGeneratedCode:" + metadata.isCodeGenerated();
            String metadataFile = AbapFileMetadataManager.deriveMetadataFileNameForFile(filePath);
            if (metadataFile != null) {
                File file = new File(this.zipToGitImporter.getWorkTree(), metadataFile);
                Files.writeString(file.toPath(), (CharSequence)stringBuilder, new OpenOption[0]);
                return metadataFile;
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not create metadata file for " + filePath + ". " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static String buildValuesFromReleaseContract(ReleaseContract releaseContract) {
        Object result = "";
        if (releaseContract.getCompatibilityContract() != null) {
            result = (String)result + "compatibilityContract:" + releaseContract.getCompatibilityContract().getId() + "\n";
        }
        if (releaseContract.getSubObjectName() != null) {
            result = (String)result + "subObjectName:" + releaseContract.getSubObjectName() + "\n";
        }
        if (releaseContract.getSubObjectType() != null) {
            result = (String)result + "subObjectType:" + releaseContract.getSubObjectType() + "\n";
        }
        if (releaseContract.getReleaseState() != null) {
            result = (String)result + "releaseState:" + String.valueOf(releaseContract.getReleaseState()) + "\n";
        }
        result = (String)result + "useInKeyUserApps:" + releaseContract.isUseInKeyUserApps() + "\n";
        return (String)result + "useInSapCloudPlatform:" + releaseContract.isUseInSapCloudPlatform() + "\n";
    }
}

