/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap;

import com.teamscale.index.gitbridge.GitBridgeException;
import com.teamscale.index.gitbridge.abap.AbapExportXmlTableReaderBase;
import com.teamscale.index.gitbridge.abap.AbapGitImporterUtils;
import com.teamscale.index.gitbridge.abap.EExportMetaData;
import java.io.File;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.conqat.lib.commons.filesystem.ZipFile;

public class ExportMetaData {
    private Optional<String> sapSystemId;
    private ZoneOffset timeZone = ZonedDateTime.now().getOffset();
    private boolean isFullExport = false;
    private Instant toTime = null;
    private Instant exportFinishedTime = null;
    private boolean containsObjectPaths = false;

    public ExportMetaData(ZipFile zipFile, File file) throws GitBridgeException {
        if (zipFile.getEntry("export_meta_data.xml") != null) {
            new ExportMetaDataReader().readRecords(AbapGitImporterUtils.readXmlContent(zipFile, "export_meta_data.xml"));
        } else {
            this.isFullExport = true;
            this.exportFinishedTime = this.toTime = AbapGitImporterUtils.getZipFileDate(file);
            this.sapSystemId = AbapGitImporterUtils.getZipFileSystemId(file);
        }
    }

    public Optional<String> getSapSystemId() {
        return this.sapSystemId;
    }

    public ZoneOffset getTimeZone() {
        return this.timeZone;
    }

    public boolean isFullExport() {
        return this.isFullExport;
    }

    public Instant getToTime() {
        return this.toTime;
    }

    public Instant getExportFinishedTime() {
        return this.exportFinishedTime;
    }

    public boolean containsObjectPaths() {
        return this.containsObjectPaths;
    }

    private class ExportMetaDataReader
    extends AbapExportXmlTableReaderBase<EExportMetaData> {
        public ExportMetaDataReader() {
            super(EExportMetaData.class);
        }

        @Override
        protected EExportMetaData getRecordElement() {
            return EExportMetaData.item;
        }

        @Override
        protected void processRecord() throws GitBridgeException {
            if (ExportMetaData.this.toTime != null) {
                throw new GitBridgeException("Multiple entries found in 'export_meta_data.xml' only first entry is used.");
            }
            ExportMetaData.this.sapSystemId = Optional.ofNullable(this.getChildText(EExportMetaData.SYSID));
            ExportMetaData.this.timeZone = AbapGitImporterUtils.buildTimeZone(this.getChildText(EExportMetaData.TIMEZONE));
            ExportMetaData.this.isFullExport = this.readBoolean(EExportMetaData.IS_FULL_EXPORT, true);
            ExportMetaData.this.toTime = this.readDateAndTime(EExportMetaData.TO_DATE, EExportMetaData.TO_TIME, ExportMetaData.this.timeZone);
            ExportMetaData.this.exportFinishedTime = this.readDateAndTime(EExportMetaData.FINISHED_DATE, EExportMetaData.FINISHED_TIME, ExportMetaData.this.timeZone);
            ExportMetaData.this.containsObjectPaths = this.readBoolean(EExportMetaData.INCLUDE_ALL_PATHS, false);
        }
    }
}

