/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.cleanup;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.issues.cleanup.IWorkItemCleanupStrategy;
import com.teamscale.index.issues.cleanup.OnceEveryDayCleanupStrategy;
import com.teamscale.index.issues.cleanup.WorkItemCleanupIndex;
import java.time.Instant;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.VisibleForTesting;

public class OnceEveryNthPollCleanupStrategy
implements IWorkItemCleanupStrategy {
    public static final String CLEANUP_EVERY_NTH_POLL_PARAMETER_NAME = "cleanupEveryNthPoll";
    private static final String CLEANUP_INDEX_KEY = OnceEveryDayCleanupStrategy.class.getSimpleName() + "-calls-without-cleanup";
    @StepParameter(value="cleanupEveryNthPoll", optional=true)
    private int cleanupEveryNthPoll = 0;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="work-item-cleanup-index")
    private WorkItemCleanupIndex index;

    public OnceEveryNthPollCleanupStrategy() {
    }

    @VisibleForTesting
    OnceEveryNthPollCleanupStrategy(int cleanupEveryNthPoll, WorkItemCleanupIndex index) {
        this.cleanupEveryNthPoll = cleanupEveryNthPoll;
        this.index = index;
    }

    @Override
    public boolean shouldPerformCleanup(Instant timestamp) throws StorageException {
        if (this.cleanupEveryNthPoll <= 0) {
            return false;
        }
        if (this.cleanupEveryNthPoll == 1) {
            return true;
        }
        int callsWithoutCleanup = this.index.getValue(CLEANUP_INDEX_KEY, Integer.class).orElse(0) + 1;
        if (callsWithoutCleanup >= this.cleanupEveryNthPoll) {
            return true;
        }
        this.index.setValue(CLEANUP_INDEX_KEY, Integer.valueOf(callsWithoutCleanup));
        return false;
    }

    @Override
    public void cleanupPerformed(Instant timestamp) throws StorageException {
        this.index.setValue(CLEANUP_INDEX_KEY, Integer.valueOf(0));
    }
}

