/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.voting;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.model.option.AccountCredentials;
import com.teamscale.core.analysis.configuration.model.option.JiraIssueUpdateConfiguration;
import com.teamscale.core.log.interaction.InteractionLogMessage;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.jira.JiraBugTrackerConnectorDescriptor;
import com.teamscale.index.issues.jira.client.JiraClient;
import com.teamscale.index.issues.jira.voting.JiraIssueUpdatePayloadBuilder;
import com.teamscale.index.issues.jira.voting.TeamscaleJiraMessageRow;
import com.teamscale.index.merge_request.MergeRequestUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.http.message.BasicNameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

final class JiraIssueUpdater {
    private final Set<String> destinations;
    private final JiraClient jiraClient;
    private final Map<String, List<String>> customFieldNameToIdMapping;
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, Boolean> jiraUserHasProjectAdminPermissionsByProjectCache = new HashMap<String, Boolean>();

    private JiraIssueUpdater(Set<String> destinations, ExternalCredentials externalCredentials, List<String> cookies) throws BugTrackerException, ServiceCallException {
        this.destinations = destinations;
        this.jiraClient = new JiraClient(externalCredentials.uri, externalCredentials.username, externalCredentials.password, cookies);
        try {
            this.customFieldNameToIdMapping = this.jiraClient.fetchAndValidateCustomFieldMapping(this.destinations);
        }
        catch (BugTrackerException e) {
            throw new BugTrackerException("Failed to create custom field mapping.", e);
        }
    }

    public JiraIssueUpdater(JiraBugTrackerConnectorDescriptor connectorDescriptor, ExternalCredentialsIndex index) throws StorageException, BugTrackerException, ServiceCallException {
        this(JiraIssueUpdater.getDestinationsFromConnector(connectorDescriptor), JiraIssueUpdater.getExternalCredentialsFromConnector(connectorDescriptor, index), JiraIssueUpdater.getCookiesFromConnector(connectorDescriptor));
    }

    @VisibleForTesting
    JiraIssueUpdater(Set<String> destinations, ExternalCredentials credentials) throws BugTrackerException, ServiceCallException {
        this(destinations, credentials, Collections.emptyList());
    }

    public void updateIssue(String issueId, TeamscaleJiraMessageRow message) throws BugTrackerException, ServiceCallException {
        Optional<String> finalDataToSend = this.buildRequestBody(issueId, message);
        if (finalDataToSend.isEmpty()) {
            LOGGER.info(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage("Issue %s was not updated as table content did not change (%s).".formatted(issueId, this.getClass().getName()), this.getJiraServerBaseUrl(), issueId));
            return;
        }
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        String jiraProjectKey = StringUtils.getFirstPart((String)issueId, (String)"-");
        if (!this.jiraUserHasProjectAdminPermissionsByProjectCache.containsKey(jiraProjectKey)) {
            this.jiraUserHasProjectAdminPermissionsByProjectCache.put(jiraProjectKey, this.jiraClient.hasProjectAdminPermission(jiraProjectKey));
        }
        if (this.jiraUserHasProjectAdminPermissionsByProjectCache.get(jiraProjectKey).booleanValue()) {
            parameters.add(new BasicNameValuePair("notifyUsers", "false"));
        }
        MergeRequestUtils.performServiceCallWithLogging("push new information on issue " + issueId + ": " + message.toJiraMessage(false), this.getJiraServerBaseUrl(), issueId, (RunnableWithException<Exception>)((RunnableWithException)() -> this.jiraClient.putIssue(issueId, (String)finalDataToSend.get(), parameters)));
    }

    @VisibleForTesting
    Optional<String> buildRequestBody(String issueId, TeamscaleJiraMessageRow message) throws BugTrackerException {
        String fullIssueContent = this.fetchIssueContent(issueId);
        JiraIssueUpdatePayloadBuilder payloadBuilder = new JiraIssueUpdatePayloadBuilder();
        JsonNode fields = JiraIssueUpdater.tryToGetJSONAttribute(fullIssueContent, "fields", issueId);
        for (String destination : this.destinations) {
            payloadBuilder = this.addDestination(issueId, payloadBuilder, message, destination, fields);
        }
        if (!JiraIssueUpdater.anyFieldHasChanged(payloadBuilder.getIssueFields(), fields)) {
            return Optional.empty();
        }
        return Optional.of(payloadBuilder.build());
    }

    private JiraIssueUpdatePayloadBuilder addDestination(String issueId, JiraIssueUpdatePayloadBuilder payloadBuilder, TeamscaleJiraMessageRow message, String destination, JsonNode fields) {
        TeamscaleJiraMessageRow fieldMessage = message.copy();
        if (destination.equals("description")) {
            this.buildFieldContent(issueId, fieldMessage, destination, fields, false).ifPresent(payloadBuilder::withIssueDescription);
        } else {
            List<String> customFieldIds = this.customFieldNameToIdMapping.get(StringUtils.stripPrefix((String)destination, (String)"customfield_"));
            for (String customFieldId : customFieldIds) {
                Optional<String> customFieldData = this.buildFieldContent(issueId, fieldMessage, customFieldId, fields, true);
                if (!customFieldData.isPresent() || customFieldId == null) continue;
                payloadBuilder = payloadBuilder.withCustomField(customFieldId, customFieldData.get());
                break;
            }
        }
        return payloadBuilder;
    }

    private String fetchIssueContent(String issueId) throws BugTrackerException {
        try {
            return this.jiraClient.getIssueAsJson(issueId);
        }
        catch (ServiceCallException e) {
            throw new BugTrackerException("Failed to retrieve issue content.", e);
        }
    }

    private static JsonNode tryToGetJSONAttribute(String issueContentJson, String fieldsKey, String issueId) throws BugTrackerException {
        String errorMessage = "No fields in a Jira issue " + issueId + ", or issue does not exist.";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return Optional.ofNullable(objectMapper.readTree(issueContentJson).get(fieldsKey)).orElseThrow(() -> new BugTrackerException(errorMessage));
        }
        catch (JsonProcessingException ex) {
            throw new BugTrackerException(errorMessage, ex);
        }
    }

    private static boolean anyFieldHasChanged(JsonNode newIssueFields, JsonNode oldIssueFields) {
        Iterator entryIterator = newIssueFields.fields();
        while (entryIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)entryIterator.next();
            if (((JsonNode)entry.getValue()).asText().equals(oldIssueFields.get((String)entry.getKey()).asText())) continue;
            return true;
        }
        return false;
    }

    private Optional<String> buildFieldContent(String issueId, TeamscaleJiraMessageRow message, String destinationField, JsonNode fields, boolean isCustomField) {
        boolean destinationFieldHasNoValue;
        if (!fields.has(destinationField)) {
            LOGGER.info(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage("Issue %s does not contain requested field %s (%s).".formatted(issueId, destinationField, this.getClass().getName()), this.getJiraServerBaseUrl(), issueId));
            return Optional.empty();
        }
        boolean bl = destinationFieldHasNoValue = !fields.hasNonNull(destinationField);
        if (destinationFieldHasNoValue) {
            message.prependStandardHeader();
            return Optional.of(message.toJiraMessage(!isCustomField));
        }
        return Optional.of(JiraIssueUpdater.appendNewContent(message, fields.get(destinationField).asText(), isCustomField));
    }

    private static String appendNewContent(TeamscaleJiraMessageRow newMessage, String destinationFieldOldContent, boolean isCustomField) {
        int teamscaleTableHeaderStartIndex = destinationFieldOldContent.indexOf(TeamscaleJiraMessageRow.JIRA_DATACENTER_TEAMSCALE_HEADER_START_MARKER);
        if (teamscaleTableHeaderStartIndex == -1) {
            teamscaleTableHeaderStartIndex = destinationFieldOldContent.indexOf(TeamscaleJiraMessageRow.JIRA_CLOUD_TEAMSCALE_HEADER_START_MARKER);
        }
        if (teamscaleTableHeaderStartIndex != -1) {
            return JiraIssueUpdater.updateJiraMessageContent(newMessage, destinationFieldOldContent, teamscaleTableHeaderStartIndex);
        }
        newMessage.prependStandardHeader();
        if (StringUtils.isEmpty((String)destinationFieldOldContent)) {
            return destinationFieldOldContent.concat(newMessage.toJiraMessage(!isCustomField));
        }
        return destinationFieldOldContent.concat("\r\n").concat(newMessage.toJiraMessage(!isCustomField));
    }

    private static String updateJiraMessageContent(TeamscaleJiraMessageRow newMessage, String destinationFieldOldContent, int teamscaleTableHeaderStartIndex) {
        String nonTeamscaleRelatedFieldContent = destinationFieldOldContent.substring(0, teamscaleTableHeaderStartIndex);
        String teamscaleGeneratedFieldContent = destinationFieldOldContent.substring(teamscaleTableHeaderStartIndex);
        ArrayList<Object> result = new ArrayList<Object>();
        String[] lines = StringUtils.splitLines((String)teamscaleGeneratedFieldContent);
        for (int i = 1; i < lines.length; ++i) {
            if (lines[i].startsWith(newMessage.getProjectSpecificLinePrefix())) continue;
            result.add(lines[i] + "\r\n");
        }
        result.add(newMessage.toJiraMessage(false));
        Collections.sort(result);
        result.addFirst(lines[0] + "\r\n");
        result.addFirst(nonTeamscaleRelatedFieldContent);
        return String.join((CharSequence)"", result);
    }

    private static Set<String> getDestinationsFromConnector(JiraBugTrackerConnectorDescriptor connectorDescriptor) {
        return Optional.ofNullable((JiraIssueUpdateConfiguration)connectorDescriptor.retrieveOptionValue("Add to Jira issues")).map(JiraIssueUpdateConfiguration::getDestinations).orElseGet(Collections::emptySet);
    }

    private static List<String> getCookiesFromConnector(JiraBugTrackerConnectorDescriptor connectorDescriptor) {
        return Optional.ofNullable((List)connectorDescriptor.retrieveOptionValue("Cookies")).orElseGet(Collections::emptyList);
    }

    private static ExternalCredentials getExternalCredentialsFromConnector(JiraBugTrackerConnectorDescriptor connectorDescriptor, ExternalCredentialsIndex index) throws BugTrackerException, StorageException {
        AccountCredentials accountCredentials = (AccountCredentials)connectorDescriptor.retrieveOptionValue("Account");
        if (accountCredentials == null) {
            throw new BugTrackerException("Jira connector without credentials encountered.");
        }
        ExternalCredentials result = index.getExternalCredentials(accountCredentials.getAccountIdentifier());
        if (result == null) {
            throw new BugTrackerException("Requested credentials do not exist.");
        }
        return result;
    }

    public String getJiraServerBaseUrl() {
        return this.jiraClient.getBaseUrl();
    }

    @VisibleForTesting
    Set<String> getDestinations() {
        return this.destinations;
    }

    @VisibleForTesting
    Map<String, List<String>> getCustomFieldNameToIdMapping() {
        return this.customFieldNameToIdMapping;
    }
}

