/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar;

import com.google.common.base.Preconditions;
import com.teamscale.index.issues.radar.RadarProblemStateRecord;
import com.teamscale.index.issues.radar.model.RadarChangeRecord;
import com.teamscale.index.issues.radar.model.RadarProblem;
import com.teamscale.index.issues.radar.model.RadarProblemDescription;
import com.teamscale.index.issues.radar.model.RadarProblemHistory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;

public class RadarProblemEditHistory {
    private final @Nullable RadarProblemStateRecord stateBeforeHistoryStart;
    private final List<RadarProblemStateRecord> records;

    private RadarProblemEditHistory(@Nullable RadarProblemStateRecord stateBeforeHistoryStart, List<RadarProblemStateRecord> records) {
        this.stateBeforeHistoryStart = stateBeforeHistoryStart;
        this.records = records;
    }

    public static RadarProblemEditHistory create(RadarProblem problem, long startTimestampInclusive) {
        int historyStartIndex = RadarProblemEditHistory.findHistoryStartIndex(problem.getEditHistory(), startTimestampInclusive);
        int historySize = problem.getEditHistory().size();
        Preconditions.checkState((historyStartIndex >= 0 && historyStartIndex <= historySize ? 1 : 0) != 0);
        if (historyStartIndex == historySize) {
            return new RadarProblemEditHistory(null, Collections.emptyList());
        }
        ArrayList sortedHistory = CollectionUtils.sort(problem.getEditHistory());
        List relevantHistory = CollectionUtils.subListFrom((List)sortedHistory, (int)historyStartIndex);
        Map<Date, RadarProblemDescription> descriptionHistoryLookup = problem.getDescriptionHistory().stream().collect(Collectors.toMap(RadarProblemDescription::addedDate, d -> d, RadarProblemDescription::combine));
        List<RadarProblemStateRecord> records = relevantHistory.stream().map(historyRecord -> new RadarProblemStateRecord((RadarProblemHistory)historyRecord, (RadarProblemDescription)descriptionHistoryLookup.get(historyRecord.changeDate()))).toList();
        RadarProblemStateRecord previousStateRecord = null;
        if (historyStartIndex > 0) {
            previousStateRecord = new RadarProblemStateRecord((RadarProblemHistory)sortedHistory.get(historyStartIndex - 1), RadarProblemEditHistory.findInitialDescription(problem, startTimestampInclusive));
        }
        return new RadarProblemEditHistory(previousStateRecord, records);
    }

    private static <T extends RadarChangeRecord> int findHistoryStartIndex(List<T> editHistory, long startTimestampInclusive) {
        Preconditions.checkArgument((!editHistory.isEmpty() ? 1 : 0) != 0);
        int historyStartIndex = editHistory.size();
        for (int i = 0; i < editHistory.size(); ++i) {
            if (((RadarChangeRecord)editHistory.get(i)).changeDate().getTime() < startTimestampInclusive) continue;
            historyStartIndex = i;
            break;
        }
        return historyStartIndex;
    }

    private static @Nullable RadarProblemDescription findInitialDescription(RadarProblem problem, long startTimestampInclusive) {
        ArrayList descriptionEditHistory = CollectionUtils.sort(problem.getDescriptionHistory());
        int historyStartIndex = RadarProblemEditHistory.findHistoryStartIndex(descriptionEditHistory, startTimestampInclusive);
        if (historyStartIndex > 0) {
            return (RadarProblemDescription)descriptionEditHistory.get(historyStartIndex - 1);
        }
        return (RadarProblemDescription)descriptionEditHistory.getFirst();
    }

    public @Nullable RadarProblemStateRecord getStateBeforeHistoryStart() {
        return this.stateBeforeHistoryStart;
    }

    public List<RadarProblemStateRecord> getRecords() {
        return this.records;
    }
}

