/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.radar;

import com.teamscale.index.issues.radar.RadarProblemEditHistory;
import com.teamscale.index.issues.radar.RadarProblemStateRecord;
import com.teamscale.index.issues.radar.model.RadarProblem;
import com.teamscale.index.issues.radar.model.RadarProblemDescription;
import com.teamscale.index.issues.radar.model.RadarProblemHistory;
import com.teamscale.index.issues.radar.model.RadarRelatedProblem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;

class RadarProblemHistorySimulator {
    private static final String RADAR_CLOSED_STATE_STRING = "Closed";
    private final long startTimestampInclusive;
    private final String connectorId;
    private final RadarProblem problem;
    private final boolean isNewProblem;
    private final List<String> customFields;

    public RadarProblemHistorySimulator(long startTimestampInclusive, String connectorId, RadarProblem problem, boolean isNewProblem, List<String> customFields) {
        this.startTimestampInclusive = startTimestampInclusive;
        this.connectorId = connectorId;
        this.problem = problem;
        this.isNewProblem = isNewProblem;
        this.customFields = customFields;
    }

    private static TeamscaleIssue createUpdatedIssue(TeamscaleIssue issue, RadarProblemStateRecord record) {
        String assignee = record.historyRecord().assignee().email();
        String description = record.getDescriptionAtThisTime(issue);
        String state = record.historyRecord().newState();
        long updateTimestamp = record.historyRecord().changeDate().getTime();
        return new TeamscaleIssue(issue.getId(), issue.getSubject(), assignee, issue.getAuthor(), description, issue.getCreated(), updateTimestamp, state, state.equals(RADAR_CLOSED_STATE_STRING), issue.getUrl(), (List)issue.getAdditionalFieldNames(), (List)issue.getAdditionalFieldValues(), null);
    }

    public List<TeamscaleIssue> simulateIssueHistory() {
        TeamscaleIssue lastHistoryItem;
        RadarProblemEditHistory radarProblemEditHistory = RadarProblemEditHistory.create(this.problem, this.startTimestampInclusive);
        TeamscaleIssue previousIssueState = this.createIssueInInitialState(radarProblemEditHistory.getStateBeforeHistoryStart());
        ArrayList<TeamscaleIssue> result = new ArrayList<TeamscaleIssue>();
        for (RadarProblemStateRecord editRecord : radarProblemEditHistory.getRecords()) {
            if (!editRecord.hasChanged(previousIssueState)) continue;
            TeamscaleIssue updatedIssue = RadarProblemHistorySimulator.createUpdatedIssue(previousIssueState, editRecord);
            result.add(updatedIssue);
            previousIssueState = updatedIssue;
        }
        if (this.isNewProblem && result.isEmpty()) {
            RadarProblemDescription lastDescription = this.problem.getDescriptionHistory().getLast();
            List<RadarProblemHistory> problemEditHistory = this.problem.getEditHistory();
            result.add(RadarProblemHistorySimulator.createUpdatedIssue(previousIssueState, new RadarProblemStateRecord(problemEditHistory.getLast(), lastDescription)));
        }
        if (!result.isEmpty() && (lastHistoryItem = (TeamscaleIssue)result.getLast()).getUpdated() < this.problem.getLastModificationDate().getTime()) {
            lastHistoryItem.setUpdated(this.problem.getLastModificationDate().getTime());
        }
        return result;
    }

    private TeamscaleIssue createIssueInInitialState(@Nullable RadarProblemStateRecord stateBeforeHistoryStart) {
        String assignee = null;
        String state = null;
        String initialDescription = null;
        if (stateBeforeHistoryStart != null) {
            assignee = stateBeforeHistoryStart.historyRecord().assignee().email();
            state = stateBeforeHistoryStart.historyRecord().newState();
            initialDescription = Optional.ofNullable(stateBeforeHistoryStart.description()).map(RadarProblemDescription::text).orElse(null);
        }
        TeamscaleIssueId issueId = new TeamscaleIssueId(this.connectorId, this.problem.getIdString());
        String keywordsString = this.problem.getKeywords().stream().map(k -> k.keyword().name()).collect(Collectors.joining(","));
        String radarURI = "rdar://%s".formatted(this.problem.getIdString());
        List<String> defaultAdditionalNames = Arrays.asList("Component", "Keywords");
        List<String> defaultAdditionalValues = Arrays.asList(this.problem.getComponent().fullName(), keywordsString);
        List customAdditionalValues = CollectionUtils.map(this.customFields, fieldName -> this.problem.getAdditionalFields().get(fieldName));
        Map<String, List<RadarRelatedProblem>> groupedRelatedProblems = this.problem.getRelatedProblems().stream().collect(Collectors.groupingBy(RadarRelatedProblem::relationType));
        ArrayList<String> relationshipAdditionalNames = new ArrayList<String>(groupedRelatedProblems.keySet());
        List relationshipAdditionalValues = CollectionUtils.map(relationshipAdditionalNames, relation -> ((List)groupedRelatedProblems.get(relation)).stream().map(relatedProblem -> relatedProblem.problem().getIdString()).collect(Collectors.joining(",")));
        return new TeamscaleIssue(issueId, this.problem.getTitle(), assignee, this.problem.getOriginator().email(), initialDescription, this.problem.getCretaionDate().getTime(), this.problem.getLastModificationDate().getTime(), state, Objects.equals(state, RADAR_CLOSED_STATE_STRING), radarURI, CollectionUtils.concatenateLists(defaultAdditionalNames, this.customFields, (List[])new List[]{relationshipAdditionalNames}), CollectionUtils.concatenateLists(defaultAdditionalValues, (List)customAdditionalValues, (List[])new List[]{relationshipAdditionalValues}), null);
    }
}

