/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.teamscale.index.repository.MergeBaseInfo;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="merge-base-cache", options={EStorageOption.NO_ROLLBACK}, valueClasses={MergeBaseInfo.class})
public class MergeBaseCacheIndex
extends IndexBase
implements IProjectIndex {
    public static final String NAME = "merge-base-cache";
    static final Duration ENTRY_DEPRECATION_TIMESPAN = Duration.ofMinutes(20L);

    public MergeBaseCacheIndex(IStore store) {
        super(store);
    }

    public Optional<MergeBaseInfo> getValue(String mergeParentInfoKey) throws StorageException {
        Preconditions.checkNotNull((Object)mergeParentInfoKey);
        return Optional.ofNullable((MergeBaseInfo)StorageUtils.deserialize((byte[])this.store.getWithString(mergeParentInfoKey)));
    }

    public String insertMergeParentInfoFor(MergeBaseInfo parentInfo, CommitDescriptor source, CommitDescriptor target) throws StorageException {
        Preconditions.checkNotNull((Object)parentInfo, (Object)"Trying to insert a null value");
        Preconditions.checkNotNull((Object)parentInfo.getMergeBase(), (Object)"Trying to insert a MergeParentInfo without successfully computed merge base");
        this.cleanupOldEntries();
        String key = MergeBaseCacheIndex.makeKey(Instant.now().toEpochMilli(), String.valueOf(Objects.hashCode((Object[])new Object[]{source, target})));
        this.store.put(StringUtils.stringToBytes((String)key), StorageUtils.serialize((Serializable)parentInfo));
        return key;
    }

    private void cleanupOldEntries() throws StorageException {
        long twoHoursAgo = Instant.now().minus(ENTRY_DEPRECATION_TIMESPAN).toEpochMilli();
        ArrayList keysToDelete = new ArrayList();
        String newestPotentialNonExpiredKey = MergeBaseCacheIndex.makeKey(twoHoursAgo, "");
        this.store.scanKeys(null, StringUtils.stringToBytes((String)newestPotentialNonExpiredKey), (IKeyValueCallback)new KeyCollectingCallback(keysToDelete));
        this.store.remove(keysToDelete);
    }

    public static String makeKey(long timestamp, String suffix) {
        String timestampWithLeadingZeros = String.format((Locale)null, "%019d", timestamp);
        return timestampWithLeadingZeros + suffix;
    }
}

