/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.google.common.base.Suppliers;
import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.critical_change.CriticalChangeBadgesConfiguration;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfigurationEntry;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.findings.calculation.AffectedFilesUtils;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.EBlacklistingOption;
import com.teamscale.index.findings.calculation.FilteredFindingDelta;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestChangedMethod;
import com.teamscale.index.merge_request.MergeRequestDeltaIndex;
import com.teamscale.index.merge_request.MergeRequestFindingChurnCalculator;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.MergeRequestMetricEvaluator;
import com.teamscale.index.merge_request.MergeRequestProcessor;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestTestGapInfo;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.SkipMergeRequestCalculationEarlyChecker;
import com.teamscale.index.merge_request.comments.RepositoryPathMapper;
import com.teamscale.index.merge_request.comments.ReviewCommentEngine;
import com.teamscale.index.merge_request.comments.ReviewCommentEngineParameters;
import com.teamscale.index.merge_request.comments.cluster.IFindingClusterStrategy;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.commit_alerts.CommitAlertsInfo;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChange;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeInfo;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeMatcher;
import com.teamscale.index.merge_request.metrics.IMergeRequestMetricGroupEvaluationResult;
import com.teamscale.index.merge_request.metrics.IMergeRequestSingleMetricAssessmentEvaluationResult;
import com.teamscale.index.merge_request.metrics.MergeRequestMetricThresholdsInfo;
import com.teamscale.index.merge_request.testcoverage.MergeRequestLineCoverageCalculator;
import com.teamscale.index.merge_request.testcoverage.TestCoverageDeltaInfo;
import com.teamscale.index.merge_request.voting.PostponedVotingIndex;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import com.teamscale.index.repository.git.GitBranchPointerIndex;
import com.teamscale.index.repository.git.common.BuildCompletenessStatus;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.TestGapVotingInfo;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.tracking.FindingChurnList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.FindingDelta;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class MergeRequestAnnotationTriggerBase<PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB>
extends CommitVotingTriggerBase<MergeRequestAnnotationInput> {
    private static final Logger LOGGER = LogManager.getLogger();
    private MergeRequestIndex mergeRequestIndex;
    private MergeRequestDeltaIndex mergeRequestDeltaIndex;
    private MergeRequestProvider<PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB> mergeRequestProvider;
    private SupplierWithException<GitBranchPointerIndex, StorageException> branchPointerIndexSupplier;
    private SupplierWithException<List<CommitTreeNode>, StorageException> commitTreeNodesSupplier;
    private Supplier<IncludeExcludeRegexSupport> includedBranchesForVotingCheckSupplier;

    @Override
    protected void openIndexes(CommitDescriptor schedulingCommit) throws StorageException {
        super.openIndexes(schedulingCommit);
        this.mergeRequestIndex = (MergeRequestIndex)this.openIndexInProject(MergeRequestIndex.class);
        this.mergeRequestDeltaIndex = (MergeRequestDeltaIndex)this.openIndexInProject(MergeRequestDeltaIndex.class);
    }

    @Override
    protected void initializeForSchedulingParameters(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException, ServiceCallException {
        this.mergeRequestProvider = this.createMergeRequestProvider(schedulingParameters);
        this.branchPointerIndexSupplier = SupplierWithException.memoize(() -> (GitBranchPointerIndex)this.openNamedIndexInProject(GitBranchPointerIndex.createIndexName(schedulingParameters.connector().getIdentifier()), GitBranchPointerIndex.class, HistoryAccessOption.readTimestamp((String)"d", (long)System.currentTimeMillis())));
        this.commitTreeNodesSupplier = SupplierWithException.memoize(() -> ((CommitTreeIndex)this.openNamedIndexInProject(CommitTreeIndex.getIndexNameForRepository((String)schedulingParameters.connector().getIdentifier()), CommitTreeIndex.class, null)).loadTree().getAllNodes());
        this.includedBranchesForVotingCheckSupplier = Suppliers.memoize(() -> VotingConnectorUtils.getOnBranchVoteIncludeExcludePatterns(schedulingParameters.connector()));
    }

    @TestOnly
    public void setIncludedBranchesForVotingCheckSupplier(Supplier<IncludeExcludeRegexSupport> delegate) {
        this.includedBranchesForVotingCheckSupplier = Suppliers.memoize(delegate::get);
    }

    @Override
    protected void skipVotingIfPossible(CommitDescriptor schedulingCommit) throws StorageException, VotingException {
        super.skipVotingIfPossible(schedulingCommit);
        SkipMergeRequestCalculationEarlyChecker.skipCalculationEarlyIfPossible(this.openProjectStorageSystem(), schedulingCommit, this::getOriginalBranchName);
    }

    private String getOriginalBranchName(String repoId, String renamedBranchName) throws StorageException {
        CommitTreeIndex commitTreeIndex = (CommitTreeIndex)this.openProjectStorageSystem().openIndex(CommitTreeIndex.class, CommitTreeIndex.getIndexNameForRepository((String)repoId), null, null);
        Map renamedToOriginalBranchNamesMap = CollectionUtils.inverseMap((Map)BranchRenamingCommitTreeFacade.loadSortedRenameMapping(commitTreeIndex).toMap());
        if (renamedToOriginalBranchNamesMap.containsKey(renamedBranchName)) {
            return (String)renamedToOriginalBranchNamesMap.get(renamedBranchName);
        }
        return renamedBranchName;
    }

    protected abstract MergeRequestProvider<PLATFORM_SPECIFIC_MERGE_REQUEST, PLATFORM_SPECIFIC_BUILD_JOB> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters var1) throws StorageException, ServiceCallException;

    @Override
    protected boolean isRelevantLogEntry(RepositoryLogEntryAggregate repositoryLogEntry) throws StorageException {
        return this.mergeRequestIndex.getMergeRequest(repositoryLogEntry.getRevision()).isPresent();
    }

    @Override
    protected Pair<MergeRequest, MergeRequestAnnotationInput> calculateVotingInput(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException, VotingException {
        MergeRequest mergeRequest = this.mergeRequestIndex.getMergeRequest(schedulingParameters.latestLogForConnector().getRevision()).orElseThrow(() -> new StorageException("No merge request found for revision: " + schedulingParameters.latestLogForConnector().getRevision()));
        mergeRequest = this.updateMergeRequest(mergeRequest);
        CommitDescriptor targetCommit = this.resolveTargetCommit(mergeRequest);
        CommitDescriptor sourceCommit = this.resolveLastFullyAnalyzedCommit(schedulingParameters);
        try {
            return Pair.createPair((Object)mergeRequest, (Object)this.calculateVotingInput(schedulingParameters, mergeRequest, sourceCommit, targetCommit));
        }
        catch (CommitResolutionException e) {
            throw new VotingException.Error(sourceCommit, (Throwable)e);
        }
    }

    private CommitDescriptor resolveLastFullyAnalyzedCommit(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        String sourceBranchName = schedulingParameters.latestCommitForConnector().getBranchName();
        return this.getSourceCommit(schedulingParameters, sourceBranchName).orElseThrow(MergeRequestAnnotationTriggerBase.exceptionForMissingCommit(sourceBranchName, "source"));
    }

    private CommitDescriptor resolveTargetCommit(MergeRequest mergeRequest) throws StorageException {
        String targetBranchName = mergeRequest.targetBranch;
        Optional<CommitDescriptor> targetCommit = this.commitsOnBranchCache.getLatestCommitOnBranchFromCache(targetBranchName);
        if (targetCommit.isEmpty()) {
            targetCommit = this.findTargetCommitViaRepository(targetBranchName);
        }
        return targetCommit.orElseThrow(MergeRequestAnnotationTriggerBase.exceptionForMissingCommit(targetBranchName, "target"));
    }

    private Optional<CommitDescriptor> getSourceCommit(CommitVotingTriggerBase.SchedulingParameters schedulingParams, String sourceBranchName) throws StorageException {
        Optional<CommitDescriptor> sourceCommit = this.commitsOnBranchCache.getLatestCommitOnBranchFromCache(sourceBranchName);
        if (sourceCommit.isEmpty()) {
            return this.findTargetCommitViaRepository(sourceBranchName);
        }
        CommitDescriptor latestCommitForBranch = sourceCommit.get();
        if (latestCommitForBranch.getTimestamp() == schedulingParams.schedulingCommit().getTimestamp()) {
            return sourceCommit;
        }
        if (latestCommitForBranch.getTimestamp() < schedulingParams.schedulingCommit().getTimestamp()) {
            LOGGER.error("Trigger is scheduled with a commit that is newer than the latest commit in the commit descriptor index. This should never happen!");
            return Optional.empty();
        }
        AnalysisState analysisState = this.analysisStateIndex.getAnalysisState(sourceBranchName);
        if (analysisState != null && analysisState.getTimestamp() > schedulingParams.schedulingCommit().getTimestamp()) {
            return Optional.of(new CommitDescriptor(sourceBranchName, analysisState.getTimestamp().longValue()));
        }
        if (analysisState != null && analysisState.getTimestamp() == 0L) {
            return Optional.of(schedulingParams.schedulingCommit());
        }
        return sourceCommit;
    }

    private Optional<CommitDescriptor> findTargetCommitViaRepository(String branchName) throws StorageException {
        String targetCommitSha = ((GitBranchPointerIndex)((Object)this.branchPointerIndexSupplier.get())).getCommitForBranchPointer(branchName);
        if (targetCommitSha == null) {
            return Optional.empty();
        }
        for (CommitTreeNode node : (List)this.commitTreeNodesSupplier.get()) {
            if (!node.getRevision().getRevision().equals(targetCommitSha)) continue;
            return Optional.of(node.getAdjustedCommitDescriptor());
        }
        return Optional.empty();
    }

    private MergeRequest updateMergeRequest(MergeRequest mergeRequest) throws StorageException, VotingException {
        LOGGER.traceEntry("Update merge request {} if needed", new Object[]{mergeRequest.identifier});
        MergeRequest updatedMergeRequest = null;
        try {
            CrossRepositoryMergeRequestSourceBranchesIndex crossRepositoryMergeRequestSourceBranchesIndex = this.openCrossRepositoryMergeRequestSourceBranchesIndex(mergeRequest);
            PostponedVotingIndex postponedVotingIndex = (PostponedVotingIndex)this.openIndexInProject(PostponedVotingIndex.class);
            MergeRequestProcessor.ProcessMergeRequestResult processMergeRequestResult = new MergeRequestProcessor(this.mergeRequestProvider, this.mergeRequestIndex, crossRepositoryMergeRequestSourceBranchesIndex, postponedVotingIndex).processMergeRequest(mergeRequest.identifier);
            updatedMergeRequest = processMergeRequestResult.updatedMergeRequest();
        }
        catch (ServiceCallException e) {
            this.logAndThrowVotingError(mergeRequest, e);
        }
        if (updatedMergeRequest == null) {
            LOGGER.debug("Skipping voting on Merge Request {} because it is was deleted.", (Object)mergeRequest.identifier);
            throw VotingException.Skipped.noLongerExists(mergeRequest.identifier, this.getLatestCommitOnSourceBranch(mergeRequest));
        }
        if (updatedMergeRequest.status != EMergeRequestStatus.OPEN) {
            LOGGER.debug("Skipping voting on Merge Request {} because it is no longer open.", (Object)mergeRequest.identifier);
            throw VotingException.Skipped.notOpen(updatedMergeRequest.identifier, this.getLatestCommitOnSourceBranch(updatedMergeRequest));
        }
        if (this.isTargetBranchVoteExcluded(updatedMergeRequest)) {
            LOGGER.debug("Skipping voting on Merge Request {} because the target branch {} is excluded from voting", (Object)updatedMergeRequest.identifier, (Object)updatedMergeRequest.getTargetBranch());
            throw VotingException.Skipped.targetBranchIsExcludedFromVoting(updatedMergeRequest.identifier, this.getLatestCommitOnSourceBranch(updatedMergeRequest));
        }
        return (MergeRequest)LOGGER.traceExit(updatedMergeRequest);
    }

    private CrossRepositoryMergeRequestSourceBranchesIndex openCrossRepositoryMergeRequestSourceBranchesIndex(MergeRequest mergeRequest) throws StorageException {
        String connectorIdentifier = MergeRequestUtils.guessConnectorFromProject(this.getIndexLayer(), (IProjectId)this.getProjectId(), mergeRequest.identifier.repositoryName).map(ConnectorConfiguration::getIdentifier).orElseThrow(() -> new StorageException("Failed to find matching connector for merge request '" + String.valueOf(mergeRequest.identifier) + "'."));
        return (CrossRepositoryMergeRequestSourceBranchesIndex)this.openNamedIndexInProject(CrossRepositoryMergeRequestSourceBranchesIndex.createIndexName(connectorIdentifier), CrossRepositoryMergeRequestSourceBranchesIndex.class, null);
    }

    private void logAndThrowVotingError(MergeRequest mergeRequest, ServiceCallException e) throws StorageException, VotingException.Error {
        LOGGER.atError().withMarker(LoggingUtils.INTERACTION).withThrowable((Throwable)e).log("Could not check whether merge request {} is still open.", (Object)mergeRequest.identifier);
        Optional<CommitDescriptor> sourceCommit = this.commitDescriptorIndex.getLatestCommitForBranch(mergeRequest.sourceBranch).map(CommitDescriptor::new);
        throw new VotingException.Error(sourceCommit.orElse(null), "Could not check the external state of the merge request %s.".formatted(mergeRequest.identifier), e);
    }

    @VisibleForTesting
    public boolean isTargetBranchVoteExcluded(MergeRequest mergeRequest) throws StorageException {
        return !this.includedBranchesForVotingCheckSupplier.get().isIncluded(mergeRequest.targetBranch) && !this.getDefaultBranchName().equals(mergeRequest.targetBranch);
    }

    private @Nullable CommitDescriptor getLatestCommitOnSourceBranch(MergeRequest mergeRequest) throws StorageException {
        return this.commitsOnBranchCache.getLatestCommitOnBranchFromCache(mergeRequest.sourceBranch).orElse(null);
    }

    private MergeRequestAnnotationInput calculateVotingInput(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequest mergeRequest, CommitDescriptor sourceCommit, CommitDescriptor targetCommit) throws StorageException, CommitResolutionException {
        String repositoryIdentifier = schedulingParams.connector().getIdentifier();
        MergeBaseInfo mergeBase = this.determineMergeBase(sourceCommit, targetCommit, repositoryIdentifier);
        FindingDelta findingsDelta = this.determineFindingDelta(mergeBase, sourceCommit, targetCommit, repositoryIdentifier);
        MergeRequestTestGapInfo testGapInfo = this.calculateTestGaps(schedulingParams.connector(), sourceCommit, mergeRequest.identifier, mergeBase);
        return MergeRequestAnnotationInput.builder().setConnectorOptions(schedulingParams.connector()).setSourceCommit(sourceCommit).setTargetCommit(targetCommit).setMergeRequest(mergeRequest).setMergeBase(mergeBase).setCommitAlertsInfo(this.calculateCommitAlertsInfo(schedulingParams.connector(), mergeRequest.identifier, mergeBase)).setFindingsDelta(findingsDelta).setRelevantFindingsDelta(this.calculateRelevantFindingsDelta(schedulingParams, sourceCommit, findingsDelta)).setImpactedSpecItemsDelta(VotingConnectorUtils.determineImpactedSpecItemDelta(mergeBase, sourceCommit, repositoryIdentifier, this.openProjectStorageSystem(), this.openGlobalStorageSystem(), this.getParallelTaskExecutor())).setTestGapInfo(testGapInfo).setTestCoverageDeltaInfo(this.calculateTestCoverage(schedulingParams.connector(), sourceCommit, mergeBase)).setMetricThresholdsInfo(this.evaluateMetricThresholds(sourceCommit, mergeBase.getMergeBase(), schedulingParams.connector(), this.openProjectStorageSystem(), this.openGlobalStorageSystem(), mergeRequest.identifier)).setCriticalChangeInfo(this.detectCriticalChangesIfConfigured(schedulingParams.connector(), sourceCommit, mergeRequest.identifier, mergeBase, testGapInfo)).build();
    }

    private @NonNull FindingDelta calculateRelevantFindingsDelta(CommitVotingTriggerBase.SchedulingParameters schedulingParams, CommitDescriptor sourceCommit, FindingDelta findingsDelta) throws StorageException {
        IncludeExcludeAntPatternSupport voteIncludeExcludePattern = VotingConnectorUtils.getOnFileVoteIncludeExcludePatterns(schedulingParams.connector());
        return FindingDelta.create(this.removeExcludedFindings(findingsDelta.getAddedFindings(), sourceCommit.getBranchName(), voteIncludeExcludePattern), this.removeExcludedFindings(findingsDelta.getFindingsInChangedCode(), sourceCommit.getBranchName(), voteIncludeExcludePattern), this.removeExcludedFindings(findingsDelta.getRemovedFindings(), sourceCommit.getBranchName(), voteIncludeExcludePattern));
    }

    @VisibleForTesting
    public MergeRequestCriticalChangeInfo detectCriticalChangesIfConfigured(ConnectorConfiguration connector, CommitDescriptor sourceCommit, MergeRequestIdentifier identifier, MergeBaseInfo mergeBase, MergeRequestTestGapInfo testGapInfo) {
        try {
            CriticalChangeBadgesConfiguration config = VotingConnectorUtils.getCriticalChangeBadgesConfiguration(connector);
            if (config.getConfiguredBadges().isEmpty()) {
                return new MergeRequestCriticalChangeInfo((Set<MergeRequestCriticalChange>)CollectionUtils.emptySet());
            }
            return this.detectCriticalChangeLocations(config, sourceCommit, identifier, mergeBase, testGapInfo);
        }
        catch (ProjectConfigurationException | BranchPointNotFoundException | StorageException e) {
            LOGGER.atError().withThrowable(e).log("Failed to evaluate critical changes badges for merge request '{}'.", (Object)identifier);
            return new MergeRequestCriticalChangeInfo((Set<MergeRequestCriticalChange>)CollectionUtils.emptySet());
        }
    }

    @VisibleForTesting
    public MergeRequestCriticalChangeInfo detectCriticalChangeLocations(CriticalChangeBadgesConfiguration config, CommitDescriptor sourceCommit, MergeRequestIdentifier identifier, MergeBaseInfo mergeBase, MergeRequestTestGapInfo testGapInfo) throws StorageException, BranchPointNotFoundException {
        List<MergeRequestChangedMethod> allChangedMethods = testGapInfo != null ? testGapInfo.allChangedMethods() : this.calculateChangedMethodsInMergeRequest(sourceCommit, identifier, mergeBase);
        return new MergeRequestCriticalChangeMatcher(config.getConfiguredBadges(), allChangedMethods).findCriticalChanges();
    }

    @VisibleForTesting
    public List<MergeRequestChangedMethod> calculateChangedMethodsInMergeRequest(CommitDescriptor sourceCommit, MergeRequestIdentifier identifier, MergeBaseInfo mergeBase) throws StorageException, BranchPointNotFoundException {
        List<AssessedTgaData.AssessedMethodData> allMethodData = TgaRequestUtils.getAllChangedMethodsInMergeRequest(sourceCommit, identifier, mergeBase, this.indexLayer, (IProjectId)this.getProjectId());
        return CollectionUtils.map(allMethodData, method -> new MergeRequestChangedMethod(method.getMethodName(), method.getLocation()));
    }

    private MergeRequestMetricThresholdsInfo evaluateMetricThresholds(CommitDescriptor sourceCommit, CommitDescriptor baseCommit, ConnectorConfiguration connectorConfiguration, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, MergeRequestIdentifier mergeRequestIdentifier) {
        try {
            MergeRequestMetricEvaluator evaluator = new MergeRequestMetricEvaluator(globalStorageSystem, projectStorageSystem, sourceCommit.getBranchName(), baseCommit, this.getParallelTaskExecutor());
            Set<IMergeRequestMetricGroupEvaluationResult> evaluatedMetricGroups = evaluator.evaluateMetricGroups(MergeRequestAnnotationTriggerBase.getConfiguredMetricGroupBadges(connectorConfiguration));
            Stream<IMergeRequestSingleMetricAssessmentEvaluationResult> evaluatedMetrics = MergeRequestAnnotationTriggerBase.getConfiguredMetricBadges(connectorConfiguration).stream().map(evaluator::evaluateMetricThreshold);
            if (EFeatureToggle.HIDE_METRIC_BADGES_WITH_ZERO_OR_NA.isEnabled()) {
                evaluatedMetrics = evaluatedMetrics.filter(IMergeRequestSingleMetricAssessmentEvaluationResult::hasDelta);
            }
            return new MergeRequestMetricThresholdsInfo(evaluatedMetrics.collect(Collectors.toUnmodifiableSet()), evaluatedMetricGroups);
        }
        catch (ProjectConfigurationException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to evaluate metric threshold badges for merge request '{}'.", (Object)mergeRequestIdentifier);
            return new MergeRequestMetricThresholdsInfo((Set<IMergeRequestSingleMetricAssessmentEvaluationResult>)CollectionUtils.emptySet(), (Set<IMergeRequestMetricGroupEvaluationResult>)CollectionUtils.emptySet());
        }
    }

    private static List<MetricBadgesConfigurationEntry> getConfiguredMetricBadges(ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException {
        try {
            return VotingConnectorUtils.getMetricBadgesConfiguration(connectorConfiguration, "Badges for Metrics").getConfiguredBadges();
        }
        catch (JsonSerializationException e) {
            throw new ProjectConfigurationException("Failed to parse metric badges configuration of option '%s' in connector '%s'.".formatted("Badges for Metrics", connectorConfiguration.getIdentifier()), (Throwable)e);
        }
    }

    private static List<MetricBadgesConfigurationEntry> getConfiguredMetricGroupBadges(ConnectorConfiguration connectorConfiguration) throws ProjectConfigurationException {
        try {
            return VotingConnectorUtils.getMetricBadgesConfiguration(connectorConfiguration, "Badges for Metric Groups").getConfiguredBadges();
        }
        catch (JsonSerializationException e) {
            throw new ProjectConfigurationException("Failed to parse metric badges configuration of option '%s' in connector '%s'.".formatted("Badges for Metric Groups", connectorConfiguration.getIdentifier()), (Throwable)e);
        }
    }

    private @Nullable MergeRequestTestGapInfo calculateTestGaps(ConnectorConfiguration connector, CommitDescriptor sourceCommit, MergeRequestIdentifier mergeRequestIdentifier, MergeBaseInfo mergeBase) throws StorageException {
        MergeRequestTestGapInfo testGapInfo = null;
        if (CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(connector)) {
            try {
                testGapInfo = TgaRequestUtils.calculateTestGapsForMergeRequest(sourceCommit, mergeRequestIdentifier, mergeBase, this.getIndexLayer(), (IProjectId)this.getProjectId());
            }
            catch (BranchPointNotFoundException e) {
                LOGGER.atWarn().withThrowable((Throwable)e).log("Could not calculate test gaps.");
            }
        }
        return testGapInfo;
    }

    private @Nullable TestCoverageDeltaInfo calculateTestCoverage(ConnectorConfiguration connector, CommitDescriptor sourceCommit, MergeBaseInfo mergeBase) throws StorageException {
        int threshold;
        if (!CcpIntegrationFeatureEnablements.isVotingForTestCoverageEnabled(connector)) {
            return null;
        }
        String coverageThresholdValue = connector.getOptionValue("Line coverage threshold");
        if (coverageThresholdValue == null) {
            LOGGER.warn("Could not find value for coverage threshold in connector {}. Falling back to default value {}.", (Object)connector.getIdentifier(), (Object)60);
            threshold = 60;
        } else {
            threshold = Integer.parseInt(coverageThresholdValue);
        }
        return MergeRequestLineCoverageCalculator.getLineCoverageDelta(this.openProjectStorageSystem(), sourceCommit, mergeBase, threshold);
    }

    private CommitAlertsInfo calculateCommitAlertsInfo(ConnectorConfiguration connector, MergeRequestIdentifier mergeRequestIdentifier, MergeBaseInfo mergeBase) throws StorageException {
        List commitAlerts = null;
        int totalCommitAlertsFromAllCommits = 0;
        if (CcpIntegrationFeatureEnablements.isCommitAlertsIntegrationEnabled(connector)) {
            CommitAlertIndex commitAlertIndex = (CommitAlertIndex)this.openIndexInProject(CommitAlertIndex.class);
            commitAlerts = commitAlertIndex.getEntries(this.getRelevantCommitsForAlertComments(mergeRequestIdentifier, mergeBase));
            commitAlerts.removeIf(Objects::isNull);
            List allCommitAlerts = commitAlertIndex.getEntries(mergeBase.getRelevantCommits());
            allCommitAlerts.removeIf(Objects::isNull);
            for (CommitAlerts alerts : allCommitAlerts) {
                totalCommitAlertsFromAllCommits += alerts.getAlertCount();
            }
        }
        return new CommitAlertsInfo(commitAlerts, totalCommitAlertsFromAllCommits);
    }

    @Override
    protected void persistVotingInput(MergeRequestAnnotationInput input) throws StorageException {
        FindingChurnList findingChurnList = new FindingChurnList(input.sourceCommit);
        findingChurnList.addAddedFindings(input.getRelevantFindingsDelta().getAddedFindings());
        findingChurnList.addRemovedFindings(input.getRelevantFindingsDelta().getRemovedFindings());
        findingChurnList.addFindingsInChangedCode(input.getRelevantFindingsDelta().getFindingsInChangedCode());
        CounterSet<ETestGapState> testGapStates = null;
        if (input.testGapInfo != null) {
            testGapStates = input.testGapInfo.testGapStates();
        }
        this.mergeRequestDeltaIndex.updateDelta(input.mergeRequest.identifier, input.mergeBase, findingChurnList, this.getNumberOfPendingExclusions(input), input.impactedSpecItemsDelta, testGapStates, input.criticalChangeInfo);
    }

    private int getNumberOfPendingExclusions(MergeRequestAnnotationInput input) throws StorageException {
        return MergeRequestAnnotationTriggerBase.getNumberOfPendingExclusions(this.openProjectStorageSystem(), input.getFindingsDelta().getAddedFindings(), this.jobDescriptor.getSchedulingCommit());
    }

    public static int getNumberOfPendingExclusions(ProjectStorageSystem projectStorageSystem, Collection<TrackedFinding> addedFindings, CommitDescriptor schedulingCommit) throws StorageException {
        FindingBlacklistIndex findingBlacklistIndex = (FindingBlacklistIndex)projectStorageSystem.openProjectIndex(FindingBlacklistIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)schedulingCommit));
        List<String> addedFindingIds = addedFindings.stream().map(TrackedFinding::getId).toList();
        return Math.toIntExact(findingBlacklistIndex.getBlacklistInfos(addedFindingIds).stream().filter(Objects::nonNull).filter(blacklistInfo -> !blacklistInfo.getApprovalState().resolved()).count());
    }

    @Override
    protected VotingRecord.EVotingState performVoting(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, VotingException, ExecutionCanceledException, ServiceCallException {
        VotingRecord.EVotingState votingState = VotingRecord.EVotingState.UNVOTED;
        if (Boolean.parseBoolean(schedulingParams.connector().getOptionValue("Skip Voting on merge requests without relevant changes")) && this.getMergeChurnFromTo(input.mergeBase).isEmpty()) {
            return votingState;
        }
        VotingException votingException = this.annotateMergeRequest(schedulingParams, input);
        try {
            this.verifyNotCanceled();
            votingState = this.addVoteToMergeRequest(schedulingParams, input);
        }
        catch (ServiceCallException e) {
            LOGGER.atError().withThrowable((Throwable)e).withMarker(LoggingUtils.INTERACTION).log("Could not annotate merge request {}.", (Object)input.mergeRequest.identifier);
            votingException = new VotingException.Error(schedulingParams.schedulingCommit(), "Could not annotate merge request " + String.valueOf(input.mergeRequest.identifier) + ": " + e.getMessage(), e);
        }
        if (votingException != null) {
            throw votingException;
        }
        return votingState;
    }

    private VotingException annotateMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, ExecutionCanceledException {
        VotingException.Error votingException = null;
        try {
            this.annotateMergeRequestWithBadges(schedulingParams, input);
        }
        catch (ServiceCallException e) {
            MergeRequestAnnotationTriggerBase.logCouldNotAnnotateMergeRequest(input, (Exception)((Object)e));
            votingException = MergeRequestAnnotationTriggerBase.createCouldNotAnnotateError(schedulingParams, input, (Exception)((Object)e));
        }
        try {
            this.verifyNotCanceled();
            this.annotateMergeRequestWithComments(schedulingParams, input);
        }
        catch (ServiceCallException | IOException | JsonSerializationException e) {
            MergeRequestAnnotationTriggerBase.logCouldNotAnnotateMergeRequest(input, (Exception)e);
            votingException = MergeRequestAnnotationTriggerBase.createCouldNotAnnotateError(schedulingParams, input, (Exception)e);
        }
        return votingException;
    }

    private static void logCouldNotAnnotateMergeRequest(MergeRequestAnnotationInput input, Exception e) {
        LOGGER.atError().withMarker(LoggingUtils.INTERACTION).withThrowable((Throwable)e).log("Could not annotate merge request {}.", (Object)input.mergeRequest.identifier);
    }

    private static VotingException.Error createCouldNotAnnotateError(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, Exception e) {
        return new VotingException.Error(schedulingParams.schedulingCommit(), "Could not annotate merge request %s.".formatted(input.mergeRequest.identifier), e);
    }

    protected abstract void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters var1, MergeRequestAnnotationInput var2, String var3, String var4) throws ServiceCallException, StorageException;

    protected abstract Set<MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration var1);

    protected abstract void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters var1, MergeRequestAnnotationInput var2) throws ServiceCallException, StorageException, ExecutionCanceledException;

    protected abstract void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters var1, MergeRequestAnnotationInput var2) throws ServiceCallException, StorageException, ExecutionCanceledException;

    private List<TokenElementChurnWithOriginInfo> getMergeChurnFromTo(MergeBaseInfo mergeBaseInfo) throws StorageException {
        List<CommitDescriptor> relevantCommits = MergeRequestUtils.determineRelevantCommitsInMergeRequest(this.repositoryLogIndex, mergeBaseInfo);
        return AffectedFilesUtils.getAffectedFiles(this.openProjectStorageSystem(), relevantCommits, null);
    }

    private static Supplier<StorageException> exceptionForMissingCommit(String branchName, String branchType) {
        return () -> new StorageException("Didn't vote because %s branch %s is not analyzed.".formatted(branchType, branchName));
    }

    private MergeBaseInfo determineMergeBase(CommitDescriptor sourceCommit, CommitDescriptor targetCommit, String repositoryIdentifier) throws StorageException, CommitResolutionException {
        MergeBaseInfo resolvedMergeParentInfo = MergeBaseResolver.computeMergeBaseInfo(sourceCommit, targetCommit, this.commitDescriptorIndex).orElseThrow(() -> new StorageException("Could not find a common ancestor commit for " + String.valueOf(sourceCommit) + " and " + String.valueOf(targetCommit) + ". Maybe the analyzed history is too short?"));
        return this.removeCodeCommitsFromOtherRepositories(resolvedMergeParentInfo, repositoryIdentifier);
    }

    private MergeBaseInfo removeCodeCommitsFromOtherRepositories(MergeBaseInfo mergeBaseInfo, String repositoryIdentifier) throws StorageException {
        return new MergeBaseInfo(mergeBaseInfo.getMergeBase(), mergeBaseInfo.getBranchPoint().orElse(null), mergeBaseInfo.getOldestNonMergeAncestorOfSource().orElse(null), CollectionUtils.filterWithException(mergeBaseInfo.getAncestorsOfSource(), commit -> this.isCommitRelevantForMergeRequest(repositoryIdentifier, (CommitDescriptor)commit)));
    }

    private boolean isCommitRelevantForMergeRequest(String repositoryIdentifier, CommitDescriptor commit) throws StorageException {
        RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)this.repositoryLogIndex.getEntry(commit);
        if (repositoryLogEntry == null) {
            LOGGER.error("Failed to compute if commit is relevant for merge request. Log entry null for commit {} on repository {}. Assuming that commit is not relevant.", (Object)commit, (Object)repositoryIdentifier);
            return false;
        }
        Set<ECommitType> commitTypes = repositoryLogEntry.getCommitTypes();
        if (commitTypes != null && commitTypes.stream().noneMatch(type -> type == ECommitType.CODE_COMMIT)) {
            return true;
        }
        return repositoryLogEntry.containsRepositoryIdentifier(repositoryIdentifier);
    }

    private FindingDelta determineFindingDelta(MergeBaseInfo mergeBase, CommitDescriptor sourceCommit, CommitDescriptor targetCommit, String repositoryId) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)this.jobDescriptor.getInternalProjectId());
        FindingsCalculationInfo calculationInfo = new FindingsCalculationInfo(this.indexLayer.resolveProject((IProjectId)this.getProjectId()).getPrimaryPublicId(), (ProjectStorageSystem)projectStorageSystem, this.indexLayer);
        BasicFindingsFilterSettings filterSettings = new BasicFindingsFilterSettings();
        filterSettings.setBlacklistingOption(EBlacklistingOption.ALL);
        FilteredFindingDelta findingDelta = MergeRequestFindingChurnCalculator.getFindingDeltaForMerge(sourceCommit, targetCommit, filterSettings, calculationInfo, mergeBase);
        return VotingConnectorUtils.filterFindingsOfOtherRepositories(this.openProjectStorageSystem(), sourceCommit, mergeBase, findingDelta.toFindingDelta(), repositoryId);
    }

    private List<CommitDescriptor> getRelevantCommitsForAlertComments(MergeRequestIdentifier mergeRequestIdentifier, MergeBaseInfo mergeBase) throws StorageException {
        MergeBaseInfo deltaMergeBase;
        Optional<MergeRequestDeltaIndex.MergeRequestDelta> mergeRequestDelta = this.mergeRequestDeltaIndex.getDelta(mergeRequestIdentifier);
        List<CommitDescriptor> relevantCommitDescriptors = mergeBase.getRelevantCommits();
        if (mergeRequestDelta.isPresent() && (deltaMergeBase = mergeRequestDelta.get().mergeBase()) != null) {
            relevantCommitDescriptors.removeAll(deltaMergeBase.getRelevantCommits());
        }
        return relevantCommitDescriptors;
    }

    private List<TrackedFinding> removeExcludedFindings(List<TrackedFinding> findings, String branchName, IncludeExcludeAntPatternSupport voteIncludeExcludePattern) throws StorageException {
        FindingBlacklistIndex blacklistIndex = (FindingBlacklistIndex)this.openIndexInProject(FindingBlacklistIndex.class, HistoryAccessOption.readHead((String)branchName));
        List<FindingBlacklistInfo> blacklistInfos = blacklistIndex.getBlacklistInfos(CollectionUtils.map(findings, TrackedFinding::getId));
        HashSet blacklistedIds = new HashSet(CollectionUtils.filterAndMap(blacklistInfos, Objects::nonNull, FindingBlacklistInfo::getFindingId));
        return CollectionUtils.filter(findings, finding -> !blacklistedIds.contains(finding.getId()) && voteIncludeExcludePattern.isIncluded(finding.getLocation().getUniformPath()));
    }

    @VisibleForTesting
    public void annotateMergeRequestWithBadges(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException {
        if (!CcpIntegrationFeatureEnablements.isAnyBadgeEnabled(schedulingParams.connector()) || CcpIntegrationFeatureEnablements.isAnyBadgeAsMergeRequestCommentEnabled(schedulingParams.connector())) {
            return;
        }
        String badgeAsMarkdown = this.buildMergeRequestMarkdownContent(input, schedulingParams.linkProvider());
        this.addBadgesToMergeRequest(schedulingParams, input, badgeAsMarkdown);
    }

    private VotingRecord.EVotingState addVoteToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException {
        VotingRecord.EVotingState state = this.determineVotingStatesAndAddVotes(schedulingParams, input);
        if ((state == VotingRecord.EVotingState.VOTING_DISABLED || state == VotingRecord.EVotingState.VOTED) && MergeRequestAnnotationTriggerBase.shouldCommentOnMergeRequest(schedulingParams)) {
            state = VotingRecord.EVotingState.COMMENTED;
        }
        return state;
    }

    protected boolean shouldAddFindingsVoteOnMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams) {
        return CcpIntegrationFeatureEnablements.isVotingForFindingsEnabled(schedulingParams.connector());
    }

    protected VotingRecord.EVotingState determineVotingStatesAndAddVotes(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException {
        return MergeRequestAnnotationTriggerBase.combineVotingStates(this.createFindingsVote(schedulingParams, input), this.createTestGapsVote(schedulingParams, input), this.createTestCoverageVote(schedulingParams, input));
    }

    private VotingRecord.EVotingState createFindingsVote(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException {
        if (!this.shouldAddFindingsVoteOnMergeRequest(schedulingParameters)) {
            return VotingRecord.EVotingState.VOTING_DISABLED;
        }
        FindingsVotingInfo findingsVotingInfo = new FindingsVotingInfo(input.getAddedRedFindings(), input.getAddedYellowFindings(), CcpIntegrationFeatureEnablements.isIgnoreYellowFindingsForVotesEnabled(schedulingParameters.connector()));
        return this.addFindingsVote(findingsVotingInfo, schedulingParameters, input);
    }

    private VotingRecord.EVotingState createTestGapsVote(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException, ServiceCallException {
        TestGapVotingInfo testGapVotingInfo = VotingConnectorUtils.computeTestGapVotingInfo(this.openProjectStorageSystem(), this.getExternalUploadsVotingCondition(), schedulingParameters, input);
        if (testGapVotingInfo.getVotingRequirementsCheckerResult() == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.TEST_GAP_INTEGRATION_DISABLED) {
            return VotingRecord.EVotingState.VOTING_DISABLED;
        }
        return this.addTestGapsVote(testGapVotingInfo, schedulingParameters, input);
    }

    protected VotingRecord.EVotingState addTestGapsVote(TestGapVotingInfo testGapVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        if (testGapVotingInfo.isPositiveVote()) {
            return VotingRecord.EVotingState.VOTING_DISABLED;
        }
        if (testGapVotingInfo.getVotingRequirementsCheckerResult() == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE) {
            return VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD;
        }
        return VotingRecord.EVotingState.VOTING_DISABLED;
    }

    private VotingRecord.EVotingState createTestCoverageVote(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException, ServiceCallException {
        LineCoverageVotingInfo lineCoverageVotingInfo = VotingConnectorUtils.computeLineCoverageVotingInfo(this.openProjectStorageSystem(), this.getExternalUploadsVotingCondition(), schedulingParameters, input);
        if (lineCoverageVotingInfo.getVotingRequirementsCheckerResult() == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.TEST_COVERAGE_VOTING_DISABLED) {
            return VotingRecord.EVotingState.VOTING_DISABLED;
        }
        return this.addTestCoverageVote(lineCoverageVotingInfo, schedulingParameters, input);
    }

    protected VotingRecord.EVotingState addTestCoverageVote(LineCoverageVotingInfo coverageVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        return VotingRecord.EVotingState.VOTING_DISABLED;
    }

    private static VotingRecord.EVotingState combineVotingStates(VotingRecord.EVotingState ... votingStates) {
        Set states = Arrays.stream(votingStates).collect(Collectors.toSet());
        if (states.contains((Object)VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD)) {
            return VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD;
        }
        if (states.contains((Object)VotingRecord.EVotingState.VOTED_NEGATIVE)) {
            return VotingRecord.EVotingState.VOTED_NEGATIVE;
        }
        if (states.contains((Object)VotingRecord.EVotingState.VOTED_POSITIVE)) {
            return VotingRecord.EVotingState.VOTED_POSITIVE;
        }
        if (states.contains((Object)VotingRecord.EVotingState.VOTED)) {
            return VotingRecord.EVotingState.VOTED;
        }
        return VotingRecord.EVotingState.VOTING_DISABLED;
    }

    private static boolean shouldCommentOnMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) {
        return CcpIntegrationFeatureEnablements.isDetailedLineCommentsForFindingsEnabled(schedulingParameters.connector()) | CcpIntegrationFeatureEnablements.isAnyTestGapCommentOptionEnabled(schedulingParameters.connector());
    }

    @VisibleForTesting
    public void annotateMergeRequestWithComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, ServiceCallException, ExecutionCanceledException, IOException, JsonSerializationException {
        for (MergeRequestAnnotationMechanism mechanism : this.getMergeRequestAnnotationMechanisms(schedulingParams.connector())) {
            List<IReviewComment> reviewComments = this.calculateCommitAlertsComments(schedulingParams, input);
            if (CcpIntegrationFeatureEnablements.isDetailedLineCommentsForFindingsEnabled(schedulingParams.connector())) {
                reviewComments.addAll(this.calculateFindingsComments(schedulingParams, input));
            }
            ArrayList<RepositoryPathMapper.RepositoryReviewComment> testGapComments = new ArrayList();
            if (this.canAddTestGapLineComments(schedulingParams, input)) {
                testGapComments = this.createTestGapComments(input, schedulingParams.linkProvider());
            }
            if (!testGapComments.isEmpty() && CcpIntegrationFeatureEnablements.isTestGapLineCommentsEnabled(schedulingParams.connector())) {
                reviewComments.addAll(this.calculateTestGapLineComments(schedulingParams, input, testGapComments));
            }
            this.addInlineComments(schedulingParams, input, reviewComments, mechanism);
            if (CcpIntegrationFeatureEnablements.isTestGapSummaryCommentEnabled(schedulingParams.connector())) {
                this.addTestGapSummaryComment(schedulingParams, input, testGapComments);
            }
            if (!CcpIntegrationFeatureEnablements.isAnyBadgeAsMergeRequestCommentEnabled(schedulingParams.connector())) continue;
            this.addBadgesAsMergeRequestComment(schedulingParams, input);
        }
    }

    protected void addBadgesAsMergeRequestComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
    }

    public TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult checkTestGapLineCommentsRequirements(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return new TestingIntegrationRequirementsChecker(this.openProjectStorageSystem(), schedulingParameters.schedulingCommit(), this.getExternalUploadsVotingCondition()).checkLineCommentsRequirements(schedulingParameters, input);
    }

    @VisibleForTesting
    public boolean canAddTestGapLineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return this.checkTestGapLineCommentsRequirements(schedulingParameters, input).isRequirementsFulfilled();
    }

    @VisibleForTesting
    public List<RepositoryPathMapper.RepositoryReviewComment> calculateFindingsComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException, ServiceCallException, ExecutionCanceledException {
        List<RepositoryPathMapper.RepositoryReviewComment> reviewComments = this.createFindingsComments(schedulingParams, input);
        if (MergeRequestAnnotationTriggerBase.isTooManyFindingsAnnotations(reviewComments.size(), schedulingParams)) {
            this.deleteInlineFindingsCommentsAfterCommentLimitExceeded(schedulingParams, input);
            this.addLineCommentLimitWarningToDescription(schedulingParams, input, String.format("There are %s added findings. This number exceeds the set limit for findings to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more findings details.", input.getAddedFindingsForLineComments().size(), schedulingParams.linkProvider().createMergeRequestDetailsLink(input.mergeRequest.identifier)), "There are %s added findings. This number exceeds the set limit for findings to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more findings details.");
            return Collections.emptyList();
        }
        return reviewComments;
    }

    @VisibleForTesting
    public List<RepositoryPathMapper.RepositoryReviewComment> createFindingsComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException {
        CommitDescriptor sourceCommit = input.sourceCommit;
        ReviewCommentEngineParameters reviewCommentTriggerParameters = this.createReviewCommentTriggerParameters(sourceCommit);
        IFindingClusterStrategy findingClusterStrategy = IFindingClusterStrategy.create(CcpIntegrationFeatureEnablements.isCommentAggregationEnabled(schedulingParams.connector()), reviewCommentTriggerParameters);
        List<TrackedFinding> addedFindingsForVoting = input.getAddedFindingsForLineComments();
        ReviewCommentEngine reviewCommentEngine = ReviewCommentEngine.create(reviewCommentTriggerParameters, findingClusterStrategy, this.repositoryPathView, sourceCommit, schedulingParams.linkProvider());
        List<RepositoryPathMapper.RepositoryReviewComment> reviewComments = reviewCommentEngine.getReviewComments(addedFindingsForVoting);
        MergeRequestAnnotationTriggerBase.logCommentedFindingsForCommit(sourceCommit, addedFindingsForVoting);
        return reviewComments;
    }

    @VisibleForTesting
    public List<RepositoryPathMapper.RepositoryReviewComment> calculateTestGapLineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<RepositoryPathMapper.RepositoryReviewComment> testGapComments) throws StorageException, ExecutionCanceledException, ServiceCallException {
        if (MergeRequestAnnotationTriggerBase.isTooManyTestGapAnnotations(testGapComments.size(), schedulingParams)) {
            this.deleteInlineTestGapCommentsAfterCommentLimitExceeded(schedulingParams, input);
            this.addLineCommentLimitWarningToDescription(schedulingParams, input, String.format("There are %s test gaps. This number exceeds the set limit for test gaps to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more test gap details.", Objects.requireNonNull(input.testGapInfo).untestedMethods().size(), schedulingParams.linkProvider().createMergeRequestDetailsLink(input.mergeRequest.identifier)), "There are %s test gaps. This number exceeds the set limit for test gaps to be shown as individual comments. Please navigate to [Teamscale](%s) instead for more test gap details.");
            return Collections.emptyList();
        }
        return testGapComments;
    }

    @VisibleForTesting
    public List<RepositoryPathMapper.RepositoryReviewComment> createTestGapComments(MergeRequestAnnotationInput input, TeamscaleCommitLinkProvider linkProvider) throws StorageException {
        CommitDescriptor sourceCommit = input.sourceCommit;
        List<AssessedTgaData.AssessedMethodData> untestedMethods = Objects.requireNonNull(input.testGapInfo).untestedMethods();
        ReviewCommentEngineParameters reviewCommentTriggerParameters = this.createReviewCommentTriggerParameters(sourceCommit);
        IFindingClusterStrategy findingClusterStrategy = IFindingClusterStrategy.create(false, reviewCommentTriggerParameters);
        ReviewCommentEngine reviewCommentEngine = ReviewCommentEngine.create(reviewCommentTriggerParameters, findingClusterStrategy, this.repositoryPathView, sourceCommit, linkProvider);
        List<RepositoryPathMapper.RepositoryReviewComment> reviewComments = reviewCommentEngine.getReviewCommentsForTestGaps(untestedMethods, input.mergeRequest.identifier);
        MergeRequestAnnotationTriggerBase.logCommentedTestGapsForCommit(sourceCommit, untestedMethods);
        return reviewComments;
    }

    @VisibleForTesting
    public static boolean isTooManyFindingsAnnotations(int amountOfAnnotations, CommitVotingTriggerBase.SchedulingParameters schedulingParams) {
        return amountOfAnnotations > VotingConnectorUtils.getDetailedLineCommentsLimitForFindings(schedulingParams.connector());
    }

    @VisibleForTesting
    public static boolean isTooManyTestGapAnnotations(int amountOfAnnotations, CommitVotingTriggerBase.SchedulingParameters schedulingParams) {
        return amountOfAnnotations > VotingConnectorUtils.getDetailedLineCommentsLimitForTestGaps(schedulingParams.connector());
    }

    @VisibleForTesting
    public List<IReviewComment> calculateCommitAlertsComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws StorageException {
        ArrayList<IReviewComment> reviewComments = new ArrayList<IReviewComment>();
        if (input.commitAlerts != null && !input.commitAlerts.isEmpty()) {
            for (CommitAlerts alerts : input.commitAlerts) {
                ReviewCommentEngineParameters reviewCommentTriggerParameters = this.createReviewCommentTriggerParameters(alerts.getCommit());
                IFindingClusterStrategy findingClusterStrategy = IFindingClusterStrategy.create(false, reviewCommentTriggerParameters);
                ReviewCommentEngine reviewCommentEngine = ReviewCommentEngine.create(reviewCommentTriggerParameters, findingClusterStrategy, this.repositoryPathView, input.sourceCommit, schedulingParams.linkProvider());
                reviewComments.addAll(reviewCommentEngine.getReviewCommentsForAlerts(alerts));
                MergeRequestAnnotationTriggerBase.logCommentedAlertsForCommit(alerts.getCommit(), alerts);
            }
        }
        return reviewComments;
    }

    private void addTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<RepositoryPathMapper.RepositoryReviewComment> testGapComments) throws ServiceCallException, JsonSerializationException, IOException {
        this.deleteExistingTestGapSummaryComments(schedulingParams, input);
        if (testGapComments.isEmpty()) {
            return;
        }
        String commentContent = CcpCommentUtils.createTestGapSummaryCommentMarkdownContent(schedulingParams, testGapComments, input.mergeRequest.identifier);
        this.postTestGapSummaryComment(schedulingParams, input.mergeRequest.getId(), commentContent);
    }

    protected abstract void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters var1, MergeRequestAnnotationInput var2) throws ServiceCallException, JsonSerializationException, IOException;

    protected abstract void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters var1, long var2, String var4) throws ServiceCallException, IOException;

    protected abstract void addInlineComments(CommitVotingTriggerBase.SchedulingParameters var1, MergeRequestAnnotationInput var2, List<IReviewComment> var3, MergeRequestAnnotationMechanism var4) throws StorageException, ServiceCallException;

    protected abstract void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters var1, MergeRequestAnnotationInput var2, String var3) throws StorageException, ServiceCallException;

    protected abstract VotingRecord.EVotingState addFindingsVote(FindingsVotingInfo var1, CommitVotingTriggerBase.SchedulingParameters var2, MergeRequestAnnotationInput var3) throws StorageException, ServiceCallException;

    public static String getRepositoryName(ConnectorConfiguration connectorConfiguration) {
        return connectorConfiguration.getOptionValue("Repository name");
    }

    @Override
    public Set<String> getReadStores() {
        return CollectionUtils.unionSet(super.getReadStores(), (Collection[])new Collection[]{CollectionUtils.asHashSet((Object[])new String[]{"commit-descriptors"})});
    }

    @Override
    public Set<String> getWriteStores() {
        return CollectionUtils.unionSet(super.getWriteStores(), (Collection[])new Collection[]{CollectionUtils.asHashSet((Object[])new String[]{"merge-request-delta", "merge-requests"})});
    }

    public boolean canCauseSchedulingConflicts() {
        return false;
    }

    @VisibleForTesting
    public String buildMergeRequestMarkdownContent(MergeRequestAnnotationInput input, TeamscaleCommitLinkProvider linkProvider) {
        boolean projectHasRequirementsConnector = this.hasProjectRequirementsConnector();
        return input.buildMergeBadgesAsMarkdown((TeamscaleProjectLinkProvider)linkProvider, projectHasRequirementsConnector, this.shouldIncludeTestGapBadge(), this.appendSizeValuesToMarkdownImage(), this.omitTitleInMarkdownImage());
    }

    @VisibleForTesting
    public boolean hasProjectRequirementsConnector() {
        try {
            return VotingConnectorUtils.projectHasRequirementsConnector((MetaIndex)this.openIndexInProject(MetaIndex.class), LOGGER);
        }
        catch (StorageException e) {
            LOGGER.error("Error opening MetaIndex for project, assuming no requirements connector enabled", (Throwable)e);
            return false;
        }
    }

    protected static boolean isBadgeSetToTopPosition(ConnectorConfiguration connector) {
        return VotingConnectorUtils.getFindingsBadgePosition(connector) == CommitVotingTriggerBase.EFindingsBadgePosition.TOP;
    }

    protected boolean appendSizeValuesToMarkdownImage() {
        return false;
    }

    protected boolean omitTitleInMarkdownImage() {
        return false;
    }

    protected boolean shouldIncludeTestGapBadge() {
        return true;
    }

    @Override
    protected MergeRequest getMergeRequest(MergeRequestAnnotationInput mergeRequestAnnotationInput) {
        return mergeRequestAnnotationInput.mergeRequest;
    }

    @Override
    protected List<CommitTreeNode> getCommitTreeNodes(MergeRequestAnnotationInput mergeRequestAnnotationInput) throws StorageException {
        return (List)this.commitTreeNodesSupplier.get();
    }

    @Override
    protected BuildCompletenessStatus getBuildCompletenessStatus(MergeRequestAnnotationInput input) {
        return input.mergeRequest.buildPipelineInfo.getBuildCompletenessStatus();
    }

    public static enum MergeRequestAnnotationMechanism {
        INLINE_COMMENTS,
        PLATFORM_SPECIFIC;

    }
}

