/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.interaction.InteractionLogMessage;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranch;
import com.teamscale.index.utils.ExternalUploadUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MergeRequestUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String INFO_LOG_CALL_MESSAGE = "Performing call to ";
    private static final String ERROR_DURING_LOG_CALL_MESSAGE = "Could not perform call to ";

    public static List<RepositoryLogFileEntry> determineRepositoryLogFileEntriesInMergeRequest(RepositoryLogIndex repositoryLogIndex, RepositoryLogFileIndex repositoryLogFileIndex, MergeBaseInfo mergeBaseInfo) throws StorageException {
        List<CommitDescriptor> relevantCommits = MergeRequestUtils.determineRelevantCommitsInMergeRequest(repositoryLogIndex, mergeBaseInfo);
        return repositoryLogFileIndex.getEntriesByCommits(relevantCommits);
    }

    public static @NonNull List<CommitDescriptor> determineRelevantCommitsInMergeRequest(RepositoryLogIndex repositoryLogIndex, MergeBaseInfo mergeBaseInfo) throws StorageException {
        List<Object> relevantCommits = mergeBaseInfo.getRelevantCommits();
        List logEntries = repositoryLogIndex.getEntries(relevantCommits);
        relevantCommits = logEntries.stream().filter(Objects::nonNull).filter(log -> log.containsRepositoryIdentifier(ExternalUploadUtils::isCodeCommit)).map(CommitAssociatedObjectBase::getCommit).collect(Collectors.toList());
        return relevantCommits;
    }

    public static List<String> getUpdatedTestCoveragePartitions(ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex, List<CommitDescriptor> relevantCommits, List<String> allTestCoveragePartitions) throws StorageException {
        Map<String, CommitDescriptor> partitionToLastUpdateMap = externalResultsPartitionLastUpdateIndex.getPartitionToLastUpdateMap(allTestCoveragePartitions);
        Optional lastMergeRequestCodeCommit = relevantCommits.stream().max(CommitDescriptor::compareTo);
        ArrayList<String> updatedPartitions = new ArrayList<String>();
        partitionToLastUpdateMap.forEach((partition, lastUpdateCommit) -> {
            if (lastMergeRequestCodeCommit.isPresent() && lastUpdateCommit.compareTo((CommitDescriptor)lastMergeRequestCodeCommit.get()) >= 0) {
                updatedPartitions.add((String)partition);
            }
        });
        return updatedPartitions;
    }

    public static <T> T performServiceCallWithLogging(String reason, String targetUri, String targetId, SupplierWithException<T, Exception> serviceCallCallback) throws ServiceCallException {
        LOGGER.info(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage(INFO_LOG_CALL_MESSAGE + reason, targetUri, targetId));
        try {
            return (T)serviceCallCallback.get();
        }
        catch (Throwable e) {
            LOGGER.error(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage(ERROR_DURING_LOG_CALL_MESSAGE + reason + ": " + String.valueOf(e), targetUri, targetId), e);
            throw MergeRequestUtils.asServiceCallException(e);
        }
    }

    public static void performServiceCallWithLogging(String reason, String targetUri, String targetId, RunnableWithException<Exception> serviceCallCallback) throws ServiceCallException {
        LOGGER.info(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage(INFO_LOG_CALL_MESSAGE + reason, targetUri, targetId));
        try {
            serviceCallCallback.run();
        }
        catch (Throwable e) {
            LOGGER.error(LoggingUtils.INTERACTION, (Message)new InteractionLogMessage(ERROR_DURING_LOG_CALL_MESSAGE + reason + ": " + String.valueOf(e), targetUri, targetId), e);
            throw MergeRequestUtils.asServiceCallException(e);
        }
    }

    private static ServiceCallException asServiceCallException(Throwable throwable) {
        if (throwable instanceof ServiceCallException) {
            return (ServiceCallException)throwable;
        }
        return new ServiceCallException(throwable);
    }

    public static <T> T performServiceCallWithLogging(String reason, String targetUri, long targetId, SupplierWithException<T, Exception> serviceCallCallback) throws ServiceCallException {
        return MergeRequestUtils.performServiceCallWithLogging(reason, targetUri, Long.toString(targetId), serviceCallCallback);
    }

    public static void performServiceCallWithLogging(String reason, String targetUri, long targetId, RunnableWithException<Exception> serviceCallCallback) throws ServiceCallException {
        MergeRequestUtils.performServiceCallWithLogging(reason, targetUri, Long.toString(targetId), serviceCallCallback);
    }

    public static Optional<CommitDescriptor> retrieveMergeRequestHeadCommitIfLive(MergeRequest mergeRequest, RepositoryRevisionIndex repositoryRevisionIndex, BranchAnalysisStateIndex branchAnalysisStateIndex, @Nullable CrossRepositoryMergeRequestSourceBranch crossRepositorySourceBranch) throws StorageException {
        Optional<CommitDescriptor> commit = repositoryRevisionIndex.getFirstProcessedCommit(mergeRequest.sourceHead);
        if (commit.isEmpty()) {
            LOGGER.debug("No processed commit found for merge request {}. ", (Object)mergeRequest.identifier);
            return Optional.empty();
        }
        CommitDescriptor commitDescriptor = commit.get();
        if (!MergeRequestUtils.isCommitOnCorrectBranch(mergeRequest, crossRepositorySourceBranch, commitDescriptor)) {
            LOGGER.debug("Commit {} is not on the correct branch for merge request {}", (Object)commitDescriptor, (Object)mergeRequest.identifier);
            return Optional.empty();
        }
        AnalysisState analysisState = branchAnalysisStateIndex.getAnalysisState(commitDescriptor.getBranchName());
        if (analysisState == null) {
            LogManager.getLogger().error("Analysis state is null for " + String.valueOf(commit) + ". Skipping further processing of merge request: " + mergeRequest.getId() + ".");
            return Optional.empty();
        }
        if (analysisState.getState() != EAnalysisState.LIVE_ANALYSIS) {
            LOGGER.debug("Analysis state of source branch {} of merge request {} is not LIVE (is: {}).", (Object)commitDescriptor.getBranchName(), (Object)mergeRequest.identifier, (Object)analysisState.getState());
            return Optional.empty();
        }
        return commit;
    }

    private static boolean isCommitOnCorrectBranch(MergeRequest mergeRequest, @Nullable CrossRepositoryMergeRequestSourceBranch crossRepositorySourceBranch, CommitDescriptor commitDescriptor) {
        if (crossRepositorySourceBranch != null) {
            return commitDescriptor.getBranchName().equals(crossRepositorySourceBranch.localBranchName());
        }
        return commitDescriptor.getBranchName().equals(mergeRequest.sourceBranch);
    }

    public static List<String> getMatchingConnectorIdentifiersFromProject(ProjectStorageSystem projectStorageSystem, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        String mergeRequestRepositoryIdentOrName = mergeRequestIdentifier.repositoryName;
        return MergeRequestUtils.getMatchingConnectorIdentifiersForRepositoryIdOrName(projectStorageSystem, mergeRequestRepositoryIdentOrName);
    }

    private static @NonNull List<String> getMatchingConnectorIdentifiersForRepositoryIdOrName(ProjectStorageSystem projectStorageSystem, String mergeRequestRepositoryIdentOrName) throws StorageException {
        return Objects.requireNonNull(ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem), "Missing project configuration.").getConnectors().stream().filter(connector -> MergeRequestUtils.connectorHasRepositoryNameOrId(connector, mergeRequestRepositoryIdentOrName)).map(ConnectorConfiguration::getIdentifier).toList();
    }

    public static Optional<ConnectorConfiguration> guessConnectorFromProject(IndexLayer indexLayer, IProjectId projectId, String repositoryName) throws StorageException {
        return MergeRequestUtils.guessConnectorFromProject(indexLayer, projectId, repositoryName, Collections.emptyList());
    }

    public static Optional<ConnectorConfiguration> guessConnectorFromProject(@NonNull IndexLayer indexLayer, IProjectId projectId, String repositoryNameOrId, List<Predicate<ConnectorConfiguration>> additionalFilters) throws StorageException {
        try {
            ConfigurationInitializationContext context = new ConfigurationInitializationContext(null, indexLayer, (IExternalCredentialsProvider)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
            ProjectConfiguration projectConfiguration = Objects.requireNonNull(ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)indexLayer), "No project configuration exists for project '%s'.".formatted(projectId));
            return ConnectorUtils.getSourceCodeRepositoryConnectors((ProjectConfiguration)projectConfiguration, (ConfigurationInitializationContext)context).stream().filter(connector -> MergeRequestUtils.connectorHasRepositoryNameOrId(connector, repositoryNameOrId)).filter(additionalFilters.stream().reduce(connector -> true, Predicate::and)).findFirst();
        }
        catch (StorageException e) {
            throw new StorageException("Error while opening indexes to get connector for repository name '" + repositoryNameOrId + "'.", (Throwable)e);
        }
    }

    private static boolean connectorHasRepositoryNameOrId(ConnectorConfiguration connector, String repositoryNameOrId) {
        return repositoryNameOrId.equalsIgnoreCase(connector.getOptionValue("Repository name")) || repositoryNameOrId.equalsIgnoreCase(connector.getOptionValue("Repository identifier"));
    }

    private MergeRequestUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

