/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.comments.cluster;

import com.google.common.base.Preconditions;
import com.teamscale.index.merge_request.comments.cluster.EFindingClusterType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.lib.commons.collections.CollectionUtils;

public class FindingCluster {
    private final EFindingClusterType findingClusterType;
    private final Set<TrackedFinding> findings = new HashSet<TrackedFinding>();

    public FindingCluster(EFindingClusterType findingClusterType) {
        this.findingClusterType = findingClusterType;
    }

    public FindingCluster(EFindingClusterType findingClusterType, TrackedFinding ... trackedFindings) {
        this(findingClusterType, Arrays.asList(trackedFindings));
    }

    public FindingCluster(EFindingClusterType findingClusterType, Collection<TrackedFinding> trackedFindings) {
        this(findingClusterType);
        Preconditions.checkArgument((trackedFindings.size() > 0 ? 1 : 0) != 0, (Object)"FindingsCluster must contain at least one TrackedFinding");
        this.findings.addAll(trackedFindings);
    }

    public Set<TrackedFinding> getFindings() {
        return CollectionUtils.asUnmodifiable(this.findings);
    }

    public EFindingClusterType getFindingClusterType() {
        return this.findingClusterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindingCluster that = (FindingCluster)o;
        return this.findingClusterType == that.findingClusterType && Objects.equals(this.findings, that.findings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.findingClusterType, this.findings});
    }

    public String toString() {
        return "FindingCluster{findingClusterType=" + String.valueOf((Object)this.findingClusterType) + ", findingIds=" + String.valueOf(this.findings) + "}";
    }
}

