/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request.metrics;

import com.teamscale.commons.links.TeamscaleLinkProvider;
import com.teamscale.index.merge_request.metrics.IMergeRequestMetricEvaluationResult;
import com.teamscale.index.merge_request.metrics.IMergeRequestMetricGroupEvaluationResult;
import com.teamscale.index.merge_request.metrics.IMergeRequestSingleMetricAssessmentEvaluationResult;
import com.teamscale.index.merge_request.metrics.MergeRequestEvaluatedSingleMetricAssessment;
import com.teamscale.index.merge_request.metrics.MergeRequestSingleMetricAssessmentError;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.string.StringUtils;

public record MergeRequestEvaluatedMetricGroup(String groupName, boolean increasingValuesIndicateImprovement, List<IMergeRequestSingleMetricAssessmentEvaluationResult> metricsWithoutData, List<IMergeRequestSingleMetricAssessmentEvaluationResult> deterioratedMetrics, List<IMergeRequestSingleMetricAssessmentEvaluationResult> stableMetrics, List<IMergeRequestSingleMetricAssessmentEvaluationResult> improvedMetrics, List<IMergeRequestSingleMetricAssessmentEvaluationResult> metricsWithNewThresholdViolations) implements IMergeRequestMetricGroupEvaluationResult
{
    private static final String METRICS_DELIMITER = "&#10;- ";
    private static final int MAX_METRIC_COUNT = 10;

    @Override
    public String getTextDescription() {
        StringBuilder builder = new StringBuilder("Metric group '" + this.groupName + "':");
        if (!this.metricsWithoutData.isEmpty()) {
            builder.append("&#10;&#10;").append(this.metricsWithoutData.size()).append(StringUtils.pluralize((String)" metric", (int)this.metricsWithoutData.size())).append(" with error or missing data:&#10;");
            MergeRequestEvaluatedMetricGroup.appendMetricDetails(builder, this.metricsWithoutData, IMergeRequestMetricEvaluationResult::getName);
        }
        String deterioratedCategoryName = this.increasingValuesIndicateImprovement ? "decreased metric" : "increased metric";
        String improvedCategoryName = this.increasingValuesIndicateImprovement ? "increased metric" : "decreased metric";
        MergeRequestEvaluatedMetricGroup.appendMetricChangeCategory(builder, deterioratedCategoryName, this.deterioratedMetrics, MergeRequestEvaluatedMetricGroup::getFormattedMetricNameValueAndDelta);
        MergeRequestEvaluatedMetricGroup.appendMetricChangeCategory(builder, "stable metric", this.stableMetrics, MergeRequestEvaluatedMetricGroup::getFormattedMetricNameAndValue);
        MergeRequestEvaluatedMetricGroup.appendMetricChangeCategory(builder, improvedCategoryName, this.improvedMetrics, MergeRequestEvaluatedMetricGroup::getFormattedMetricNameValueAndDelta);
        MergeRequestEvaluatedMetricGroup.appendMetricChangeCategory(builder, "new threshold violation", this.metricsWithNewThresholdViolations, MergeRequestEvaluatedMetricGroup::getFormattedMetricNameValueDeltaAndThreshold);
        return builder.toString();
    }

    private static void appendMetricChangeCategory(StringBuilder builder, String categoryName, List<IMergeRequestSingleMetricAssessmentEvaluationResult> metrics, Function<IMergeRequestSingleMetricAssessmentEvaluationResult, String> evaluationResultStringifier) {
        if (metrics.isEmpty()) {
            return;
        }
        builder.append("&#10;&#10;").append(metrics.size()).append(" ").append(StringUtils.pluralize((String)categoryName, (int)metrics.size())).append(":&#10;");
        MergeRequestEvaluatedMetricGroup.appendMetricDetails(builder, metrics, evaluationResultStringifier);
    }

    private static void appendMetricDetails(StringBuilder builder, List<IMergeRequestSingleMetricAssessmentEvaluationResult> metrics, Function<IMergeRequestSingleMetricAssessmentEvaluationResult, String> evaluationResultStringifier) {
        List metricsToShow = metrics.stream().sorted(MergeRequestEvaluatedMetricGroup::compareMetrics).limit(10L).toList();
        builder.append(metricsToShow.stream().map(evaluationResultStringifier).collect(Collectors.joining(METRICS_DELIMITER, "- ", "")));
        int overflowMetricCount = metrics.size() - 10;
        if (overflowMetricCount > 0) {
            builder.append("&#10;- ... ").append(overflowMetricCount).append(" more ").append(StringUtils.pluralize((String)"metric", (int)overflowMetricCount));
        }
    }

    private static String getFormattedMetricNameValueAndDelta(IMergeRequestSingleMetricAssessmentEvaluationResult metricEvaluationResult) {
        return "%s (%s)".formatted(MergeRequestEvaluatedMetricGroup.getFormattedMetricNameAndValue(metricEvaluationResult), metricEvaluationResult.getFormattedMetricDelta().orElse("N/A"));
    }

    private static String getFormattedMetricNameAndValue(IMergeRequestSingleMetricAssessmentEvaluationResult metricEvaluationResult) {
        return "%s: %s".formatted(metricEvaluationResult.getName(), metricEvaluationResult.getFormattedMetricValue().orElse("N/A"));
    }

    private static String getFormattedMetricNameValueDeltaAndThreshold(IMergeRequestSingleMetricAssessmentEvaluationResult metricEvaluationResult) {
        return "%s, threshold: %s".formatted(MergeRequestEvaluatedMetricGroup.getFormattedMetricNameValueAndDelta(metricEvaluationResult), metricEvaluationResult.getFormattedMetricThreshold().orElse("N/A"));
    }

    @Override
    public String getBadgeLink(TeamscaleLinkProvider linkProvider, @Nullable String incompleteBuildWarningText) {
        return linkProvider.createStaticMetricGroupBadgeUrl(this.groupName, this.increasingValuesIndicateImprovement, this.metricsWithoutData.size(), this.deterioratedMetrics.size(), this.stableMetrics.size(), this.improvedMetrics.size(), this.metricsWithNewThresholdViolations.size(), incompleteBuildWarningText);
    }

    @Override
    public String getName() {
        return this.groupName;
    }

    @Override
    public Set<IMergeRequestSingleMetricAssessmentEvaluationResult> getIndividualMetricEvaluationResults() {
        HashSet<IMergeRequestSingleMetricAssessmentEvaluationResult> result = new HashSet<IMergeRequestSingleMetricAssessmentEvaluationResult>();
        result.addAll(this.metricsWithoutData);
        result.addAll(this.deterioratedMetrics);
        result.addAll(this.stableMetrics);
        result.addAll(this.improvedMetrics);
        result.addAll(this.metricsWithNewThresholdViolations);
        return result;
    }

    private static int compareMetrics(IMergeRequestSingleMetricAssessmentEvaluationResult metric1, IMergeRequestSingleMetricAssessmentEvaluationResult metric2) {
        if (metric1 instanceof MergeRequestSingleMetricAssessmentError) {
            if (metric2 instanceof MergeRequestSingleMetricAssessmentError) {
                return metric1.getName().compareToIgnoreCase(metric2.getName());
            }
            return 1;
        }
        if (metric2 instanceof MergeRequestSingleMetricAssessmentError) {
            return -1;
        }
        int deltaCompare = MergeRequestEvaluatedMetricGroup.compareMetricDelta((MergeRequestEvaluatedSingleMetricAssessment)metric1, (MergeRequestEvaluatedSingleMetricAssessment)metric2);
        if (deltaCompare != 0) {
            return deltaCompare;
        }
        int valueCompare = MergeRequestEvaluatedMetricGroup.compareMetricValue((MergeRequestEvaluatedSingleMetricAssessment)metric1, (MergeRequestEvaluatedSingleMetricAssessment)metric2);
        if (valueCompare != 0) {
            return valueCompare;
        }
        return metric1.getName().compareToIgnoreCase(metric2.getName());
    }

    private static int compareMetricDelta(MergeRequestEvaluatedSingleMetricAssessment metric1, MergeRequestEvaluatedSingleMetricAssessment metric2) {
        Optional<Double> delta1 = metric1.getAbsoluteDelta();
        Optional<Double> delta2 = metric2.getAbsoluteDelta();
        return MergeRequestEvaluatedMetricGroup.compareOptionals(delta1, delta2);
    }

    private static int compareMetricValue(MergeRequestEvaluatedSingleMetricAssessment metric1, MergeRequestEvaluatedSingleMetricAssessment metric2) {
        Optional<Double> value1 = metric1.getNumericValue();
        Optional<Double> value2 = metric2.getNumericValue();
        return MergeRequestEvaluatedMetricGroup.compareOptionals(value1, value2);
    }

    private static int compareOptionals(Optional<Double> value1, Optional<Double> value2) {
        if (value1.isPresent() && value2.isPresent()) {
            return value2.get().compareTo(value1.get());
        }
        if (value1.isPresent()) {
            return -1;
        }
        if (value2.isPresent()) {
            return 1;
        }
        return 0;
    }
}

