/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.computation;

import com.teamscale.core.analysis.configuration.index.model.EThresholdEvaluationOption;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.TrendDelta;
import com.teamscale.index.metrics.assessment.computation.MetricComputationBase;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.AssessmentUtils;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class AssessmentMetricComputation
extends MetricComputationBase<Assessment> {
    public AssessmentMetricComputation(MetricDirectorySchemaEntry schemaEntry) {
        super(schemaEntry);
    }

    @Override
    public ETrend execComputeTrend(EvaluatedMetricThreshold threshold, Assessment currentValue, Assessment baselineValue) {
        int comparisonResult = AssessmentUtils.compareAssessments((Assessment)baselineValue, (Assessment)currentValue);
        return ETrend.fromValueComparison(comparisonResult);
    }

    @Override
    protected TrendDelta execComputeTrendDelta(Assessment currentValue, Assessment baselineValue) {
        return TrendDelta.calculateAndFormatDelta(baselineValue, currentValue);
    }

    @Override
    protected ETrafficLightColor execComputeMetricRating(EvaluatedMetricThreshold threshold, IMetricValue<?> metricValue) {
        double ratioRed = metricValue.getValueAsDoubleForRating(ETrafficLightColor.RED).orElse(0.0);
        double ratioYellow = metricValue.getValueAsDoubleForRating(ETrafficLightColor.YELLOW).orElse(0.0);
        return this.getRatingColor(threshold, ratioYellow, ratioRed);
    }

    @Override
    protected ETrafficLightColor getRatingColor(EvaluatedMetricThreshold threshold, double valueForComparisonWithYellowThreshold, double valueForComparisonWithRedThreshold) {
        ETrafficLightColor ratingColor = super.getRatingColor(threshold, valueForComparisonWithYellowThreshold, valueForComparisonWithRedThreshold);
        if (this.isEvaluationOptionSet((MetricThresholdBase)threshold, EThresholdEvaluationOption.ASSESSMENT_METRIC_RED_IF_ANY_THRESHOLD_VIOLATED) && ratingColor == ETrafficLightColor.YELLOW) {
            return ETrafficLightColor.RED;
        }
        return ratingColor;
    }
}

