/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.threshold;

import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.metrics.MetricNames;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public final class MetricThresholdConfigurationDefaults {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String TEAMSCALE_DEFAULT_CONFIGURATION_NAME = "Teamscale Default";
    public static final String PROJECT_DEFAULT_THRESHOLD_CONFIGURATION_NAME = "Project Default";
    private static final String METRICS_GROUP_DEFAULT_NAME = "Default Metrics";
    private static final String NONCODE_THRESHOLD_CONFIGURATION_NAME = "Non Code Default";
    private static final String ISSUE_THRESHOLD_CONFIGURATION_NAME = "Issue Default";
    private static final String SPEC_ITEM_THRESHOLD_CONFIGURATION_NAME = "Specification Item Default";
    private static final String TEST_QUERY_THRESHOLD_CONFIGURATION_NAME = "Test Query Default";
    private static final String TEST_IMPLEMENTATION_THRESHOLD_CONFIGURATION_NAME = "Test Implementation Default";
    private static final String TEST_EXECUTION_THRESHOLD_CONFIGURATION_NAME = "Test Execution Default";
    public static final List<String> DEFAULT_THRESHOLD_CONFIGURATION_NAMES = List.of("Teamscale Default", "Project Default", "Non Code Default", "Issue Default", "Specification Item Default", "Test Query Default", "Test Implementation Default", "Test Execution Default");
    private static final Set<String> DEFAULT_CONFIGURATION_METRICS = new HashSet<String>();
    private static final Set<String> DEFAULT_NONCODE_CONFIGURATION_METRICS = new HashSet<String>();
    private static final Set<String> DEFAULT_ISSUE_CONFIGURATION_METRICS = new HashSet<String>();
    private static final Set<String> DEFAULT_TEST_QUERY_CONFIGURATION_METRICS = new HashSet<String>();
    private static final Set<String> DEFAULT_TEST_IMPLEMENTATION_CONFIGURATION_METRICS = new HashSet<String>();
    private static final Set<String> DEFAULT_TEST_EXECUTION_CONFIGURATION_METRICS = new HashSet<String>();
    private static final Set<String> DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS = new HashSet<String>();
    private static final Map<String, Double> DEFAULT_THRESHOLD_YELLOW_VALUES = new HashMap<String, Double>();
    private static final Map<String, Double> DEFAULT_THRESHOLD_RED_VALUES = new HashMap<String, Double>();
    private static final Double DEFAULT_FAILED_TESTS_THRESHOLD_VALUE = 0.0;
    private static final Double DEFAULT_SKIPPED_TESTS_THRESHOLD_VALUE = 0.0;

    private static void initializeMetricsOfDefaultConfiguration() {
        DEFAULT_CONFIGURATION_METRICS.add("Files");
        DEFAULT_CONFIGURATION_METRICS.add("Lines of Code");
        DEFAULT_CONFIGURATION_METRICS.add("Source Lines of Code");
        DEFAULT_CONFIGURATION_METRICS.add("File Size Assessment");
        DEFAULT_CONFIGURATION_METRICS.add("Method Length Assessment");
        DEFAULT_CONFIGURATION_METRICS.add("Longest Method Length");
        DEFAULT_CONFIGURATION_METRICS.add("Nesting Depth Assessment");
        DEFAULT_CONFIGURATION_METRICS.add("Last Change Date");
        DEFAULT_CONFIGURATION_METRICS.add(MetricNames.FINDINGS_COUNT.getName());
        DEFAULT_CONFIGURATION_METRICS.add(MetricNames.FINDINGS_DENSITY.getName());
        DEFAULT_CONFIGURATION_METRICS.add("Clone Coverage");
        DEFAULT_CONFIGURATION_METRICS.add("Comment Completeness Assessment");
    }

    private static void initializeDefaultNonCodeConfiguration() {
        DEFAULT_NONCODE_CONFIGURATION_METRICS.add("Count");
        DEFAULT_NONCODE_CONFIGURATION_METRICS.add("Assessment");
        DEFAULT_NONCODE_CONFIGURATION_METRICS.add("Execution Time");
    }

    private static void initializeDefaultIssueConfiguration() {
        DEFAULT_ISSUE_CONFIGURATION_METRICS.add("Issues");
    }

    private static void initializeDefaultSpecItemConfiguration() {
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add("Spec Items");
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add("Test Reference Count");
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add("Spec Item Coverage");
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add("Code Reference Count");
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add("Code Reference Coverage");
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add("Spec Item Size");
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add("Last Change Date");
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add(MetricNames.FINDINGS_COUNT.getName());
        DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS.add(MetricNames.SPEC_ITEM_FINDINGS_DENSITY.getName());
    }

    private static void initializeDefaultTestConfiguration() {
        DEFAULT_TEST_IMPLEMENTATION_CONFIGURATION_METRICS.add("Count");
        DEFAULT_TEST_IMPLEMENTATION_CONFIGURATION_METRICS.add("Result");
        DEFAULT_TEST_IMPLEMENTATION_CONFIGURATION_METRICS.add("Duration");
        DEFAULT_TEST_IMPLEMENTATION_CONFIGURATION_METRICS.add("Failed");
        DEFAULT_TEST_IMPLEMENTATION_CONFIGURATION_METRICS.add("Skipped/Ignored");
    }

    private static void initializeDefaultTestExecutionConfiguration() {
        DEFAULT_TEST_EXECUTION_CONFIGURATION_METRICS.add("Count");
        DEFAULT_TEST_EXECUTION_CONFIGURATION_METRICS.add("Result");
        DEFAULT_TEST_EXECUTION_CONFIGURATION_METRICS.add("Duration");
        DEFAULT_TEST_EXECUTION_CONFIGURATION_METRICS.add("Failed");
        DEFAULT_TEST_EXECUTION_CONFIGURATION_METRICS.add("Skipped/Ignored");
    }

    private static void initializeDefaultTestQueryConfiguration() {
        DEFAULT_TEST_QUERY_CONFIGURATION_METRICS.add("Tests");
    }

    private static void initializeDefaultThresholdValues() {
        MetricThresholdConfigurationDefaults.setDefaultThresholdValue("File Size Assessment", 0.25, 0.05);
        MetricThresholdConfigurationDefaults.setDefaultThresholdValue("Method Length Assessment", 0.25, 0.05);
        MetricThresholdConfigurationDefaults.setDefaultThresholdValue("Nesting Depth Assessment", 0.25, 0.05);
        MetricThresholdConfigurationDefaults.setDefaultThresholdValue("Clone Coverage", 0.05, 0.1);
        MetricThresholdConfigurationDefaults.setDefaultThresholdValue("Comment Completeness Assessment", 0.5, 0.5);
    }

    private static void setDefaultThresholdValue(String metricName, Double thresholdYellow, Double thresholdRed) {
        DEFAULT_THRESHOLD_YELLOW_VALUES.put(metricName, thresholdYellow);
        DEFAULT_THRESHOLD_RED_VALUES.put(metricName, thresholdRed);
    }

    public static boolean isBuiltInThresholdConfiguration(String thresholdConfigurationName) {
        return MetricThresholdConfigurationDefaults.isProjectDefaultConfiguration(thresholdConfigurationName) || MetricThresholdConfigurationDefaults.isDefaultTeamscaleConfiguration(thresholdConfigurationName);
    }

    public static boolean isProjectDefaultConfiguration(String thresholdConfigurationName) {
        return PROJECT_DEFAULT_THRESHOLD_CONFIGURATION_NAME.equals(thresholdConfigurationName);
    }

    private static boolean isDefaultTeamscaleConfiguration(String thresholdConfigurationName) {
        return StringUtils.isEmpty((String)thresholdConfigurationName) || Set.copyOf(DEFAULT_THRESHOLD_CONFIGURATION_NAMES).contains(thresholdConfigurationName);
    }

    public static MetricThresholdConfiguration createTeamscaleDefaultConfiguration(MetricDirectorySchema schema, String thresholdConfigurationName) {
        if (StringUtils.isEmpty((String)thresholdConfigurationName) || TEAMSCALE_DEFAULT_CONFIGURATION_NAME.equals(thresholdConfigurationName)) {
            return MetricThresholdConfigurationDefaults.createTeamscaleDefaultConfiguration(schema);
        }
        return switch (thresholdConfigurationName) {
            case NONCODE_THRESHOLD_CONFIGURATION_NAME -> MetricThresholdConfigurationDefaults.createNonCodeConfiguration();
            case ISSUE_THRESHOLD_CONFIGURATION_NAME -> MetricThresholdConfigurationDefaults.createIssueConfiguration();
            case TEST_IMPLEMENTATION_THRESHOLD_CONFIGURATION_NAME -> MetricThresholdConfigurationDefaults.createTestImplementationConfiguration();
            case TEST_EXECUTION_THRESHOLD_CONFIGURATION_NAME -> MetricThresholdConfigurationDefaults.createTestExecutionConfiguration();
            case SPEC_ITEM_THRESHOLD_CONFIGURATION_NAME -> MetricThresholdConfigurationDefaults.createSpecItemConfiguration();
            case TEST_QUERY_THRESHOLD_CONFIGURATION_NAME -> MetricThresholdConfigurationDefaults.createTestQueryConfiguration();
            default -> throw new IllegalArgumentException("Not a built-in configuration");
        };
    }

    private static MetricThresholdConfiguration createTeamscaleDefaultConfiguration(MetricDirectorySchema schema) {
        MetricThresholdConfiguration configuration = new MetricThresholdConfiguration(TEAMSCALE_DEFAULT_CONFIGURATION_NAME);
        MetricThresholdGroup metricThresholdGroup = MetricThresholdConfigurationDefaults.createDefaultThresholdGroup(schema, DEFAULT_CONFIGURATION_METRICS::contains);
        configuration.addMetricThresholdGroup(metricThresholdGroup);
        MetricThresholdConfigurationDefaults.addDefaultThresholds(metricThresholdGroup);
        return configuration;
    }

    private static MetricThresholdConfiguration createNonCodeConfiguration() {
        return MetricThresholdConfigurationDefaults.createTypeSpecificConfiguration("non-code", DEFAULT_NONCODE_CONFIGURATION_METRICS, EMetricSchemaSource.NON_CODE_METRICS, UniformPath.EType.NON_CODE, NONCODE_THRESHOLD_CONFIGURATION_NAME);
    }

    private static MetricThresholdConfiguration createIssueConfiguration() {
        return MetricThresholdConfigurationDefaults.createTypeSpecificConfiguration("issue", DEFAULT_ISSUE_CONFIGURATION_METRICS, EMetricSchemaSource.ISSUE_METRICS, UniformPath.EType.ISSUE_QUERY, ISSUE_THRESHOLD_CONFIGURATION_NAME);
    }

    private static MetricThresholdConfiguration createSpecItemConfiguration() {
        return MetricThresholdConfigurationDefaults.createTypeSpecificConfiguration("spec item", DEFAULT_SPEC_ITEM_CONFIGURATION_METRICS, EMetricSchemaSource.SPEC_ITEM_METRICS, UniformPath.EType.SPEC_ITEM_QUERY, SPEC_ITEM_THRESHOLD_CONFIGURATION_NAME);
    }

    private static MetricThresholdConfiguration createTestQueryConfiguration() {
        return MetricThresholdConfigurationDefaults.createTypeSpecificConfiguration("test query", DEFAULT_TEST_QUERY_CONFIGURATION_METRICS, EMetricSchemaSource.TEST_QUERY_METRICS, UniformPath.EType.TEST_QUERY, TEST_QUERY_THRESHOLD_CONFIGURATION_NAME);
    }

    private static MetricThresholdConfiguration createTestImplementationConfiguration() {
        MetricThresholdConfiguration config = MetricThresholdConfigurationDefaults.createTypeSpecificConfiguration("test implementation", DEFAULT_TEST_IMPLEMENTATION_CONFIGURATION_METRICS, EMetricSchemaSource.TEST_IMPLEMENTATION_METRICS, UniformPath.EType.TEST_IMPLEMENTATION, TEST_IMPLEMENTATION_THRESHOLD_CONFIGURATION_NAME);
        MetricThresholdConfigurationDefaults.addTestThresholdMetrics(config);
        return config;
    }

    private static MetricThresholdConfiguration createTestExecutionConfiguration() {
        MetricThresholdConfiguration config = MetricThresholdConfigurationDefaults.createTypeSpecificConfiguration("test execution", DEFAULT_TEST_EXECUTION_CONFIGURATION_METRICS, EMetricSchemaSource.TEST_EXECUTION_METRICS, UniformPath.EType.TEST_EXECUTION, TEST_EXECUTION_THRESHOLD_CONFIGURATION_NAME);
        MetricThresholdConfigurationDefaults.addTestThresholdMetrics(config);
        return config;
    }

    private static MetricThresholdConfiguration createTypeSpecificConfiguration(String metricConfiguration, Set<String> configurationMetrics, EMetricSchemaSource source, UniformPath.EType uniformPathType, String thresholdConfigurationName) {
        MetricThresholdGroup metricThresholdGroup = MetricThresholdConfigurationDefaults.createThresholdGroup(metricConfiguration, configurationMetrics, source);
        metricThresholdGroup.getMetricThresholdList().forEach(threshold -> threshold.setSubPath(uniformPathType.getPrefix()));
        return new MetricThresholdConfiguration(thresholdConfigurationName, Collections.singletonList(metricThresholdGroup));
    }

    private static void addDefaultThresholds(MetricThresholdGroup metricThresholdGroup) {
        for (MetricThreshold metricThreshold : metricThresholdGroup.getMetricThresholdList()) {
            String metricName = metricThreshold.getMetricName();
            metricThreshold.setThresholdYellow(DEFAULT_THRESHOLD_YELLOW_VALUES.get(metricName));
            metricThreshold.setThresholdRed(DEFAULT_THRESHOLD_RED_VALUES.get(metricName));
        }
    }

    private static MetricThresholdGroup createDefaultThresholdGroup(MetricDirectorySchema schema, Predicate<String> filter) {
        MetricThresholdGroup metricThresholdGroup = new MetricThresholdGroup(METRICS_GROUP_DEFAULT_NAME);
        for (MetricDirectorySchemaEntry entry : schema.getAllEntries()) {
            String metricName = entry.getName();
            if (!filter.test(metricName)) continue;
            MetricThreshold metricThreshold = new MetricThreshold(metricName);
            try {
                metricThresholdGroup.addMetricThreshold(metricThreshold);
            }
            catch (MetricThresholdConfigurationException e) {
                LOGGER.error("Metric threshold " + metricName + " was not added to the default group because of: " + e.getMessage());
            }
        }
        return metricThresholdGroup;
    }

    private static MetricThresholdGroup createThresholdGroup(String metricConfiguration, Set<String> metricNames, EMetricSchemaSource schemaSource) {
        MetricThresholdGroup metricThresholdGroup = new MetricThresholdGroup(METRICS_GROUP_DEFAULT_NAME);
        for (String metricName : metricNames) {
            MetricThreshold metricThreshold = new MetricThreshold(metricName);
            metricThreshold.setMetricSchemaSource(schemaSource);
            try {
                metricThresholdGroup.addMetricThreshold(metricThreshold);
            }
            catch (MetricThresholdConfigurationException e) {
                LOGGER.error("Metric threshold " + metricName + " was not added to the default group (of " + metricConfiguration + " metrics) because of: " + e.getMessage());
            }
        }
        CCSMAssert.isNotEmpty((Collection)metricThresholdGroup.getMetricThresholdList(), (String)("The default " + metricConfiguration + " metric threshold group must have at least one metric threshold"));
        return metricThresholdGroup;
    }

    private static void addTestThresholdMetrics(MetricThresholdConfiguration config) {
        try {
            Optional failedTestsMetric = config.findThreshold(METRICS_GROUP_DEFAULT_NAME, "Failed");
            failedTestsMetric.ifPresent(metricThreshold -> metricThreshold.setThresholdRed(DEFAULT_FAILED_TESTS_THRESHOLD_VALUE));
            Optional skippedTestsMetric = config.findThreshold(METRICS_GROUP_DEFAULT_NAME, "Skipped/Ignored");
            skippedTestsMetric.ifPresent(metricThreshold -> metricThreshold.setThresholdYellow(DEFAULT_SKIPPED_TESTS_THRESHOLD_VALUE));
        }
        catch (MetricThresholdConfigurationException e) {
            LOGGER.error("Could not add test threshold metrics to {}: {}", (Object)config.getName(), (Object)e.getMessage());
        }
    }

    static {
        MetricThresholdConfigurationDefaults.initializeMetricsOfDefaultConfiguration();
        MetricThresholdConfigurationDefaults.initializeDefaultThresholdValues();
        MetricThresholdConfigurationDefaults.initializeDefaultNonCodeConfiguration();
        MetricThresholdConfigurationDefaults.initializeDefaultIssueConfiguration();
        MetricThresholdConfigurationDefaults.initializeDefaultSpecItemConfiguration();
        MetricThresholdConfigurationDefaults.initializeDefaultTestQueryConfiguration();
        MetricThresholdConfigurationDefaults.initializeDefaultTestConfiguration();
        MetricThresholdConfigurationDefaults.initializeDefaultTestExecutionConfiguration();
    }
}

