/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.migration.ProjectConfigurationHolder;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;

public class ProjectVersion35BitbucketServerMergeRequestAnnotationMechanism {
    private static final String BITBUCKET_SERVER_CONNECTOR_TYPE = "Bitbucket Server (On-Premise)";
    private static final String INLINE_COMMENTS_VIA_PULL_REQUEST_COMMENTS = "Add Detailed Line Comments For Findings as Pull Request Comments";
    private static final boolean INLINE_COMMENTS_VIA_PULL_REQUEST_COMMENTS_DEFAULT = false;
    private static final String INLINE_COMMENTS_VIA_CODE_INSIGHTS_REPORT = "Add Detailed Line Comments For Findings as Code Insights Report";
    private static final boolean INLINE_COMMENTS_VIA_CODE_INSIGHTS_REPORT_DEFAULT = true;

    public static String migrate(String json) throws JsonSerializationException {
        ProjectConfigurationHolder holder = (ProjectConfigurationHolder)JsonUtils.deserializeFromJson((String)json, ProjectConfigurationHolder.class);
        holder.connectors.replaceAll(ProjectVersion35BitbucketServerMergeRequestAnnotationMechanism::migrateConnectorConfiguration);
        return JsonUtils.serializeToJSON((Object)holder);
    }

    private static ConnectorConfiguration migrateConnectorConfiguration(ConnectorConfiguration connectorConfiguration) {
        if (BITBUCKET_SERVER_CONNECTOR_TYPE.equals(connectorConfiguration.getType())) {
            connectorConfiguration.setOptionValue(INLINE_COMMENTS_VIA_PULL_REQUEST_COMMENTS, Boolean.toString(false));
            connectorConfiguration.setOptionValue(INLINE_COMMENTS_VIA_CODE_INSIGHTS_REPORT, Boolean.toString(true));
        }
        return connectorConfiguration;
    }
}

