/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v116_dashboards;

import com.teamscale.index.migration.v116_dashboards.V116EBasicPermissionScope;
import com.teamscale.index.migration.v116_dashboards.V116EBasicRole;
import com.teamscale.index.migration.v116_dashboards.V116ESubjectType;
import com.teamscale.index.migration.v116_dashboards.V116GlobalRole;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class V116SubjectRoleAssignments
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final V116ESubjectType subjectType;
    private String subjectId;
    private final Set<String> globalRoles = new HashSet<String>();
    private final Map<V116EBasicPermissionScope, Set<String>> globalInstanceRoles = new HashMap<V116EBasicPermissionScope, Set<String>>();
    private final Map<V116EBasicPermissionScope, Map<String, Set<String>>> instanceRoles = new HashMap<V116EBasicPermissionScope, Map<String, Set<String>>>();
    private final Set<String> globalProjectRoles = new HashSet<String>();
    private final Map<IProjectId, Set<String>> projectRoles = new HashMap<IProjectId, Set<String>>();

    public V116SubjectRoleAssignments(V116ESubjectType subjectType, String subjectId) {
        CCSMAssert.isNotNull((Object)((Object)subjectType));
        CCSMAssert.isNotNull((Object)subjectId);
        this.subjectType = subjectType;
        this.subjectId = subjectId;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public V116ESubjectType getSubjectType() {
        return this.subjectType;
    }

    public void addGlobalRole(V116GlobalRole globalRole) {
        this.globalRoles.add(globalRole.getReadableName());
    }

    public Set<String> getGlobalRoleNames() {
        return this.globalRoles;
    }

    public Set<String> getGlobalBasicRoles(V116EBasicPermissionScope permissionScope) {
        Set<String> rolesOnScope = this.globalInstanceRoles.get((Object)permissionScope);
        if (rolesOnScope == null) {
            rolesOnScope = new HashSet<String>();
            this.globalInstanceRoles.put(permissionScope, rolesOnScope);
        }
        return rolesOnScope;
    }

    public Map<String, Set<String>> getBasicRoles(V116EBasicPermissionScope permissionScope) {
        return Optional.ofNullable(this.instanceRoles.get((Object)permissionScope)).orElse((Map<String, Set<String>>)CollectionUtils.emptyMap());
    }

    public Set<String> getGlobalProjectRoles() {
        return this.globalProjectRoles;
    }

    public void addGlobalBasicRole(V116EBasicPermissionScope permissionScope, V116EBasicRole basicRole) {
        this.getGlobalBasicRoles(permissionScope).add(basicRole.getReadableName());
    }

    public void addBasicRole(V116EBasicPermissionScope permissionScope, String instanceId, V116EBasicRole basicRole) {
        this.getRolesForInstance(permissionScope, instanceId).add(basicRole.getReadableName());
    }

    private Set<String> getRolesForInstance(V116EBasicPermissionScope permissionScope, String instanceId) {
        return V116SubjectRoleAssignments.getNestedSetSafe(this.instanceRoles, permissionScope, instanceId);
    }

    private static Set<String> getNestedSetSafe(Map<V116EBasicPermissionScope, Map<String, Set<String>>> nestedSetMap, V116EBasicPermissionScope permissionScope, String instanceId) {
        Map setMap = nestedSetMap.computeIfAbsent(permissionScope, k -> new HashMap());
        return setMap.computeIfAbsent(instanceId, k -> new HashSet());
    }

    public boolean isEmpty() {
        return this.globalRoles.isEmpty() && this.projectRoles.isEmpty() && this.globalProjectRoles.isEmpty() && this.globalInstanceRoles.isEmpty() && this.instanceRoles.isEmpty();
    }

    public void removeGlobalRole(String roleName) {
        this.globalRoles.remove(roleName);
    }
}

