/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v48_external_analysis_result.unmigrated;

import com.teamscale.index.migration.v48_external_analysis_result.unmigrated.V48StorageKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class V48KeyDelta
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<V48StorageKey> addedOrChanged = new ArrayList<V48StorageKey>();
    private final List<V48StorageKey> deleted = new ArrayList<V48StorageKey>();

    public V48KeyDelta(Collection<V48StorageKey> addedOrChanged, Collection<V48StorageKey> deleted) {
        this.addedOrChanged.addAll(addedOrChanged);
        this.deleted.addAll(deleted);
    }

    public UnmodifiableList<V48StorageKey> getAddedOrChangedKeys() {
        return CollectionUtils.asUnmodifiable(this.addedOrChanged);
    }

    public List<String> getAddedOrChangedKeysAsStrings() {
        return V48KeyDelta.asStrings(this.addedOrChanged);
    }

    public UnmodifiableList<V48StorageKey> getDeletedKeys() {
        return CollectionUtils.asUnmodifiable(this.deleted);
    }

    public List<String> getDeletedKeysAsStrings() {
        return V48KeyDelta.asStrings(this.deleted);
    }

    public List<String> getAllKeysAsStrings() {
        return new ArrayList<String>(CollectionUtils.unionSet(this.getAddedOrChangedKeysAsStrings(), (Collection[])new Collection[]{this.getDeletedKeysAsStrings()}));
    }

    private static List<String> asStrings(List<V48StorageKey> storageKeys) {
        ArrayList<String> result = new ArrayList<String>();
        for (V48StorageKey storageKey : storageKeys) {
            result.add(storageKey.getAsString());
        }
        return result;
    }

    public boolean isEmpty() {
        return this.addedOrChanged.isEmpty() && this.deleted.isEmpty();
    }

    public int size() {
        return this.addedOrChanged.size() + this.deleted.size();
    }

    public List<V48KeyDelta> split(int maxDeltaSize) {
        if (this.size() <= maxDeltaSize) {
            return Collections.singletonList(this);
        }
        Collections.sort(this.addedOrChanged);
        Collections.sort(this.deleted);
        ArrayList<V48KeyDelta> result = new ArrayList<V48KeyDelta>();
        if (!this.addedOrChanged.isEmpty()) {
            for (Collection<V48StorageKey> sublist : V48KeyDelta.splitList(this.addedOrChanged, maxDeltaSize)) {
                result.add(new V48KeyDelta(sublist, Collections.EMPTY_LIST));
            }
        }
        if (!this.deleted.isEmpty()) {
            for (Collection<V48StorageKey> sublist : V48KeyDelta.splitList(this.deleted, maxDeltaSize)) {
                result.add(new V48KeyDelta(Collections.EMPTY_LIST, sublist));
            }
        }
        return result;
    }

    private static Collection<Collection<V48StorageKey>> splitList(List<V48StorageKey> list, int maxSize) {
        ArrayList<Collection<V48StorageKey>> result = new ArrayList<Collection<V48StorageKey>>();
        int start = 0;
        while (start < list.size()) {
            int end = Math.min(list.size(), start + maxSize);
            result.add(list.subList(start, end));
            start = end;
        }
        return result;
    }

    public String shortSummaryString() {
        return "added/changed: " + this.addedOrChanged.size() + ", deleted: " + this.deleted.size();
    }

    public String toString() {
        return "added/changed: " + String.valueOf(this.addedOrChanged) + ", deleted: " + String.valueOf(this.deleted);
    }

    public static V48KeyDelta fromStrings(Collection<String> addedOrChanged, Collection<String> deleted) {
        return new V48KeyDelta(V48KeyDelta.convertToStorageKeys(addedOrChanged), V48KeyDelta.convertToStorageKeys(deleted));
    }

    private static Collection<V48StorageKey> convertToStorageKeys(Collection<String> paths) {
        ArrayList<V48StorageKey> storageKeys = new ArrayList<V48StorageKey>();
        for (String path : paths) {
            storageKeys.add(new V48StorageKey(path));
        }
        return storageKeys;
    }

    public static V48KeyDelta mergeDeltas(V48KeyDelta ... deltas) {
        return V48KeyDelta.mergeDeltas(Arrays.asList(deltas));
    }

    public static V48KeyDelta mergeDeltas(List<V48KeyDelta> deltas) {
        HashSet<V48StorageKey> addedOrChanged = new HashSet<V48StorageKey>();
        HashSet<V48StorageKey> deleted = new HashSet<V48StorageKey>();
        for (V48KeyDelta delta : deltas) {
            addedOrChanged.addAll(delta.addedOrChanged);
            deleted.addAll(delta.deleted);
        }
        deleted.removeAll(addedOrChanged);
        return new V48KeyDelta(addedOrChanged, deleted);
    }
}

