/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v78_multifilerangecoverage.migrated;

import com.teamscale.commons.utils.StringPool;
import com.teamscale.index.migration.v66_multifilerangecoverage.unmigrated.V66IntList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MigratedV78MultiFileRangeCoverageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, V66IntList> uniformPathToRanges;
    private long timestamp;

    public MigratedV78MultiFileRangeCoverageInfo(long timestamp, Map<String, V66IntList> uniformPathToRanges) {
        this.timestamp = timestamp;
        this.uniformPathToRanges = uniformPathToRanges;
    }

    private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
        this.timestamp = inputStream.readLong();
        this.uniformPathToRanges = new HashMap<String, V66IntList>();
        int entries = inputStream.readInt();
        for (int i = 0; i < entries; ++i) {
            String path = StringPool.intern((String)inputStream.readUTF());
            V66IntList list = (V66IntList)inputStream.readObject();
            this.uniformPathToRanges.put(path, list);
        }
    }

    private void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.writeLong(this.timestamp);
        outputStream.writeInt(this.uniformPathToRanges.size());
        for (Map.Entry<String, V66IntList> entry : this.uniformPathToRanges.entrySet()) {
            outputStream.writeUTF(entry.getKey());
            outputStream.writeObject(entry.getValue());
        }
    }
}

