/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.index.naming.ENamingConventionTokenClass;
import com.teamscale.index.naming.NamingConventionAnalyzer;
import com.teamscale.index.naming.NamingConventionGroup;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;

public class CsNamingConventionAnalyzer
extends NamingConventionAnalyzer {
    private static final Set<String> EXCLUDED_METHOD_SUBTYPES = Set.of("get", "set", "init", "empty get", "empty set", "empty init");

    public CsNamingConventionAnalyzer() {
        super(ELanguage.CS);
    }

    @Override
    protected Set<String> getExcludedMethodSubTypes() {
        return EXCLUDED_METHOD_SUBTYPES;
    }

    @Override
    protected void checkAttribute(TokenElementInfo element, ShallowEntity entity) {
        if (entity.getSubtype().equals("property") || entity.getSubtype().equals("event")) {
            String simpleName = StringUtils.getLastPart((String)entity.getName(), (String)".");
            this.checkEntityWithGivenName(element, entity, simpleName, NamingConventionGroup.create(this.language, ENamingConventionTokenClass.METHODS));
        } else {
            super.checkAttribute(element, entity);
        }
    }
}

