/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.precommit;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.CommitTreeNode;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.IChangeRetrieverCommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.index.external.update.ExternalUploadChangeRetrieverBase;
import com.teamscale.index.precommit.PreCommitUploadCommit;
import com.teamscale.index.precommit.PreCommitUploadStagingIndex;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.committree.AdjustAllCommits;
import com.teamscale.index.repository.committree.ICommitTreeNodeAdjuster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.lang.SilentAutoClosable;

public class PreCommitUploadChangeRetriever
extends ExternalUploadChangeRetrieverBase {
    private static final Logger LOGGER = LogManager.getLogger();
    static final String REVISION_PREFIX = "Pre-Commit Upload: ";
    public static final String REPOSITORY_IDENTIFIER = "precommit";
    @BranchingLayerAccess(value=PreCommitUploadStagingIndex.class)
    private IBranchingLayer preCommitUploadBranchingLayer;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="precommit-commit-tree")
    private CommitTreeIndex commitTreeIndex;

    @Override
    protected CommitDescriptor executeAndReturnCommitResult() throws StorageException, RescheduleRequestedException {
        try (SilentAutoClosable ignoredUnlockAction = PreCommitUploadStagingIndex.obtainLock(this.getLockProvider(), this.getProjectId());){
            CommitDescriptor commitDescriptor = super.executeAndReturnCommitResult();
            return commitDescriptor;
        }
    }

    @Override
    protected ICommitTreeNode addNode(IChangeRetrieverCommitTree commitTree, ParentedCommitDescriptor commit, List<CommitTreeRevision> parentRevisions) throws StorageException, RepositoryNeedsRollbackException {
        CommitDescriptor injectedParent = this.determineInjectedParent(commit);
        if (injectedParent != null && this.commitDescriptorIndex.getCommit(injectedParent) == null) {
            throw new RepositoryNeedsRollbackException("The injected parent commit " + String.valueOf(injectedParent) + " does not exist! Resetting pre-commits on branch " + commit.getBranchName(), Collections.singletonMap(commit.getBranchName(), 1L));
        }
        Optional latestOnBranch = commitTree.getLatestContainedRevisionForBranch(commit.getBranchName());
        if (latestOnBranch.isPresent() && parentRevisions.isEmpty()) {
            throw new RepositoryNeedsRollbackException("Added commit " + String.valueOf(commit) + " should reference latest revision " + (String)latestOnBranch.get() + " has no parents! Resetting pre-commits on branch " + commit.getBranchName(), Collections.singletonMap(commit.getBranchName(), 1L));
        }
        return commitTree.addNode(PreCommitUploadChangeRetriever.toCommitTreeRevision((CommitDescriptor)commit), commit.getTimestamp(), parentRevisions, CCSMAssert::fail, injectedParent);
    }

    private @Nullable CommitDescriptor determineInjectedParent(ParentedCommitDescriptor commit) throws StorageException {
        IStore storeForCommit = this.preCommitUploadBranchingLayer.openStore(HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        PreCommitUploadCommit commitInfo = (PreCommitUploadCommit)((Object)new PreCommitUploadStagingIndex(storeForCommit).getCommitInfo());
        CCSMAssert.isNotNull((Object)((Object)commitInfo), (String)("commitInfo for " + String.valueOf(commit) + " was unexpectedly null"));
        CommitDescriptor injectedParent = commitInfo.getParentCommit();
        if (injectedParent.getBranchName().equals(commit.getBranchName())) {
            return null;
        }
        return injectedParent;
    }

    @Override
    protected void validateLatestContainedRevisionForBranch(@Nullable String latestContainedRevisionForBranch, ParentedCommitDescriptor commit) throws RepositoryNeedsRollbackException {
        if (PreCommitUtils.isPrecommitBranchName((String)commit.getBranchName())) {
            return;
        }
        if (latestContainedRevisionForBranch != null && !latestContainedRevisionForBranch.equals(String.valueOf(commit.getTimestamp()))) {
            throw new RepositoryNeedsRollbackException("Earlier commit '%s' present on this precommit branch, which needs to be rolled back.".formatted(commit.getTimestamp()), Collections.singletonMap(commit.getBranchName(), 1L));
        }
    }

    @Override
    protected boolean isCodeUpload() {
        return true;
    }

    @Override
    protected String getRepositoryIdentifier() {
        return REPOSITORY_IDENTIFIER;
    }

    @Override
    protected CommitTreeIndex getCommitTreeIndex() {
        return this.commitTreeIndex;
    }

    @Override
    protected IBranchingLayer getUploadBranchingLayer() {
        return this.preCommitUploadBranchingLayer;
    }

    @Override
    protected ICommitTreeNodeAdjuster getCommitTreeNodeAdjuster() {
        return new AdjustAllCommitsForPreCommit(this.timestampAdjustmentIndex, this.commitDescriptorIndex);
    }

    private static class AdjustAllCommitsForPreCommit
    extends AdjustAllCommits {
        private final CommitDescriptorIndex commitDescriptorIndex;

        private AdjustAllCommitsForPreCommit(TimestampAdjustmentIndex timestampAdjustmentIndex, CommitDescriptorIndex commitDescriptorIndex) {
            super(timestampAdjustmentIndex);
            this.commitDescriptorIndex = commitDescriptorIndex;
        }

        @Override
        protected List<CommitTreeNode> filterNodesToAdjust(List<CommitTreeNode> nodesToAdjust) {
            ArrayList<CommitTreeNode> result = new ArrayList<CommitTreeNode>();
            HashSet<CommitTreeRevision> blockedRevisions = new HashSet<CommitTreeRevision>();
            for (CommitTreeNode node : nodesToAdjust) {
                block4: {
                    block3: {
                        if (this.hasInjectedParentThatIsNotYetKnown(node)) break block3;
                        if (!node.getParentRevisions().stream().anyMatch(blockedRevisions::contains)) break block4;
                    }
                    blockedRevisions.add(node.getRevision());
                    continue;
                }
                result.add(node);
            }
            return result;
        }

        private boolean hasInjectedParentThatIsNotYetKnown(CommitTreeNode node) {
            try {
                CommitDescriptor injectedParent = node.getInjectedParent();
                return injectedParent != null && this.commitDescriptorIndex.getCommit(injectedParent) == null;
            }
            catch (StorageException e) {
                LOGGER.error("Had storage exception while checking for branch existence!", (Throwable)e);
                return true;
            }
        }
    }
}

